#ifndef	__DSOUNDENV_H__
#define	__DSOUNDENV_H__

#ifndef	__WAVEFILE_H__
#include	"WaveFile.h"
#endif

#ifndef	__SOUNDOBJECT_H__
#include "SoundObject.h"
#endif
class	CDSHighResTimer;
//-----------------------------------------------------------------------------
// Name: class CSoundManager
// Desc: 
//-----------------------------------------------------------------------------
class CDSoundEnv
{
protected:
    LPDIRECTSOUND8 m_pDS;
	DWORD	m_dwPrimaryChannels;
	DWORD	m_dwPrimaryFS;
	DWORD	m_dwPrimaryBitRate;
	TCHAR	m_strAppPathName[MAX_PATH];

	void PrepareAppPathName();
	CSoundObject	*m_pObjectRoot;
	CSoundObject	m_soDummy;
	CDSHighResTimer	*m_pTimer;

public:
    CDSoundEnv(DWORD dwChannels, DWORD dwFS, DWORD dwBitRate );
    virtual ~CDSoundEnv();

    HRESULT Initialize( HWND hWnd, DWORD dwCoopLevel );
    LPDIRECTSOUND8 GetDirectSound();
    HRESULT SetPrimaryBufferFormat();
	TCHAR	*GetAppPathName();
	void	AddSoundObject(CSoundObject *pObj);
	void	RemoveSoundObject(CSoundObject *pObj);
	void	PollStatus();
};

#endif
