//-----------------------------------------------------------------------------
// File: AVIVideoTexture.h
//
// Desc: 
//-----------------------------------------------------------------------------
#ifndef	__AVIVIDEOTEXTURE_H__
#define	__AVIVIDEOTEXTURE_H__

#define	AVIVIDEOTEXTURE_PHASE_CREATED	0
#define	AVIVIDEOTEXTURE_PHASE_PREPARED	1
#define	AVIVIDEOTEXTURE_PHASE_PLAYING	2
#define	AVIVIDEOTEXTURE_PHASE_PAUSED	3
#define	AVIVIDEOTEXTURE_PHASE_END		4

#define    kNumTextures    2

typedef    struct{
    LONG    m_lTextureWidth;
    LONG    m_lTextureHeight;
}    TextureSize;

//--------------------------------------------------------------
//    CAVIVideoTexture
//--------------------------------------------------------------
class    CAVIVideoTexture : public CGraphicsObject
{
public:
    CAVIVideoTexture(CD3DEnv *pEnv,PAVISTREAM pVideoStream);
    virtual ~CAVIVideoTexture();
    virtual HRESULT    InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
    virtual HRESULT RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
    virtual HRESULT InvalidateDeviceObjects();
    virtual HRESULT DeleteDeviceObjects();
    LPDIRECT3DTEXTURE9    GetRenderableTexture();
    void    GetRenderableTextureSize(int *x, int *y);
    void    GetVideoSize(int *x, int *y);
    BOOL    IsPlaying(){    return    m_dwPhase == AVIVIDEOTEXTURE_PHASE_PLAYING;    }
	void	Rewind();
    //long    CheckMovieStatus(BOOL bLoop);
	void	Pause();
	void	Run();
	void	Stop();
	void	DoThread();
	void	Lock();
	void	Unlock();
protected:
    LPDIRECT3DTEXTURE9  m_ppTextures[kNumTextures];    //
	TextureSize			m_TextureSize[kNumTextures];	//  eNX`TCY

	CD3DEnv             *m_pD3DEnv;
    BOOL                m_bPlaying;
	DWORD				m_dwThreadID;
	HANDLE				m_hThread;
	BOOL				m_bTerminateThread;
	BOOL				m_bThreadAlive;
	PAVISTREAM			m_pVideoStream;
	LONG				m_lVidWidth;
	LONG				m_lVidHeight;
	LONG				m_lVidPitch;
	D3DFORMAT           m_TextureFormat;
	INT					m_iRenderableTexture;
	CRITICAL_SECTION	m_semaphore;
	LONG				m_lCurrentVideoTime;
	LONG				m_lOldTime;
	DWORD				m_dwPhase;
};

#endif
