//
//    VideoTexture.cpp
//

#include "stdafx.h"
#include <d3dx9.h>
#include <mmsystem.h>
#include <stdio.h>
#include <d3d9types.h>
#include <crtdbg.h>
#include "d3d9env.h"
#include <vfw.h>
#include <mmreg.h>
#include <msacm.h>
#include "AVIVideoTexture.h"

static DWORD WINAPI ThreadProc(LPVOID lp);

//
//    class:    CAVIVideoTexture
//    
CAVIVideoTexture::CAVIVideoTexture(CD3DEnv *pEnv,PAVISTREAM pVideoStream){
    int    i;
    for (i = 0; i < kNumTextures ; ++i){
        m_ppTextures[i] = NULL;
		m_TextureSize[i].m_lTextureWidth  = -1;
		m_TextureSize[i].m_lTextureHeight = -1;
    }
    m_bPlaying = false;

    m_pD3DEnv = pEnv;
    m_pVideoStream = pVideoStream;
    pEnv->AddGraphicsObject(this);
    m_hThread = NULL;
	m_lVidWidth = -1;
	m_lVidHeight= -1;

	InitializeCriticalSection(&m_semaphore);
	m_dwPhase = AVIVIDEOTEXTURE_PHASE_CREATED;
	m_lCurrentVideoTime = 0;
}

CAVIVideoTexture::~CAVIVideoTexture(){
	InvalidateDeviceObjects();
	DeleteDeviceObjects();
	InitializeCriticalSection(&m_semaphore);
	DeleteCriticalSection(&m_semaphore);
	m_pD3DEnv->RemoveGraphicsObject(this);
}

//-----------------------------------------------------------------------------
// Init : rfIĐB
//-----------------------------------------------------------------------------
HRESULT CAVIVideoTexture::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (m_hThread == NULL){
		m_bTerminateThread = FALSE;
		m_hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadProc, (LPVOID)this, 0, &m_dwThreadID);
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_PREPARED;
	}
	return	S_OK;
}

HRESULT CAVIVideoTexture::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){

	return    S_OK;
}

HRESULT CAVIVideoTexture::InvalidateDeviceObjects(){

	return    S_OK;
}
HRESULT CAVIVideoTexture::DeleteDeviceObjects(){
	if (m_hThread != NULL){
		m_bTerminateThread = TRUE;
		while(m_bThreadAlive){
			Sleep(10);
		}
		CloseHandle(m_hThread);
		m_hThread = NULL;
		for (int i = 0; i < kNumTextures ; ++i){
			if (m_ppTextures[i] != NULL){
				m_ppTextures[i]->Release();
				m_ppTextures[i] = NULL;
			}
		}


	}
    return    S_OK;
}

LPDIRECT3DTEXTURE9    CAVIVideoTexture::GetRenderableTexture (){
    int    iRenderableTexture = m_iRenderableTexture;
    if (iRenderableTexture < 0)
        return    NULL;
    return    m_ppTextures[iRenderableTexture];
}

void    CAVIVideoTexture::GetRenderableTextureSize(int *x, int *y){
    *x = -1;
    *y = -1;
    int    iRenderableTexture = m_iRenderableTexture;
	if (iRenderableTexture < 0)
		return;
	*x = m_TextureSize[iRenderableTexture].m_lTextureWidth;
	*y = m_TextureSize[iRenderableTexture].m_lTextureHeight;
}

void    CAVIVideoTexture::GetVideoSize(int *x, int *y){
	*x = (INT)m_lVidWidth;
	*y = (INT)m_lVidHeight;
}


void CAVIVideoTexture::Run(){
	if (m_dwPhase != AVIVIDEOTEXTURE_PHASE_PLAYING){
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_PREPARED;
		m_lOldTime = timeGetTime();
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_PLAYING;
	}
}

void CAVIVideoTexture::Stop(){
	if (m_dwPhase == AVIVIDEOTEXTURE_PHASE_PLAYING){
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_END;
		m_lCurrentVideoTime = 0;
	}
}
void CAVIVideoTexture::Rewind(){
	if (m_dwPhase == AVIVIDEOTEXTURE_PHASE_PLAYING){
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_END;
	}
	m_lCurrentVideoTime = 0;
	m_lOldTime = timeGetTime();
}
void CAVIVideoTexture::Pause(){
	if (m_dwPhase == AVIVIDEOTEXTURE_PHASE_PLAYING){
		m_dwPhase = AVIVIDEOTEXTURE_PHASE_PAUSED;
	}
}
#if	0
HRESULT CAVIVideoTexture::GetState(LONG msec,OAFilterState *pfs){
	HRESULT	hr = S_OK;
	if (m_pMC != NULL)
		hr = m_pMC->GetState( msec, pfs);
	return	hr;
}
#endif

void CAVIVideoTexture::DoThread(){
	LONG             i,lCurrent;
	LONG             lStart, lEnd;
	LONG             lSize;
	HWND             hWnd;
	LPBYTE           lpBits;
	AVISTREAMINFO    asi;
	BITMAPINFOHEADER bih;
	BOOL			bOffscreen = FALSE;
	HIC				hic =NULL;	//	C[WfRvbTւ̃nh

	m_bThreadAlive = true;
	lStart = AVIStreamStart(m_pVideoStream);
	DWORD	st = timeGetTime();
	DWORD	ct;
	lEnd   = lStart + AVIStreamLength(m_pVideoStream);
	lCurrent = lEnd+1;
	AVIStreamInfo(m_pVideoStream, &asi, sizeof(AVISTREAMINFO));
	m_iRenderableTexture = -1;

	hic = ICOpen(mmioFOURCC('V', 'I', 'D', 'C'),asi.fccHandler,ICMODE_DECOMPRESS);

	lSize = sizeof(BITMAPINFOHEADER);
	AVIStreamReadFormat(m_pVideoStream, lStart, &bih, &lSize);
	m_lVidWidth = bih.biWidth;
	m_lVidHeight = bih.biHeight;
	m_lVidPitch = (m_lVidWidth * 3 + 3) & ~(3);	//	4oCgɃACgƂ

	/*
	 *	fR[ho͐DibSection 쐬B
	 */
    HDC hDC = CreateCompatibleDC( NULL );
	HBITMAP	hbmBitmap = NULL;
	BYTE	*pBitmapBits;

    BITMAPINFO bmiOut;
    ZeroMemory( &bmiOut.bmiHeader,  sizeof(BITMAPINFOHEADER) );
    bmiOut.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
    bmiOut.bmiHeader.biWidth       =  (int)m_lVidWidth;
    bmiOut.bmiHeader.biHeight      = -(int)m_lVidHeight;
    bmiOut.bmiHeader.biPlanes      = 1;
    bmiOut.bmiHeader.biCompression = BI_RGB;
    bmiOut.bmiHeader.biBitCount    = 24;
	hbmBitmap = CreateDIBSection( hDC, &bmiOut, DIB_RGB_COLORS,
											  (VOID**)&pBitmapBits, NULL, 0 );
	if (hic != NULL)
		ICDecompressBegin(hic, &bih, &bmiOut.bmiHeader);

	/*    
     *    eNX`̃tbsOsו̃eNX`𐶐B
     */
	LPDIRECT3DDEVICE9	lpd3ddev;
	HRESULT hr = S_OK;
	m_pD3DEnv->GetD3DDevice(&lpd3ddev);
    if( FAILED( hr = D3DXCreateTexture(lpd3ddev,
                    m_lVidWidth, m_lVidHeight,
                    1, 0, 
                    D3DFMT_A8R8G8B8, 
                    D3DPOOL_MANAGED, &m_ppTextures[0] ) ) ){
        _RPT1(_CRT_WARN,TEXT("eNX`Ɏs܂I  hr=0x%x"), hr);
	}else{
		D3DSURFACE_DESC ddsd;
		D3DFORMAT    fmtPrimary;
		if ( FAILED( hr = m_ppTextures[0]->GetLevelDesc( 0, &ddsd ) ) ) {
			_RPT1(_CRT_WARN,TEXT("eNX`̎擾Ɏs܂I hr = 0x%x"), hr);
		}else{
			m_TextureSize[0].m_lTextureWidth  = ddsd.Width;
			m_TextureSize[0].m_lTextureHeight = ddsd.Height;

			fmtPrimary = ddsd.Format;
			for (int i = 1; i < kNumTextures ; ++i){
				if( FAILED( hr = D3DXCreateTexture(lpd3ddev,
								m_lVidWidth, m_lVidHeight,
								1, 0, 
								fmtPrimary, D3DPOOL_MANAGED, &m_ppTextures[i] ) ) )
				{
					_RPT1(_CRT_WARN,TEXT("eNX`Ɏs܂I  hr=0x%x"), hr);
				}else{
					// D3DXCreateTexture ۂɍeNX`̃TCY擾
					if ( FAILED( hr = m_ppTextures[i]->GetLevelDesc( 0, &ddsd ) ) ) {
						_RPT1(_CRT_WARN,TEXT("eNX`̎擾Ɏs܂I hr = 0x%x"), hr);
					}else{
						m_TextureFormat = ddsd.Format;
						if (m_TextureFormat == fmtPrimary){
							m_TextureSize[i].m_lTextureWidth  = ddsd.Width;
							m_TextureSize[i].m_lTextureHeight = ddsd.Height;
						}
					}
				}
			}
		}
	}
	
	while (!m_bTerminateThread) {
		while (true) {
			if (m_dwPhase != AVIVIDEOTEXTURE_PHASE_PLAYING)
				goto	frame_conversion_end;
			LONG	tc = timeGetTime();
			m_lCurrentVideoTime += tc - m_lOldTime;
			m_lOldTime = tc;
			i = AVIStreamTimeToSample(m_pVideoStream,(LONG)m_lCurrentVideoTime);
			if (i >= lEnd){
				i = lEnd;
				lCurrent = lEnd;
				m_dwPhase = AVIVIDEOTEXTURE_PHASE_END;
				m_bPlaying = FALSE;
			}

			if (lCurrent != i){

				if (i > (lCurrent + 1)){
					_RPT0(_CRT_WARN,_T("Frame Dropped\n"));
					++lCurrent;
					for (int j = 0; j < 4 ; ++j){
						//	up to x4
						lSize = sizeof(BITMAPINFOHEADER);
						AVIStreamReadFormat(m_pVideoStream, lCurrent, &bih, &lSize);

						lpBits = new BYTE[ bih.biSizeImage ];
						
						AVIStreamRead(m_pVideoStream, lCurrent, 1, lpBits, bih.biSizeImage, NULL, NULL);
						
						if (hic != NULL){
							DWORD err;
							err = ICDecompress(hic,0,&bih,lpBits,&bmiOut.bmiHeader,pBitmapBits);
							if (ICERR_OK != err){
								_RPT4(_CRT_WARN,_T("ICDecompress failed. frame %d,%d,%d:%d\n"),lCurrent,m_lVidWidth,m_lVidHeight,err);
							}
						}
						delete	lpBits;
						if (i <= ++lCurrent)
							break;
					}
				}else{
					lCurrent = i;
				}


				lSize = sizeof(BITMAPINFOHEADER);
				AVIStreamReadFormat(m_pVideoStream, lCurrent, &bih, &lSize);

				lpBits = new BYTE[bih.biSizeImage];

				AVIStreamRead(m_pVideoStream, lCurrent, 1, lpBits, bih.biSizeImage, NULL, NULL);

				if (hic != NULL){
					DWORD err;
					err = ICDecompress(hic,0,&bih,lpBits,&bmiOut.bmiHeader,pBitmapBits);
					if (ICERR_OK != err){
						_RPT4(_CRT_WARN,_T("ICDecompress failed. frame %d,%d,%d:%d\n"),lCurrent,m_lVidWidth,m_lVidHeight,err);
					}
				}
				delete	lpBits;

				//	eNX`ւ̓]s
				UINT	uiToRender = 0;
				if (m_iRenderableTexture >= 0){
					uiToRender = m_iRenderableTexture;
					uiToRender++;
					uiToRender %= kNumTextures;
				}
				// eNX`bN
			    D3DLOCKED_RECT d3dlr;

				if (FAILED(m_ppTextures[uiToRender]->LockRect(0, &d3dlr, 0, 0))){
					hr = E_FAIL;
					continue;
				}
				// eNX`obt@Ƃ̂x̃sb`擾
				BYTE  *pTxtBuffer;     // Bitmap obt@, texture obt@
				LONG  lTxtPitch;                    // eNX`̃sb`

				pTxtBuffer = static_cast<byte *>(d3dlr.pBits);
				lTxtPitch = d3dlr.Pitch;    //    eNX`̃sb`

				//	eNX`ɓ]I
				// 摜̃Rs[  
				if (m_TextureFormat == D3DFMT_A8R8G8B8) {
					_asm{
						mov    edi, pTxtBuffer ;
						mov    esi, pBitmapBits ;
						mov ebx, this;
						mov ecx, [ebx].m_lVidHeight;
						mov eax, [ebx].m_lVidPitch;
						mov    ebx, eax;

			transfer_loop_y1:
						push    edi;
						push    esi;
						push    ecx;
						push    ebx;

						mov    ebx, this;
						mov    ecx, [ebx].m_lVidWidth;

						mov    dl, 0xff;
			transfer_loop1:
						mov    al, byte ptr[esi];
						mov    byte ptr[edi], al;
						mov    al, byte ptr[esi+1];
						mov    byte ptr[edi+1], al;
						mov    al, byte ptr[esi+2];
						mov    byte ptr[edi+2], al;
						mov    byte ptr[edi+3], dl;
						add    esi, 3;
						add    edi, 4;
						dec    ecx;
						jnz    transfer_loop1;

						pop    ebx;
						pop    ecx;
						pop    esi;
						pop    edi;
						add    esi, ebx;
						mov    edx, lTxtPitch;
						add    edi, edx
						dec    ecx;
						jnz    transfer_loop_y1;
					}
				}else if (m_TextureFormat == D3DFMT_A1R5G5B5) {
					_asm{
						mov    edi, pTxtBuffer ;
						mov    esi, pBitmapBits ;
						mov ebx, this;
						mov ecx, [ebx].m_lVidHeight;
						mov eax, [ebx].m_lVidPitch;
						mov    ebx, eax;

			transfer_loop_y2:

						push    edi;
						push    esi;
						push    ecx;
						push    ebx;

						mov    ebx, this;
						mov    ecx, [ebx].m_lVidWidth;
			transfer_loop2:
						mov     ah, 1                ;
						mov    al, byte ptr[esi+2]    ;
						shl ax, 5                ;
						mov al, byte ptr[esi+1]    ;
						shl ax, 2                ;
						and al, 0xe0            ;
						mov    dl, byte ptr[esi]    ;
						shr dl, 3                ;
						add al, dl                ;
						mov    word ptr[edi], ax    ;
						add    esi, 3;
						add    edi, 2;
						dec    ecx;
						jnz    transfer_loop2;

						pop    ebx;
						pop    ecx;
						pop    esi;
						pop    edi;
						mov    edx, lTxtPitch;
						add    edi, edx
						add    esi, ebx;
						dec    ecx;
						jnz    transfer_loop_y2;
					}
				}
				// eNX`̃AbN
				if (FAILED(m_ppTextures[uiToRender]->UnlockRect(0))){
					hr = E_FAIL;
					continue;
				}
				Lock();
				m_iRenderableTexture = uiToRender;
				Unlock();

			}
frame_conversion_end:
			if (m_bTerminateThread)
				break;
			Yield();
		}
	}
	
	if (hic != NULL){
		ICDecompressEnd(hic);
		ICClose(hic);
		hic = NULL;
	}
	if (hDC)
		DeleteDC( hDC );
	if (hbmBitmap)
		DeleteObject( hbmBitmap );
	hDC = NULL;
	hbmBitmap = NULL;
	pBitmapBits = NULL;
	m_bThreadAlive = false;
}


static DWORD WINAPI ThreadProc(LPVOID lp)
{
	CAVIVideoTexture	*lpTmp = (CAVIVideoTexture*)lp;
	lpTmp->DoThread();
	return 0;
}


void	CAVIVideoTexture::Lock(){
	EnterCriticalSection(&m_semaphore);
}

void	CAVIVideoTexture::Unlock(){
	LeaveCriticalSection(&m_semaphore);
}
