#pragma once
#include <vfw.h>
#include <mmreg.h>
#include <msacm.h>
#include "DSQuickLib.h"

//#define	AVIPCMSOUNDSTREAM_NUM_BLOCKS	STREAMSOUND_NUM_BLOCKS
#define	AVIPCMSOUNDSTREAM_NUM_BLOCKS	2

class CPCMStreamForAVIStream :
	public CSoundObject
{
public:
	CPCMStreamForAVIStream(CDSoundEnv *pEnv, PAVISTREAM lpAudioStream);
	virtual ~CPCMStreamForAVIStream(void);
	virtual void DoThread();
	void	PollStatus(FLOAT timeElapsed);
	HRESULT	Prepare();

	virtual HRESULT Play( DWORD dwPriority = 0, DWORD dwFlags = 0, LONG lVol = 0, LONG lFreq = -1, LONG lPan = 0 , LONG lFade = 0);
    virtual HRESULT Stop();
	virtual HRESULT Rewind();
	virtual void	FadeOut(LONG lFadeLen);
	HRESULT	Pause();
	virtual BOOL	IsPlaying(){	return	m_dwPhase == STREAMSOUND_RUN;	};
protected:
	HRESULT		Create();
	HRESULT		FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB);
	HRESULT		SetNotify();
	LONG		ConvertAviSampleToPcmSample(LONG aviSample, LONG *pSurplus = NULL);
	LONG		ConvertPcmSampleToAviSample(LONG pcmSample, LONG *pSurplus = NULL);
	HRESULT		AviStreamReadAndDecode(void *buffer, LONG lSize);
	CDSoundEnv	*m_pDSoundEnv;
    DWORD       m_dwDSBufferSize;
	PAVISTREAM	m_lpAudioStream;
	AVISTREAMINFO	m_asInfo;
	LPWAVEFORMATEX	m_lpwfAvi;
	LONG		m_lAviStart;
	LONG		m_lAviEnd;
	DWORD		m_lAviSamplePerSec;
	DWORD		m_dwAviCurrentPos;	//	In PcmSample
	DWORD		m_lAviRead;
	WAVEFORMATEX	m_wfPcm;
	DWORD		m_dwSizeConverted;
	HACMSTREAM  m_hAcmStream;

	BYTE		*m_pPcmBuffer;			//	PCM Buffer (target to convert)
	BYTE		*m_pPcmBufferCurrent;	//	CurrentPos in m_pPcmBuffer
	LONG		m_dwPcmBufferSizeRemain;	//	Size of PCM Buffer
	DWORD		m_dwPcmBufferSize;

	ACMSTREAMHEADER	m_acmStreamHeader;	//
	BYTE		*m_lpAviData;
	LONG		m_dwAviDataSize;


	HANDLE      m_hNotificationEvent[AVIPCMSOUNDSTREAM_NUM_BLOCKS];
	HANDLE		m_hTerminator;

	DWORD       m_dwThreadID;
	HANDLE      m_hThread;
	
	LPDIRECTSOUNDBUFFER	m_lpDSBuffer;
	LONG		m_lVol;
	LONG		m_lFreq;
	LONG		m_lPan;
	LONG		m_lCurrentPosition;
	
	BOOL		m_bThreadDone;
	BOOL		m_bThreadActive;

	DWORD		m_dwNumNotification;
    DWORD		m_dwNotifySize;
	DWORD		m_dwBufferLengthInSec;

	DWORD		m_dwLastPlayPos;
    DWORD		m_dwPlayProgress;
    DWORD		m_dwNextWriteOffset;

	DWORD		m_dwPhase;
	DWORD		m_dwPhaseAfterReplay;
	FLOAT		m_fFadeTime;
	FLOAT		m_fFadeLen;
	CRITICAL_SECTION	m_CriticalSection;

	HRESULT		RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored );

	HRESULT		Reset();
	HRESULT		HandleNotificationEvent();
};
