#include "StdAfx.h"
#include <mmsystem.h>
#include <dxerr9.h>
#include <dsound.h>
#include <crtdbg.h>

#include "DSQuickLib.h"
#include "PCMStreamForAVIStream.h"

DWORD WINAPI AVIStreamPlayback_DoThread(LPVOID pVoid);
#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#define SAFE_CLOSEHANDLE(h) { if(h) { CloseHandle(h);   (h)=NULL; } }

CPCMStreamForAVIStream::CPCMStreamForAVIStream(CDSoundEnv *pEnv, PAVISTREAM lpAudioStream)
{
	m_pDSoundEnv = pEnv;
	m_lpAudioStream = lpAudioStream;
	m_lpwfAvi = NULL;

	m_dwDSBufferSize = 0L;
	m_hThread = NULL;
	m_dwThreadID = 0;
	for (int i = 0; i < AVIPCMSOUNDSTREAM_NUM_BLOCKS ; ++i)
		m_hNotificationEvent[i] = NULL;
	m_hTerminator = NULL;
	m_lpDSBuffer = NULL;

	m_dwNumNotification = AVIPCMSOUNDSTREAM_NUM_BLOCKS;	//	obt@̕E쐬r
	m_dwBufferLengthInSec = AVIPCMSOUNDSTREAM_NUM_BLOCKS;		//	ftHg̃obt@PubNPb

	InitializeCriticalSection(&m_CriticalSection);

	m_dwPhase = 0;
	m_bThreadActive = FALSE;
	m_bThreadDone = FALSE;

	m_lpAviData = NULL;
	m_dwAviDataSize = 0;

	m_pPcmBuffer = NULL;
	m_pPcmBufferCurrent = NULL;
	m_dwPcmBufferSizeRemain = 0;
	m_hAcmStream = NULL;

	pEnv->AddSoundObject(this);
}

CPCMStreamForAVIStream::~CPCMStreamForAVIStream(void)
{
	m_bThreadDone = TRUE;
	if (m_hTerminator != NULL){
		SetEvent(m_hTerminator);
		while(m_bThreadActive){
			Sleep(10);
		}
		SAFE_CLOSEHANDLE(m_hThread);
	}
	for (int i = 0; i < AVIPCMSOUNDSTREAM_NUM_BLOCKS ; ++i)
		SAFE_CLOSEHANDLE(m_hNotificationEvent[i]);
	if (m_hAcmStream != NULL){
		acmStreamUnprepareHeader(m_hAcmStream,&m_acmStreamHeader,0);
		acmStreamClose(m_hAcmStream,0);
	}

	DeleteCriticalSection(&m_CriticalSection);
	SAFE_CLOSEHANDLE(m_hTerminator);
	SAFE_RELEASE(m_lpDSBuffer);
	SAFE_DELETE(m_lpwfAvi);
	SAFE_DELETE_ARRAY(m_pPcmBuffer);
	SAFE_DELETE_ARRAY(m_lpAviData);
	m_pDSoundEnv->RemoveSoundObject(this);
}

//
//	Đ
//
HRESULT	CPCMStreamForAVIStream::Prepare(){
	LONG           lSize;

	//	Xg[TCY̊mF
	m_lAviStart = AVIStreamStart(m_lpAudioStream);
	m_lAviEnd   = m_lAviStart + AVIStreamLength(m_lpAudioStream);
	m_dwAviCurrentPos = 0;

	if (m_lAviEnd <= m_lAviStart){
		_RPT0(_CRT_WARN,"Stream Ƀf[^܂B");
        goto e_Fail;
    }
	AVIStreamInfo(m_lpAudioStream,&m_asInfo, sizeof(AVISTREAMINFO));
	
	//	Xg[tH[}bg̎擾
	AVIStreamReadFormat(m_lpAudioStream, m_lAviStart, NULL, &lSize);
	SAFE_DELETE(m_lpwfAvi);
	m_lpwfAvi = (LPWAVEFORMATEX)new BYTE[lSize];
	AVIStreamReadFormat(m_lpAudioStream, m_lAviStart, m_lpwfAvi, &lSize);

	//	AVI TvTCY̎Zo(P:PCM Tv)
	if (0 != m_asInfo.dwRate % m_asInfo.dwScale){
		_RPT0(_CRT_WARN,_T("Warning:AVI sample not aligned to 1 sec.\n"));
	}
	m_lAviSamplePerSec = m_asInfo.dwRate / m_asInfo.dwScale;

	//	ĐtH[}bǧ
	m_wfPcm.cbSize = sizeof(WAVEFORMATEX);
	m_wfPcm.wFormatTag = WAVE_FORMAT_PCM;
	m_wfPcm.nSamplesPerSec = m_lpwfAvi->nSamplesPerSec;
	if (m_lpwfAvi->wFormatTag == m_wfPcm.wFormatTag){
		m_wfPcm = *m_lpwfAvi;
	}else{
		if (0 != acmFormatSuggest(NULL, m_lpwfAvi, &m_wfPcm, sizeof(WAVEFORMATEX), ACM_FORMATSUGGESTF_WFORMATTAG|ACM_FORMATSUGGESTF_NSAMPLESPERSEC)){
			goto	e_Fail;
		}
	}


	DWORD	nAlign;
	nAlign = m_wfPcm.nBlockAlign;
	m_dwNotifySize = nAlign * (DWORD)m_wfPcm.nSamplesPerSec;
	m_dwNotifySize *= m_dwBufferLengthInSec;
	m_dwNotifySize /= m_dwNumNotification;
	m_dwNotifySize -= m_dwNotifySize % nAlign;

	for (int i = 0; i < AVIPCMSOUNDSTREAM_NUM_BLOCKS; ++i)
		m_hNotificationEvent[i] =  CreateEvent( NULL, FALSE, FALSE, NULL );
	DWORD	dwSizeConverted;
	LONG	lSurplus;
	dwSizeConverted = ConvertAviSampleToPcmSample(m_lAviEnd, &lSurplus);
	if (lSurplus != 0){
		dwSizeConverted++;
	}
	dwSizeConverted *= m_wfPcm.wBitsPerSample * m_wfPcm.nChannels / 8;
	m_dwSizeConverted = dwSizeConverted;


	if (FAILED(Create())){
		goto	e_Fail;
	}

	m_hTerminator =  CreateEvent( NULL, FALSE, FALSE, NULL );
	m_hThread = CreateThread(NULL,0,::AVIStreamPlayback_DoThread,(LPVOID)this,0,&m_dwThreadID);

	m_dwPhase = STREAMSOUND_STANDBY;
	return	S_OK;
e_Fail:
	SAFE_DELETE(m_lpwfAvi);
	return	E_FAIL;
}

//
//	AVI Xg[̃Tvԍ PCM Tvԍ֕ϊ
//	؂Ȃꍇ́AlSurplus ɏ]ԂBEE܂Ӗ
//
LONG	CPCMStreamForAVIStream::ConvertAviSampleToPcmSample(LONG aviSample, LONG *pSurplus){
	__int64	i;
	i = (__int64)aviSample * m_lpwfAvi->nSamplesPerSec;
	i *= m_asInfo.dwScale;
	LONG	lSurplus;
	lSurplus = (LONG)(i % m_asInfo.dwRate);
	if (pSurplus != NULL)
		*pSurplus = lSurplus;
	i /= m_asInfo.dwRate;
	return	(LONG)i;


}


//
//	PCM Tvԍ AVI Xg[̃Tvԍ֕ϊ
//	؂Ȃ́AlSurplus ɏ]Ԃ
LONG	CPCMStreamForAVIStream::ConvertPcmSampleToAviSample(LONG pcmSample, LONG *pSurplus){
	__int64	i;
	i = pcmSample;
	i *= m_asInfo.dwRate;
	i /= m_asInfo.dwScale;
	LONG	lSurplus;
	lSurplus = (LONG)(i % m_lpwfAvi->nSamplesPerSec);

	if (pSurplus != NULL)
		*pSurplus = lSurplus;
	i /= m_lpwfAvi->nSamplesPerSec;
	return	(LONG)i;
}


//
//	Xg[obt@̍\z
//
HRESULT	CPCMStreamForAVIStream::Create(){
	LPDIRECTSOUND8	pDS;
    DSBUFFERDESC dsbd;
	HRESULT	hr;


    if( m_pDSoundEnv == NULL )
        return CO_E_NOTINITIALIZED;

	m_dwDSBufferSize = m_dwNumNotification * m_dwNotifySize;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
    dsbd.dwSize          = sizeof(DSBUFFERDESC);
    dsbd.dwFlags         = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_CTRLPAN |
						   DSBCAPS_CTRLPOSITIONNOTIFY | 
                           DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_LOCSOFTWARE ;
    dsbd.dwBufferBytes   = m_dwDSBufferSize;
    dsbd.guid3DAlgorithm = GUID_NULL;
    dsbd.lpwfxFormat     = &m_wfPcm;
	pDS = m_pDSoundEnv->GetDirectSound();
	hr = pDS->CreateSoundBuffer( &dsbd, &m_lpDSBuffer, NULL );
	SAFE_RELEASE(pDS);
	if (FAILED(hr)){
		_RPT1(_CRT_WARN,_T("CreateSoundBuffer s 0x%x"),hr);
		goto	e_Fail;
	}
	SetNotify();

    m_dwLastPlayPos     = 0;
    m_dwPlayProgress    = 0;
    m_dwNextWriteOffset = 0;
    //m_bFillNextNotificationWithSilence = FALSE;
	FillBufferWithSound(m_lpDSBuffer);

	return	S_OK;
e_Fail:
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::AviStreamReadAndDecode()
// Desc: TEht@Cobt@ɓ]B 
//-----------------------------------------------------------------------------
HRESULT	CPCMStreamForAVIStream::AviStreamReadAndDecode(void *buffer,LONG lSize){
	HRESULT hr = E_FAIL;
	LONG	lPos = m_lAviRead;
	INT		bits = (m_wfPcm.wBitsPerSample *m_wfPcm.nChannels) / 8;
	LONG	lPcmSampleNum = lSize / bits;
	LONG	lAviSampleNum = ConvertPcmSampleToAviSample(lPcmSampleNum);
	BYTE	silence = (BYTE)(m_wfPcm.wBitsPerSample == 8 ? 128 : 0 );
	BYTE	*pwrite = (BYTE*)buffer;
	m_dwAviCurrentPos += lPcmSampleNum;

	BOOL	bFillWithSilence = FALSE;
	LONG	lWritten = 0;
	if (lPos < m_lAviStart){
		INT	iSize = m_lAviStart - lPos;
		INT pcmSize;
		if (iSize > lAviSampleNum)
			iSize = lAviSampleNum;

		pcmSize = (iSize * m_wfPcm.nSamplesPerSec) / m_lAviSamplePerSec;
		LONG	lSizeWrite = pcmSize * bits;
		//	AVIStream ̃TCYԂƕKႵȂ̂
		//	덷傫ƎvB
		//	EEA炭̏g鎖͖EEEÂEEEB
		if (lSizeWrite > lSize){
			lPos += (m_lAviSamplePerSec * lSize) / bits;
			lSizeWrite = lSize;
		}else{
			lPos += iSize;
		}

		FillMemory( (BYTE*) pwrite, (DWORD)lSizeWrite, silence );
		pwrite += lSizeWrite;
		lWritten += lSizeWrite;
	}

	while (lSize > lWritten){
		//	obt@Ɏc肪Ώ
		if (m_dwPcmBufferSizeRemain > 0){
			LONG	lSizeWrite = lSize - lWritten;
			if (lSizeWrite > m_dwPcmBufferSizeRemain){
				lSizeWrite = m_dwPcmBufferSizeRemain;
			}
			::CopyMemory((BYTE*)pwrite,m_pPcmBufferCurrent,lSizeWrite);
			pwrite += lSizeWrite;
			lWritten += lSizeWrite;
			m_pPcmBufferCurrent += lSizeWrite;
			m_dwPcmBufferSizeRemain -= lSizeWrite;
			if (m_dwPcmBufferSizeRemain <= 0){
				m_pPcmBufferCurrent = NULL;
				m_dwPcmBufferSizeRemain = 0;
			}else{
				continue;
			}
		}
		if (bFillWithSilence){
			//	ĐIĂc0 Ŗ߂
			LONG lSizeWrite = lSize - lWritten;
			ZeroMemory(pwrite,lSizeWrite);
			lWritten += lSizeWrite;
			break;
		}
		LONG	lBufferSize;
		LONG	lEnd = lPos + m_lAviSamplePerSec;
		if (lEnd > m_lAviEnd){
			//	ŏIubN̍Đ
			lEnd = m_lAviEnd;
			
			bFillWithSilence = TRUE;
		}
		LONG	numRead = lEnd - lPos;
		if (numRead <= 0){
			//	ǂݍރf[^͓ǂ܂Ȃ
			continue;
		}
		lBufferSize = m_dwAviDataSize;

		LONG	lNumBytesResult;
		LONG	lNumSamplesResult;
		hr = AVIStreamRead(m_lpAudioStream, lPos, numRead, m_lpAviData, lBufferSize, 
			&lNumBytesResult, &lNumSamplesResult);

		LONG	lPosSave = lPos;
		lPos += numRead;
		if (hr == AVIERR_BUFFERTOOSMALL){
			_RPT0(_CRT_WARN,_T("AVIERR_BUFFERTOOSMALL\n"));
		}
		if (hr == AVIERR_MEMORY){
			_RPT0(_CRT_WARN,_T("AVIERR_MEMORY\n"));
		}
		if (hr == AVIERR_FILEREAD){
			_RPT0(_CRT_WARN,_T("AVIERR_FILEREAD\n"));
		}

		m_pPcmBufferCurrent = m_pPcmBuffer;
		m_dwPcmBufferSizeRemain = 0;
		DWORD dwLengthSaved = m_acmStreamHeader.cbSrcLength;
		m_acmStreamHeader.cbSrcLength = lNumBytesResult;
		DWORD	dwFlag = 0;
		if (lPosSave <= m_lAviStart){
			dwFlag |= ACM_STREAMCONVERTF_START;
		}
		dwFlag |= ACM_STREAMCONVERTF_END;

		acmStreamConvert(m_hAcmStream, &m_acmStreamHeader, dwFlag);
		m_dwPcmBufferSizeRemain = m_acmStreamHeader.cbDstLengthUsed;

		m_acmStreamHeader.cbSrcLength = dwLengthSaved;
	}
	m_lAviRead = lPos;

	return	S_OK;
}


//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::FillBufferWithSound()
// Desc: TEht@Cobt@ɓ]B 
//-----------------------------------------------------------------------------
HRESULT CPCMStreamForAVIStream::FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB )
{
    HRESULT hr; 
    VOID*   pDSLockedBuffer      = NULL; // bNꂽobt@ւ̃|C^
    DWORD   dwDSLockedBufferSize = 0;    // bNꂽobt@̃TCY

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;

    if( FAILED( hr = RestoreBuffer( pDSB, NULL ) ) ) {
        _RPT0(_CRT_WARN,  _T("RestoreBuffer"));
		return	hr;
	}
	if (m_dwPlayProgress != 0){
		m_dwAviCurrentPos = m_dwPlayProgress;
	}
	m_lAviRead = ConvertPcmSampleToAviSample(m_dwAviCurrentPos);
	


	//	PCM ϊ̏

	if (m_hAcmStream != NULL){
		acmStreamUnprepareHeader(m_hAcmStream,&m_acmStreamHeader,0);
		acmStreamClose(m_hAcmStream,0);
		m_hAcmStream = NULL;
	}
	MMRESULT mmr = acmStreamOpen(&m_hAcmStream, NULL, m_lpwfAvi, &m_wfPcm, NULL, 0, 0, ACM_STREAMOPENF_NONREALTIME);
	if (mmr != 0) {
		if (mmr == ACMERR_NOTPOSSIBLE)
			_RPT0(_CRT_WARN,_T("vꂽ͎sł܂B"));
		m_hAcmStream = NULL;
		return	E_FAIL;
	}
	SAFE_DELETE_ARRAY(m_lpAviData);
	m_dwAviDataSize = m_asInfo.dwRate * m_asInfo.dwSampleSize;
	m_dwAviDataSize += m_asInfo.dwScale - 1;
	m_dwAviDataSize /= m_asInfo.dwScale;
	m_lpAviData = new BYTE[m_dwAviDataSize];

	SAFE_DELETE_ARRAY(m_pPcmBuffer);
	acmStreamSize(m_hAcmStream,m_dwAviDataSize,&m_dwPcmBufferSize,ACM_STREAMSIZEF_SOURCE);
	m_pPcmBuffer = new BYTE[m_dwPcmBufferSize];
	m_pPcmBufferCurrent = m_pPcmBuffer;
	m_dwPcmBufferSizeRemain = 0;

	ZeroMemory((BYTE*)&m_acmStreamHeader,sizeof(ACMSTREAMHEADER));
	m_acmStreamHeader.cbStruct = sizeof(ACMSTREAMHEADER);
	m_acmStreamHeader.pbSrc = m_lpAviData;
	m_acmStreamHeader.cbSrcLength = m_dwAviDataSize;
	m_acmStreamHeader.pbDst = m_pPcmBuffer;
	m_acmStreamHeader.cbDstLength = m_dwPcmBufferSize;

	mmr = acmStreamPrepareHeader(m_hAcmStream,&m_acmStreamHeader,0);
	if (mmr != 0){
		_RPT0(_CRT_WARN,_T("acmStreamHeader ̏Ɏs\n"));
		if (mmr == MMSYSERR_INVALHANDLE){
		}
	}

	//	TEhobt@̃bN
	if( FAILED( hr = pDSB->Lock( 0, m_dwDSBufferSize, 
                                 &pDSLockedBuffer, &dwDSLockedBufferSize, 
								 NULL, NULL, 0L ) ) ){
        _RPT1(_CRT_WARN, _T("Lock"), hr );
		return	hr;
	}

	AviStreamReadAndDecode((BYTE*) pDSLockedBuffer,dwDSLockedBufferSize);

    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::RestoreBuffer()
// Desc: ꂽobt@XgA
//-----------------------------------------------------------------------------
HRESULT CPCMStreamForAVIStream::RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored )
{
    HRESULT hr;

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;
    if( pbWasRestored )
        *pbWasRestored = FALSE;

    DWORD dwStatus;
	if( FAILED( hr = pDSB->GetStatus( &dwStatus ) ) ){
        _RPT1(_CRT_WARN,_T("GetStatus %x\n"), hr );
		return	hr;
	}

    if( dwStatus & DSBSTATUS_BUFFERLOST ){
        while(true){
            hr = pDSB->Restore();
            if( hr != DSERR_BUFFERLOST )
				break;
            Sleep( 10 );
        }

        if( pbWasRestored != NULL )
            *pbWasRestored = TRUE;

		m_dwPlayProgress = 0L;

        return S_OK;
    }else{
        return S_FALSE;
    }
}

//
//	CPCMStreamForAVIStream::SetNotify()
//	Notification Cxg̎
//
HRESULT	CPCMStreamForAVIStream::SetNotify()
{
	HRESULT	hr;
	DSBPOSITIONNOTIFY*  pPosNotify     = NULL; 
	LPDIRECTSOUNDNOTIFY pDSNotify      = NULL;
	DWORD	dwC;
	if( FAILED( hr = m_lpDSBuffer->QueryInterface( IID_IDirectSoundNotify, 
												(VOID**)&pDSNotify ) ) )
	{
		_RPT1(_CRT_WARN,_T("QueryInterface s 0x%x"),hr);
		goto	e_Fail;
	}

	pPosNotify = new DSBPOSITIONNOTIFY[ m_dwNumNotification];
	for( dwC = 0; dwC < m_dwNumNotification; dwC++ )
	{
		pPosNotify[dwC].dwOffset     = (m_dwNotifySize * dwC) + m_dwNotifySize - 1;
		pPosNotify[dwC].hEventNotify = m_hNotificationEvent[dwC];             
	}

	if( FAILED( hr = pDSNotify->SetNotificationPositions( m_dwNumNotification,
														pPosNotify ) ) )
	{
		_RPT0(_CRT_WARN,  _T("SetNotificationPositions") );
		goto	e_Fail;
	}
	SAFE_RELEASE( pDSNotify );
	SAFE_DELETE_ARRAY( pPosNotify );
	return	S_OK;

e_Fail:
	SAFE_RELEASE( pDSNotify );
	SAFE_DELETE_ARRAY( pPosNotify );
	return	hr;
}

//----------------------------------------------------
//	CPCMStreamForAVIStream::DoThread()
//	Streaming ̃XbhsI
//----------------------------------------------------
void	CPCMStreamForAVIStream::DoThread(){
    DWORD   dwEvent;
	HRESULT	hr;
	int	i;
	m_bThreadActive = TRUE;
	HANDLE	hEvents[AVIPCMSOUNDSTREAM_NUM_BLOCKS + 1];
	for (i = 0; i < AVIPCMSOUNDSTREAM_NUM_BLOCKS ; ++i)
		hEvents[i] = m_hNotificationEvent[i];
	hEvents[i] = m_hTerminator;
	while(!m_bThreadDone){
        dwEvent = WaitForMultipleObjects( AVIPCMSOUNDSTREAM_NUM_BLOCKS + 1, hEvents, FALSE, INFINITE);
		if (dwEvent >= WAIT_OBJECT_0 && dwEvent < WAIT_OBJECT_0 + AVIPCMSOUNDSTREAM_NUM_BLOCKS){
			//_RPT1(_CRT_WARN, _T("Notify:%d\n"),dwEvent - WAIT_OBJECT_0);
			EnterCriticalSection(&m_CriticalSection);
			hr = HandleNotificationEvent();
			LeaveCriticalSection(&m_CriticalSection);
			if (FAILED(hr)){
				m_lpDSBuffer->Stop();
				m_dwPhase = STREAMSOUND_STOP;
			}
		}
		if (dwEvent == WAIT_OBJECT_0 + AVIPCMSOUNDSTREAM_NUM_BLOCKS){
		}
	}
	m_bThreadActive = FALSE;
}

//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::HandleNotificationEvent()
// Desc: Notification ̃Cxgnh
//-----------------------------------------------------------------------------
HRESULT CPCMStreamForAVIStream::HandleNotificationEvent(  )
{
    HRESULT hr;
    DWORD   dwCurrentPlayPos;
    DWORD   dwPlayDelta;
    VOID*   pDSLockedBuffer = NULL;
    VOID*   pDSLockedBuffer2 = NULL;
    DWORD   dwDSLockedBufferSize;
    DWORD   dwDSLockedBufferSize2;

    if( m_lpDSBuffer == NULL || m_lpwfAvi == NULL )
        return CO_E_NOTINITIALIZED;

    // obt@̃XgA
    BOOL bRestored;
	if( FAILED( hr = RestoreBuffer( m_lpDSBuffer, &bRestored ) ) ){
		_RPT0(_CRT_WARN,_T("RestoreBuffer"));
		return	hr;
	}

    if( bRestored )
    {
		if( FAILED( hr = FillBufferWithSound( m_lpDSBuffer ) ) ){
			_RPT0(_CRT_WARN,_T("FillBufferWithSound"));
			return	hr;
		}
        return S_OK;
    }

    // DirectSoundBuffer bN
    if( FAILED( hr = m_lpDSBuffer->Lock( m_dwNextWriteOffset, m_dwNotifySize, 
                                         &pDSLockedBuffer, &dwDSLockedBufferSize, 
										 &pDSLockedBuffer2, &dwDSLockedBufferSize2, 0L ) ) ){
		_RPT0(_CRT_WARN,_T("Lock"));
		return	hr;
	}

	//	m_dwDSBufferSize  m_dwNextWriteOffset ͂ƂɁA
	//	m_dwNotifySize ̔{ł邽߁A pDSLockedBuffer2 ͗LɂȂ鎖͖B
	if( pDSLockedBuffer2 != NULL ){
        return E_UNEXPECTED; 
	}

	if( FAILED( hr = AviStreamReadAndDecode((void*)pDSLockedBuffer,dwDSLockedBufferSize))){
		m_lpDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
		_RPT0(_CRT_WARN,_T("Read"));
		return	hr;		
	}

    m_lpDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );

	if( FAILED( hr = m_lpDSBuffer->GetCurrentPosition( &dwCurrentPlayPos, NULL ) ) ){
		_RPT0(_CRT_WARN,_T("GetCurrentPosition"));
		return	hr;		
	}
	//	O̍Đn_̐isʂ`FbNB
    if( dwCurrentPlayPos < m_dwLastPlayPos )
        dwPlayDelta = ( m_dwDSBufferSize - m_dwLastPlayPos ) + dwCurrentPlayPos;
    else
        dwPlayDelta = dwCurrentPlayPos - m_dwLastPlayPos;

    m_dwPlayProgress += dwPlayDelta;
	//_RPT2(_CRT_WARN,_T("Progress:%x total %x\n"),dwPlayDelta,m_dwPlayProgress);
    m_dwLastPlayPos = dwCurrentPlayPos;

	//	Đn_`FbNA_Ńobt@XgbvB

    if( m_dwPlayProgress >= m_dwSizeConverted/* + m_dwNotifySize*/)
    {
		m_dwPhase = STREAMSOUND_STOP;
        m_lpDSBuffer->Stop();
    }

    //	񃍃bNAhX̍XV
    m_dwNextWriteOffset += dwDSLockedBufferSize; 
    m_dwNextWriteOffset %= m_dwDSBufferSize; // Circular buffer

    return S_OK;
}

//----------------------------------------------------
//	CPCMStreamForAVIStream::Play()
//	Streaming ̍ĐJnI
//----------------------------------------------------
HRESULT CPCMStreamForAVIStream::Play( DWORD dwPriority, DWORD dwFlags, LONG lVol, LONG lFreq, LONG lPan , LONG lFade){
    HRESULT hr;
    BOOL    bRestored;
	DWORD	dwCurrent;
    LPDIRECTSOUNDBUFFER pDSB = this->m_lpDSBuffer;
	FLOAT	fFadeTime;
	FLOAT	fVol1, fVol2;

	if( pDSB == NULL ){
        _RPT0(_CRT_WARN,_T("No Sound Buffer"));
		return	E_FAIL;
	}
	pDSB->Stop();
	EnterCriticalSection(&m_CriticalSection);
	switch(m_dwPhase){
		case	STREAMSOUND_STANDBY:
		case	STREAMSOUND_STOP:
		case	STREAMSOUND_RUN:
		case	STREAMSOUND_FADEIN:
		case	STREAMSOUND_FADEOUT:
			m_lVol = lVol;
			m_lPan = lPan;
			m_lFreq = lFreq;
			m_dwPhaseAfterReplay = STREAMSOUND_RUN;
			m_fFadeTime = 0.0f;
			m_fFadeLen = (FLOAT)lFade;
			if (lFade != 0){
				m_dwPhaseAfterReplay = STREAMSOUND_FADEIN;
			}
			m_dwPlayProgress = 0;
			if (m_dwPhase != STREAMSOUND_STANDBY){
				Reset();
				FillBufferWithSound(pDSB);
			}
			break;
		case	STREAMSOUND_PAUSE:
			dwCurrent = ConvertPcmSampleToAviSample(m_dwPlayProgress);
			if (dwCurrent >= (DWORD)m_lAviEnd){
				goto	exitPlay;
			}
			//	Avi TvEɃACg
			m_dwPlayProgress = ConvertAviSampleToPcmSample(dwCurrent);
			Reset();
			FillBufferWithSound(pDSB);
			break;
		default:
			_RPT0(_CRT_WARN, _T("TEhobt@Đ\ɂȂĂ܂B") );
			hr = E_FAIL;

			goto	exitPlay;
			break;
	}
	pDSB->SetCurrentPosition(0);	

    // Restore the buffer if it was lost
	if( FAILED( hr = RestoreBuffer( pDSB, &bRestored ) ) ){
		_RPT0(_CRT_WARN,_T("RestoreBuffer"));
		goto	exitPlay;
	}

    if( bRestored )
    {
        // The buffer was restored, so we need to fill it with new data
		if( FAILED( hr = FillBufferWithSound( pDSB ) ) ){
			_RPT0(_CRT_WARN,_T("FillBufferWithSound"));
			goto	exitPlay;
		}
    }

	fFadeTime = m_fFadeTime;
	if (fFadeTime > m_fFadeLen)
		fFadeTime = m_fFadeLen;
	switch(m_dwPhaseAfterReplay){
		case	STREAMSOUND_FADEIN:
			fVol1 = DSBVOLUME_MIN * (m_fFadeLen - fFadeTime) / m_fFadeLen;
			fVol2 = (fFadeTime / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			pDSB->SetVolume( lVol );
			break;
		case	STREAMSOUND_FADEOUT:
			fVol1 = DSBVOLUME_MIN * fFadeTime / m_fFadeLen;
			fVol2 = ((m_fFadeLen - fFadeTime) / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			pDSB->SetVolume( lVol );
			break;
		default:
			pDSB->SetVolume( m_lVol );
			break;
	}
    pDSB->SetPan( m_lPan );
    if( m_lFreq != -1 ){
        pDSB->SetFrequency( m_lFreq );
    }
    
	if (SUCCEEDED(hr = pDSB->Play( 0, dwPriority, dwFlags | DSBPLAY_LOOPING ))){
		m_dwPhase = m_dwPhaseAfterReplay;
	}
exitPlay:
	LeaveCriticalSection(&m_CriticalSection);
	return	hr;
}

//----------------------------------------------------
//	CPCMStreamForAVIStream::Stop()
//	Streaming ̍ĐII
//----------------------------------------------------
HRESULT CPCMStreamForAVIStream::Stop(){
	HRESULT	hr = S_OK;
	switch(m_dwPhase){
		case	STREAMSOUND_RUN:
		case	STREAMSOUND_FADEIN:
		case	STREAMSOUND_FADEOUT:
			EnterCriticalSection(&m_CriticalSection);
            hr = m_lpDSBuffer->Stop();
			if (FAILED(hr)){
				_RPT0(_CRT_WARN,_T("Stop"));
			}
			m_dwPhase = STREAMSOUND_STOP;
			hr = Reset();
			LeaveCriticalSection(&m_CriticalSection);
			break;
		case	STREAMSOUND_PAUSE:
			EnterCriticalSection(&m_CriticalSection);
			m_dwPhase = STREAMSOUND_STOP;
			hr = Reset();
			LeaveCriticalSection(&m_CriticalSection);
			break;
	}
	return	hr;
}

HRESULT	CPCMStreamForAVIStream::Rewind(){
	HRESULT	hr;
	if (m_dwPhase == STREAMSOUND_STANDBY)
		return	S_OK;
	hr = Stop();
	if (FAILED(hr))
		return	hr;
	Reset();
	hr = FillBufferWithSound(m_lpDSBuffer);
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::Reset()
// Desc: obt@̍Đ|WV擪ɖ߂
//-----------------------------------------------------------------------------
HRESULT CPCMStreamForAVIStream::Reset()
{
    HRESULT hr;

    if( m_lpDSBuffer == NULL || m_lpAudioStream == NULL )
        return CO_E_NOTINITIALIZED;

	m_dwLastPlayPos     = 0;
    m_dwPlayProgress    = 0;
    m_dwNextWriteOffset = 0;
    //m_bFillNextNotificationWithSilence = FALSE;

    BOOL bRestored;
	if( FAILED( hr = RestoreBuffer( m_lpDSBuffer, &bRestored ) ) ){
        _RPT0( _CRT_WARN, _T("RestoreBuffer"));
		goto	exitReset;
	}

    if( bRestored )
    {
		if( FAILED( hr = FillBufferWithSound( m_lpDSBuffer ) ) ){
	        _RPT0( _CRT_WARN, _T("FillBufferWithSound"));
			goto	exitReset;
		}
    }

    //	m_pWaveFile->ResetFile();
	//	UAVI ̍Đ|WV߂ĂI
	m_dwAviCurrentPos = 0;

    hr = m_lpDSBuffer->SetCurrentPosition( 0L );  

	m_pPcmBufferCurrent = m_pPcmBuffer;
	m_dwPcmBufferSizeRemain = 0;
exitReset:
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CStreamSound::FadeOut()
// Desc: FadeOut Jn
//-----------------------------------------------------------------------------
void	CPCMStreamForAVIStream::FadeOut(LONG lFadeLen){
	EnterCriticalSection(&m_CriticalSection);
	FLOAT	t;
	switch(m_dwPhase){
		case	STREAMSOUND_RUN:
			m_fFadeTime = 0;
			m_fFadeLen = (FLOAT)lFadeLen;
			m_dwPhase = STREAMSOUND_FADEOUT;
			break;
		case	STREAMSOUND_FADEIN:
			t = m_fFadeTime / m_fFadeLen;
			if (t > 1.0f)
				t = 1.0f;
			m_fFadeLen = (FLOAT)lFadeLen;
			m_fFadeTime = m_fFadeLen - (t * m_fFadeLen);
			m_dwPhase = STREAMSOUND_FADEOUT;
			break;
		case	STREAMSOUND_PAUSE:
			switch(m_dwPhaseAfterReplay){
				case	STREAMSOUND_RUN:
					m_fFadeTime = 0;
					m_fFadeLen = (FLOAT)lFadeLen;
					m_dwPhaseAfterReplay = STREAMSOUND_FADEOUT;
					break;
				case	STREAMSOUND_FADEIN:
					t = m_fFadeTime / m_fFadeLen;
					if (t > 1.0f)
						t = 1.0f;
					m_fFadeLen = (FLOAT)lFadeLen;
					m_fFadeTime = m_fFadeLen - (t * m_fFadeLen);
					m_dwPhaseAfterReplay = STREAMSOUND_FADEOUT;
					break;
				case	STREAMSOUND_FADEOUT:
					break;
			}
			break;
	}
	LeaveCriticalSection(&m_CriticalSection);
}

//-----------------------------------------------------------------------------
// Name: CPCMStreamForAVIStream::PollStatus()
// Desc: FADE-OUT, FADE-IN ̏
//-----------------------------------------------------------------------------
void	CPCMStreamForAVIStream::PollStatus(FLOAT timeElapsed){
	FLOAT	fFadeTime;
	FLOAT	fVol1, fVol2;
	LONG	lVol;
	switch(m_dwPhase){
		case	STREAMSOUND_FADEIN:
			EnterCriticalSection(&m_CriticalSection);
			if (m_dwPhase == STREAMSOUND_FADEIN){
				fFadeTime = m_fFadeTime + timeElapsed;
				if (fFadeTime > m_fFadeLen){
					m_dwPhase = STREAMSOUND_RUN;
					fFadeTime = m_fFadeLen;
				}
				m_fFadeTime = fFadeTime;
				fVol1 = DSBVOLUME_MIN * (m_fFadeLen - fFadeTime) / m_fFadeLen;
				fVol2 = (fFadeTime / m_fFadeLen) * m_lVol;
				lVol = (LONG)(fVol1 + fVol2);
				m_lpDSBuffer->SetVolume( lVol );
			}
			LeaveCriticalSection(&m_CriticalSection);
			break;
		case	STREAMSOUND_FADEOUT:
			lVol = m_lVol;
			fFadeTime = m_fFadeTime + timeElapsed;
			if (fFadeTime >= m_fFadeLen){
				Stop();
				fFadeTime = m_fFadeLen;
				break;
			}
			m_fFadeTime = fFadeTime;
			EnterCriticalSection(&m_CriticalSection);
			fVol1 = DSBVOLUME_MIN * fFadeTime / m_fFadeLen;
			fVol2 = ((m_fFadeLen - fFadeTime) / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			m_lpDSBuffer->SetVolume( lVol );
			LeaveCriticalSection(&m_CriticalSection);
			if (lVol == DSBVOLUME_MIN){
				Stop();
			}
			break;
	}
}

HRESULT	CPCMStreamForAVIStream::Pause(){
    if( m_lpDSBuffer == NULL || m_lpAudioStream == NULL )
        return CO_E_NOTINITIALIZED;

	EnterCriticalSection(&m_CriticalSection);
	if (m_dwPhase == STREAMSOUND_RUN || m_dwPhase == STREAMSOUND_FADEIN || m_dwPhase == STREAMSOUND_FADEOUT){
		m_lpDSBuffer->Stop();
		m_dwPhaseAfterReplay = m_dwPhase;
		m_dwPhase = STREAMSOUND_PAUSE;
	}
	LeaveCriticalSection(&m_CriticalSection);

	return	S_OK;
}

DWORD WINAPI AVIStreamPlayback_DoThread(LPVOID pVoid){
	((CPCMStreamForAVIStream*)pVoid)->DoThread();
	return	0L;
}
