// AVIStreamToPCMStream_realtime.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "AVIStreamToPCMStream_realtime.h"
#include <mmsystem.h>
#include <dsound.h>
#include "DSQuickLib.h"
#include <stdio.h>

#include <sys/types.h>
#include <sys/stat.h>	// stat ֐g׃CN[h
#include <crtdbg.h>
#include <TCHAR.h>
#include <vfw.h>
#include <mmreg.h>
#include <msacm.h>

#include "PCMStreamForAVIStream.h"

#pragma comment (lib, "msacm32.lib")
#pragma comment (lib, "winmm.lib")
#pragma comment (lib, "vfw32.lib")


LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
LRESULT CALLBACK IOProc(LPMMIOINFO lpMMIOInfo, UINT uMessage, LPARAM lParam1, LPARAM lParam2);

//	O[oϐ
CDSoundEnv	*g_pDSoundEnv = NULL;
static char * g_lpData = NULL;
static long	g_cfileSize;
CRITICAL_SECTION	g_csSema;
CPCMStreamForAVIStream	*g_pAviPCMStream = NULL;

typedef	struct _aviplaybackinfo{
	HANDLE     hthread;
	HWND       hWnd;
	BOOL       bExit;
	BOOL	bActive;
	PAVIFILE   lpAviFile;
	PAVISTREAM lpVideoStream;
	PAVISTREAM lpAudioStream;
}	AVIPLAYBACKINFO;

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
	_CrtSetDbgFlag ( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = _T("avi realtime audio stream");
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

	InitializeCriticalSection(&g_csSema);
    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,_T("avi realtime audio stream"),
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	AVIPLAYBACKINFO	aviInfo;
	ZeroMemory((VOID*)&aviInfo,sizeof(AVIPLAYBACKINFO));

	::SetWindowLong(hWnd,GWL_USERDATA,(DWORD)&aviInfo);
	aviInfo.hWnd = hWnd;


	g_pDSoundEnv = new CDSoundEnv(2,44100,16);
	if (g_pDSoundEnv){
		if (SUCCEEDED(g_pDSoundEnv->Initialize(hWnd,DSSCL_PRIORITY))){
			struct	_stat	status;
			if (0 == _tstat(_T("test.avi"),&status)){
				g_cfileSize = status.st_size;
				g_lpData = new char[g_cfileSize];
				FILE	*fp = fopen(_T("test.avi"),_T("rb"));
				if (fp != NULL){
					fread(g_lpData,g_cfileSize,1,fp);
					fclose(fp);
				}
				//	mci:JX^IOProc ̃CXg[
				mmioInstallIOProc(mmioFOURCC('M', 'E', 'V', ' '), (LPMMIOPROC)IOProc,
									MMIO_INSTALLPROC | MMIO_GLOBALPROC);

				AVIFileInit();
				
				if (AVIFileOpen(&aviInfo.lpAviFile, TEXT("test.MEV+"), OF_READ, NULL) != 0)
					return -1;
				if (AVIFileGetStream(aviInfo.lpAviFile, &aviInfo.lpVideoStream, streamtypeVIDEO, 0) != 0)
					aviInfo.lpVideoStream = NULL;
				if (AVIFileGetStream(aviInfo.lpAviFile, &aviInfo.lpAudioStream, streamtypeAUDIO, 0) != 0)
					aviInfo.lpAudioStream = NULL;

				AVIFileRelease(aviInfo.lpAviFile);
			}
			if (aviInfo.lpAudioStream != NULL){
				g_pAviPCMStream = new CPCMStreamForAVIStream(g_pDSoundEnv,aviInfo.lpAudioStream);
				g_pAviPCMStream->Prepare();
			}
		}
	}

	MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pDSoundEnv->PollStatus();
			if (!g_pAviPCMStream->IsPlaying()){
				Sleep(100);
				g_pAviPCMStream->Rewind();
				g_pAviPCMStream->Play();
			}
        }
    }

	if (g_pAviPCMStream)
		delete	g_pAviPCMStream;
	if (g_pDSoundEnv)
		delete	g_pDSoundEnv;

	aviInfo.bActive = false;
	if (aviInfo.hthread != NULL) {
		aviInfo.bExit = TRUE;
		WaitForSingleObject(aviInfo.hthread, 1000);
		CloseHandle(aviInfo.hthread);
	}
	
	if (aviInfo.lpVideoStream != NULL)
		AVIStreamRelease(aviInfo.lpVideoStream);
	if (aviInfo.lpAudioStream != NULL)
		AVIStreamRelease(aviInfo.lpAudioStream);
	
	AVIFileExit();

	EnterCriticalSection(&g_csSema);
	if (g_lpData != NULL){
		mmioInstallIOProc(mmioFOURCC('M', 'E', 'V', ' '), NULL,MMIO_REMOVEPROC);
		delete	g_lpData;
		g_lpData = NULL;
	}
	LeaveCriticalSection(&g_csSema);
    return (int)msg.wParam;
}

//
//	֐FWndProc
//	FEChEɓnꂽCxg̃nh
//
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{

    switch (message){
		case WM_PAINT:
			{
				HDC	hDC;
				PAINTSTRUCT	paintStruct;
                hDC = BeginPaint(hWnd,&paintStruct);
				RECT	rc;
				GetClientRect(hWnd,&rc);
				DrawText(hDC,_T("̃AvP[V̓I[fBIĐ̂ݍs܂B"),-1,&rc,DT_NOCLIP);
				rc.top += 30;
				DrawText(hDC,_T("f͍Đ܂B"),-1,&rc,DT_NOCLIP);
                ::EndPaint(hWnd,&paintStruct);
            }
            return DefWindowProc(hWnd, message, wParam, lParam);
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}


//
//	mmio: IOProc
//
LRESULT CALLBACK IOProc(LPMMIOINFO lpMMIOInfo, UINT uMessage, LPARAM
lParam1, LPARAM lParam2)
{
  static BOOL alreadyOpened = FALSE;

  switch (uMessage) {
  case MMIOM_OPEN:
      if (alreadyOpened)
          return 0;
      alreadyOpened = TRUE;

      lpMMIOInfo->lDiskOffset = 0;
      return 0;

   case MMIOM_CLOSE:
       return 0;

   case MMIOM_READ:{
			LPARAM	dataRead = 0;
	   		EnterCriticalSection(&g_csSema);
			if (g_lpData != NULL){
				dataRead = lParam2;
				memcpy((void *)lParam1, g_lpData+lpMMIOInfo->lDiskOffset, lParam2);
				lpMMIOInfo->lDiskOffset += lParam2;
				dataRead = lParam2;
			}
			LeaveCriticalSection(&g_csSema);
			return (dataRead);
		}
   case MMIOM_SEEK:
       switch (lParam2) {
       case SEEK_SET:
           lpMMIOInfo->lDiskOffset = lParam1;
           break;

       case SEEK_CUR:
           lpMMIOInfo->lDiskOffset += lParam1;
           break;

       case SEEK_END:
           lpMMIOInfo->lDiskOffset = g_cfileSize - lParam1;
           break;
       }
       return lpMMIOInfo->lDiskOffset;

   default:
       return -1;
   }
}