#pragma once
#ifndef	__WAVEFILE_H__
#include	"WaveFile.h"
#endif
#ifndef	__SOUNDOBJECT_H__
#include	"SoundObject.h"
#endif

#define	STREAMSOUND_STANDBY		1
#define	STREAMSOUND_FADEIN		2
#define	STREAMSOUND_RUN			3
#define	STREAMSOUND_FADEOUT		4
#define	STREAMSOUND_STOP		5
#define	STREAMSOUND_PAUSE		10

#define	STREAMSOUND_NUM_BLOCKS	16
class CStreamSound : public CSoundObject
{
protected:
	CDSoundEnv			*m_pDSoundEnv;
    DWORD                m_dwDSBufferSize;
    CWaveFile*           m_pWaveFile;
	TCHAR				*m_strFilename;
	DWORD				m_dwModeFlags;

	HANDLE      m_hNotificationEvent[STREAMSOUND_NUM_BLOCKS];
	HANDLE		m_hTerminator;

	DWORD       m_dwThreadID;
	HANDLE      m_hThread;
	
	LPDIRECTSOUNDBUFFER	m_lpDSBuffer;
	LONG		m_lVol;
	LONG		m_lFreq;
	LONG		m_lPan;
	LONG		m_lCurrentPosition;
	
	BOOL		m_bPlayLooped;
	BOOL		m_bThreadDone;
	BOOL		m_bThreadActive;

	DWORD		m_dwNumNotification;
    DWORD		m_dwNotifySize;
	DWORD		m_dwBufferLengthInSec;

	DWORD		m_dwLastPlayPos;
    DWORD		m_dwPlayProgress;
    DWORD		m_dwNextWriteOffset;
    BOOL		m_bFillNextNotificationWithSilence;

	DWORD		m_dwPhase;
	DWORD		m_dwPhaseAfterReplay;
	FLOAT		m_fFadeTime;
	FLOAT		m_fFadeLen;
	CRITICAL_SECTION	m_CriticalSection;

	HRESULT		RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored );
	HRESULT		FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB);
	HRESULT		SetNotify();
	HRESULT		Reset();
	HRESULT		Create();
	HRESULT		HandleNotificationEvent();
public:
	CStreamSound(CDSoundEnv *pEnv, LPTSTR strWaveFileName);
	virtual ~CStreamSound(void);
	HRESULT	Prepare();
	//	ȉ̂S֐́AŔrsB
    virtual HRESULT Play( DWORD dwPriority = 0, DWORD dwFlags = 0, LONG lVol = 0, LONG lFreq = -1, LONG lPan = 0 , LONG lFade = 0);
    virtual HRESULT Stop();
	virtual void	FadeOut(LONG lFadeLen);
	HRESULT	Pause();
	void	SetLoop(BOOL bLoop);
	void	DoThread();
	void	PollStatus(FLOAT timeElapsed);
};
