#include "StdAfx.h"
#include <mmsystem.h>
#include <dsound.h>
#include <crtdbg.h>

#include ".\wavefile.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

static	HRESULT	WAVFILE_ERR(TCHAR *text,HRESULT hr){
	_RPT1(_CRT_WARN,text,hr);
	return	hr;
}

CWaveFile::CWaveFile(void)
{
    m_pWaveformat    = NULL;
    m_hIO   = NULL;
    m_dwSize  = 0;
}

CWaveFile::~CWaveFile(void)
{
    Close();
	SAFE_DELETE_ARRAY(m_pWaveformat);
}

//-----------------------------------------------------------------------------
// Name: CWaveFile::Open()
// Desc: WAVE t@C̓ǂݍ݃I[vB
//-----------------------------------------------------------------------------
HRESULT CWaveFile::Open( LPTSTR strFileName )
{
    HRESULT hr;

    if( strFileName == NULL )
        return E_INVALIDARG;
    SAFE_DELETE_ARRAY( m_pWaveformat );

    m_hIO = mmioOpen( strFileName, NULL, MMIO_ALLOCBUF | MMIO_READ );

    if( FAILED( hr = ReadMMIO() ) )
    {
        // ǂݍݎs
        mmioClose( m_hIO, 0 );
        return WAVFILE_ERR( _T("ReadMMIO"), hr );
    }

    if( FAILED( hr = ResetFile() ) )
        return WAVFILE_ERR( _T("ResetFile"), hr );

    m_dwSize = m_ckData.cksize;

    return hr;
}

//-----------------------------------------------------------------------------
// Name: CWaveFile::ReadMMIO()
// Desc: I/O Xg[f[^ǂݍ
//-----------------------------------------------------------------------------
HRESULT CWaveFile::ReadMMIO()
{
    MMCKINFO        ckInfo;           
    PCMWAVEFORMAT   format;         

	SAFE_DELETE_ARRAY(m_pWaveformat);

    if( ( 0 != mmioDescend( m_hIO, &m_ckFile, NULL, 0 ) ) )
        return WAVFILE_ERR( _T("mmioDescend"), E_FAIL );

    if( (m_ckFile.ckid != FOURCC_RIFF) ||
        (m_ckFile.fccType != mmioFOURCC('W', 'A', 'V', 'E') ) )
        return WAVFILE_ERR( _T("mmioFOURCC"), E_FAIL ); 

    ckInfo.ckid = mmioFOURCC('f', 'm', 't', ' ');
    if( 0 != mmioDescend( m_hIO, &ckInfo, &m_ckFile, MMIO_FINDCHUNK ) )
        return WAVFILE_ERR( _T("mmioDescend"), E_FAIL );

       if( ckInfo.cksize < (LONG) sizeof(PCMWAVEFORMAT) )
           return WAVFILE_ERR( _T("sizeof(PCMWAVEFORMAT)"), E_FAIL );

     if( mmioRead( m_hIO, (HPSTR) &format, 
                  sizeof(format)) != sizeof(format) )
        return WAVFILE_ERR( _T("mmioRead"), E_FAIL );

    if( format.wf.wFormatTag == WAVE_FORMAT_PCM )
    {
        m_pWaveformat = (WAVEFORMATEX*)new CHAR[ sizeof(WAVEFORMATEX) ];
        if( NULL == m_pWaveformat )
            return WAVFILE_ERR( _T("m_pWaveformat"), E_FAIL );

        memcpy( m_pWaveformat, &format, sizeof(format) );
        m_pWaveformat->cbSize = 0;
    }
    else
    {
        WORD cbExtraBytes = 0L;
        if( mmioRead( m_hIO, (CHAR*)&cbExtraBytes, sizeof(WORD)) != sizeof(WORD) )
            return WAVFILE_ERR( _T("mmioRead"), E_FAIL );

        m_pWaveformat = (WAVEFORMATEX*)new CHAR[ sizeof(WAVEFORMATEX) + cbExtraBytes ];
        if( NULL == m_pWaveformat )
            return WAVFILE_ERR( _T("new"), E_FAIL );

        memcpy( m_pWaveformat, &format, sizeof(format) );
        m_pWaveformat->cbSize = cbExtraBytes;

        if( mmioRead( m_hIO, (CHAR*)(((BYTE*)&(m_pWaveformat->cbSize))+sizeof(WORD)),
                      cbExtraBytes ) != cbExtraBytes )
        {
            SAFE_DELETE( m_pWaveformat );
            return WAVFILE_ERR( _T("mmioRead"), E_FAIL );
        }
    }

    if( 0 != mmioAscend( m_hIO, &ckInfo, 0 ) )
    {
        SAFE_DELETE( m_pWaveformat );
        return WAVFILE_ERR( _T("mmioAscend"), E_FAIL );
    }

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CWaveFile::GetSize()
// Desc: WAV t@C̃TCYԂ
//-----------------------------------------------------------------------------
DWORD CWaveFile::GetSize()
{
    return m_dwSize;
}




//-----------------------------------------------------------------------------
// Name: CWaveFile::ResetFile()
// Desc: t@C̓ǏoʒuZbg
//-----------------------------------------------------------------------------
HRESULT CWaveFile::ResetFile()
{

    if( m_hIO == NULL )
        return CO_E_NOTINITIALIZED;

    if( -1 == mmioSeek( m_hIO, m_ckFile.dwDataOffset + sizeof(FOURCC),
                    SEEK_SET ) )
        return WAVFILE_ERR( _T("mmioSeek"), E_FAIL );

    // Search the input file for the 'data' chunk.
    m_ckData.ckid = mmioFOURCC('d', 'a', 't', 'a');
    if( 0 != mmioDescend( m_hIO, &m_ckData, &m_ckFile, MMIO_FINDCHUNK ) )
        return WAVFILE_ERR( _T("mmioDescend"), E_FAIL );
    
    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: CWaveFile::Read()
// Desc: 
//-----------------------------------------------------------------------------
HRESULT CWaveFile::Read( BYTE* pBuffer, DWORD dwSizeToRead, DWORD* pdwSizeRead )
{
    MMIOINFO mmioinfo; // m_hIO ̃Xe[^X

    if( m_hIO == NULL )
        return CO_E_NOTINITIALIZED;
    if( pBuffer == NULL)
        return E_INVALIDARG;

    if( pdwSizeRead != NULL )
        *pdwSizeRead = 0;

    if( 0 != mmioGetInfo( m_hIO, &mmioinfo, 0 ) )
        return WAVFILE_ERR( _T("mmioGetInfo"), E_FAIL );
            
    UINT cbSize = dwSizeToRead;
    if( cbSize > m_ckData.cksize ) 
        cbSize = m_ckData.cksize;       

    m_ckData.cksize -= cbSize;

	DWORD	rdSize,cpSize,bufSize;
	DWORD	dwCT = 0;
	rdSize = cbSize;
	if (rdSize > 0){
		while( true ){
			if (mmioinfo.pchNext != mmioinfo.pchEndRead){
				bufSize = (DWORD)(mmioinfo.pchEndRead - mmioinfo.pchNext);
				cpSize = rdSize;
				if (cpSize > bufSize)
					cpSize = bufSize;
				//CopyMemory((BYTE*)pBuffer + dwCT,mmioinfo.pchNext,cpSize);
				_asm{
					mov	edi, pBuffer;
					add	edi, dwCT;
					mov	esi, mmioinfo.pchNext;
					mov	ebx, cpSize;
					cld;
					mov	eax, edi;
					and	eax, 3;
					jz	no_pre_copy;

					mov	ecx, 4;
					sub	ecx, eax;
					sub	ebx, ecx;
					rep	movsb;
no_pre_copy:
					cmp	ebx, 8;
					jb	do_fraction;
					mov	ecx, ebx;
					and	ebx, 3;
					shr	ecx, 2;
					rep	movsd;
do_fraction:
					and	ebx,ebx;
					jz	no_fraction;
					mov	ecx, ebx;
					rep	movsb;
no_fraction:
				}
				dwCT += cpSize;
				rdSize -= cpSize;
				mmioinfo.pchNext += cpSize;
			}
			if (rdSize == 0)
				break;

			if( 0 != mmioAdvance( m_hIO, &mmioinfo, MMIO_READ ) )
				return WAVFILE_ERR( _T("mmioAdvance"), E_FAIL );

			if( mmioinfo.pchNext == mmioinfo.pchEndRead )
				return WAVFILE_ERR( _T("mmioinfo.pchNext"), E_FAIL );
		}
	}

    if( 0 != mmioSetInfo( m_hIO, &mmioinfo, 0 ) )
        return WAVFILE_ERR( _T("mmioSetInfo"), E_FAIL );

    if( pdwSizeRead != NULL )
        *pdwSizeRead = cbSize;

    return S_OK;
}

HRESULT CWaveFile::SetPosition(DWORD dwOffset){
	HRESULT hr;
	if( m_hIO == NULL )
        return CO_E_NOTINITIALIZED;
	if (FAILED(hr = ResetFile()))
		return	WAVFILE_ERR( _T("ResetFile"), E_FAIL );

	if (0 > mmioSeek( m_hIO,(LONG)dwOffset,SEEK_CUR)){
        return WAVFILE_ERR( _T("mmioSeek"), E_FAIL );
	}
    m_ckData.cksize -= dwOffset;
	return	S_OK;
}

//-----------------------------------------------------------------------------
// Name: CWaveFile::Close()
// Desc: wave t@CN[YB
//-----------------------------------------------------------------------------
HRESULT CWaveFile::Close()
{
    mmioClose( m_hIO, 0 );
    m_hIO = NULL;
    return S_OK;
}

