#include "StdAfx.h"
#include <mmsystem.h>
#include <dsound.h>
#include <crtdbg.h>
#include "DSQuickLib.h"

DWORD WINAPI StreamSound_DoThread(LPVOID pVoid);
#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#define SAFE_CLOSEHANDLE(h) { if(h) { CloseHandle(h);   (h)=NULL; } }


static	HRESULT	STREAMSOUND_ERR(TCHAR *text,HRESULT hr){
	_RPT1(_CRT_WARN,text,hr);
	return	hr;
}

CStreamSound::CStreamSound(CDSoundEnv *pEnv, LPTSTR strFileName)
{
	size_t	dwLen;

	m_pDSoundEnv = pEnv;
	m_pWaveFile = NULL;
	dwLen = _tcslen(strFileName);
	dwLen += _tcslen(pEnv->GetAppPathName());
	m_strFilename = new TCHAR[dwLen + 3];
	_tcscpy(m_strFilename,pEnv->GetAppPathName());
	_tcscat(m_strFilename,"\\");
	_tcscat(m_strFilename,strFileName);
	m_dwModeFlags = 0;
	m_dwDSBufferSize = 0L;
	m_hThread = NULL;
	m_dwThreadID = 0;
	for (int i = 0; i < STREAMSOUND_NUM_BLOCKS ; ++i)
		m_hNotificationEvent[i] = NULL;
	m_hTerminator = NULL;
	m_lpDSBuffer = NULL;
	m_bPlayLooped = FALSE;

	m_dwNumNotification = STREAMSOUND_NUM_BLOCKS;	//	obt@̕E쐬r
	m_dwBufferLengthInSec = 3;		//	ftHg̃obt@

	InitializeCriticalSection(&m_CriticalSection);

	m_dwPhase = 0;
	m_bThreadActive = FALSE;
	m_bThreadDone = FALSE;

	m_fVolMoveTime = 0;
	m_fVolMoveLen = 0;

	pEnv->AddSoundObject(this);
}

CStreamSound::~CStreamSound(void)
{
	m_bThreadDone = TRUE;
	if (m_hTerminator != NULL){
		SetEvent(m_hTerminator);
		while(m_bThreadActive){
			Sleep(10);
		}
	}
	for (int i = 0; i < STREAMSOUND_NUM_BLOCKS ; ++i)
		SAFE_CLOSEHANDLE(m_hNotificationEvent[i]);

	DeleteCriticalSection(&m_CriticalSection);
	SAFE_CLOSEHANDLE(m_hTerminator);
	SAFE_RELEASE(m_lpDSBuffer);
	SAFE_DELETE(m_pWaveFile);
	SAFE_DELETE_ARRAY(m_strFilename);
	m_pDSoundEnv->RemoveSoundObject(this);
}

//--------------------------------------------------------------
//	Name: Prepare
//	Desc: Xg[AĐł悤ɂB
//--------------------------------------------------------------
HRESULT	CStreamSound::Prepare(){
	HRESULT	hr;
	int	i;
	DWORD	nAlign;

	m_pWaveFile = new CWaveFile();
    if( FAILED( hr = m_pWaveFile->Open(m_strFilename)))
    {
		STREAMSOUND_ERR( _T("Open"), hr );
        m_pWaveFile->Close();
		goto	e_Fail;
    }

    if( m_pWaveFile->GetSize() == 0 )
    {
        m_pWaveFile->Close();
		_RPT0(_CRT_WARN,"WAVE t@CɃf[^܂B");
        goto e_Fail;
    }
	
	nAlign = (DWORD)m_pWaveFile->m_pWaveformat->nBlockAlign;
	m_dwNotifySize = nAlign * (DWORD)m_pWaveFile->m_pWaveformat->nSamplesPerSec;
	m_dwNotifySize *= m_dwBufferLengthInSec;
	m_dwNotifySize /= m_dwNumNotification;
	m_dwNotifySize -= m_dwNotifySize % nAlign;
	for (i = 0; i < STREAMSOUND_NUM_BLOCKS; ++i)
		m_hNotificationEvent[i] =  CreateEvent( NULL, FALSE, FALSE, NULL );

	if (FAILED(Create())){
		m_pWaveFile->Close();
		goto	e_Fail;
	}

	m_hTerminator =  CreateEvent( NULL, FALSE, FALSE, NULL );
	m_hThread = CreateThread(NULL,0,::StreamSound_DoThread,(LPVOID)this,0,&m_dwThreadID);

	m_dwPhase = STREAMSOUND_STANDBY;
	return	S_OK;

e_Fail:
	for (i = 0; i < STREAMSOUND_NUM_BLOCKS ; ++i)
		SAFE_CLOSEHANDLE(m_hNotificationEvent[i]);
	SAFE_DELETE(m_pWaveFile);
	return	hr;
}

HRESULT	CStreamSound::Create()
{
	LPDIRECTSOUND8	pDS;
    DSBUFFERDESC dsbd;
	HRESULT	hr;


    if( m_pDSoundEnv == NULL )
        return CO_E_NOTINITIALIZED;

	m_dwDSBufferSize = m_dwNumNotification * m_dwNotifySize;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
    dsbd.dwSize          = sizeof(DSBUFFERDESC);
    dsbd.dwFlags         = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_CTRLPAN |
						   DSBCAPS_CTRLPOSITIONNOTIFY | 
                           DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_LOCSOFTWARE ;
    dsbd.dwBufferBytes   = m_dwDSBufferSize;
    dsbd.guid3DAlgorithm = GUID_NULL;
    dsbd.lpwfxFormat     = m_pWaveFile->m_pWaveformat;
	pDS = this->m_pDSoundEnv->GetDirectSound();
	hr = pDS->CreateSoundBuffer( &dsbd, &m_lpDSBuffer, NULL );
	SAFE_RELEASE(pDS);
	if (FAILED(hr)){
		STREAMSOUND_ERR(_T("CreateSoundBuffer s 0x%x"),hr);
		goto	e_Fail;
	}
	SetNotify();

	if (FAILED(hr = this->m_pWaveFile->ResetFile())){
        _RPT0(_CRT_WARN,  _T("ResetFile") );
		goto	e_Fail;
	}
    m_dwLastPlayPos     = 0;
    m_dwPlayProgress    = 0;
    m_dwNextWriteOffset = 0;
    m_bFillNextNotificationWithSilence = FALSE;
	FillBufferWithSound(m_lpDSBuffer);

	return	S_OK;
e_Fail:
	return	hr;
}

HRESULT	CStreamSound::SetNotify()
{
	HRESULT	hr;
	DSBPOSITIONNOTIFY*  pPosNotify     = NULL; 
	LPDIRECTSOUNDNOTIFY pDSNotify      = NULL;
	DWORD	dwC;
	if( FAILED( hr = m_lpDSBuffer->QueryInterface( IID_IDirectSoundNotify, 
												(VOID**)&pDSNotify ) ) )
	{
		STREAMSOUND_ERR(_T("QueryInterface s 0x%x"),hr);
		goto	e_Fail;
	}

	pPosNotify = new DSBPOSITIONNOTIFY[ m_dwNumNotification];
	for( dwC = 0; dwC < m_dwNumNotification; dwC++ )
	{
		pPosNotify[dwC].dwOffset     = (m_dwNotifySize * dwC) + m_dwNotifySize - 1;
		pPosNotify[dwC].hEventNotify = m_hNotificationEvent[dwC];             
	}

	if( FAILED( hr = pDSNotify->SetNotificationPositions( m_dwNumNotification,
														pPosNotify ) ) )
	{
		_RPT0(_CRT_WARN,  _T("SetNotificationPositions") );
		goto	e_Fail;
	}
	SAFE_RELEASE( pDSNotify );
	SAFE_DELETE_ARRAY( pPosNotify );
	return	S_OK;

e_Fail:
	SAFE_RELEASE( pDSNotify );
	SAFE_DELETE_ARRAY( pPosNotify );
	return	hr;
}
void	CStreamSound::DoThread(){
    DWORD   dwEvent;
	HRESULT	hr;
	int	i;
	m_bThreadActive = TRUE;
	HANDLE	hEvents[STREAMSOUND_NUM_BLOCKS + 1];
	for (i = 0; i < STREAMSOUND_NUM_BLOCKS ; ++i)
		hEvents[i] = m_hNotificationEvent[i];
	hEvents[i] = m_hTerminator;
	while(!m_bThreadDone){
        dwEvent = WaitForMultipleObjects( STREAMSOUND_NUM_BLOCKS + 1, hEvents, FALSE, INFINITE);
		if (dwEvent >= WAIT_OBJECT_0 && dwEvent < WAIT_OBJECT_0 + STREAMSOUND_NUM_BLOCKS){
			_RPT1(_CRT_WARN, _T("Notify:%d\n"),dwEvent - WAIT_OBJECT_0);
			EnterCriticalSection(&m_CriticalSection);
			hr = HandleNotificationEvent();
			LeaveCriticalSection(&m_CriticalSection);
			if (FAILED(hr)){
				m_lpDSBuffer->Stop();
				m_dwPhase = STREAMSOUND_STOP;
			}
		}
		if (dwEvent == WAIT_OBJECT_0 + STREAMSOUND_NUM_BLOCKS){
		}
	}
	m_bThreadActive = FALSE;
}


//-----------------------------------------------------------------------------
// Name: CStreamSound::HandleNotificationEvent()
// Desc: Notification ̃Cxgnh
//-----------------------------------------------------------------------------
HRESULT CStreamSound::HandleNotificationEvent(  )
{
    HRESULT hr;
    DWORD   dwCurrentPlayPos;
    DWORD   dwPlayDelta;
    DWORD   dwWavDataRead;
    VOID*   pDSLockedBuffer = NULL;
    VOID*   pDSLockedBuffer2 = NULL;
    DWORD   dwDSLockedBufferSize;
    DWORD   dwDSLockedBufferSize2;

    if( m_lpDSBuffer == NULL || m_pWaveFile == NULL )
        return CO_E_NOTINITIALIZED;

    // obt@̃XgA
    BOOL bRestored;
    if( FAILED( hr = RestoreBuffer( m_lpDSBuffer, &bRestored ) ) )
        return STREAMSOUND_ERR( _T("RestoreBuffer"), hr );

    if( bRestored )
    {
        if( FAILED( hr = FillBufferWithSound( m_lpDSBuffer ) ) )
            return STREAMSOUND_ERR( _T("FillBufferWithSound"), hr );
        return S_OK;
    }

    // DirectSoundBuffer bN
    if( FAILED( hr = m_lpDSBuffer->Lock( m_dwNextWriteOffset, m_dwNotifySize, 
                                         &pDSLockedBuffer, &dwDSLockedBufferSize, 
                                         &pDSLockedBuffer2, &dwDSLockedBufferSize2, 0L ) ) )
        return STREAMSOUND_ERR( _T("Lock"), hr );

	//	m_dwDSBufferSize  m_dwNextWriteOffset ͂ƂɁA
	//	m_dwNotifySize ̔{ł邽߁A pDSLockedBuffer2 ͗LɂȂ鎖͖B
    if( pDSLockedBuffer2 != NULL )
        return E_UNEXPECTED; 

    if( !m_bFillNextNotificationWithSilence )
    {
		//	WAV f[^obt@֓]
        if( FAILED( hr = m_pWaveFile->Read( (BYTE*) pDSLockedBuffer, 
                                                  dwDSLockedBufferSize, 
												  &dwWavDataRead ) ) ){         
			m_lpDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
			return STREAMSOUND_ERR( _T("Read"), hr );
		}
    }
    else
    {
        // obt@𖳉Ŗ߂
        FillMemory( pDSLockedBuffer, dwDSLockedBufferSize, 
                    (BYTE)( m_pWaveFile->m_pWaveformat->wBitsPerSample == 8 ? 128 : 0 ) );
        dwWavDataRead = dwDSLockedBufferSize;
    }

    // t@Cǂݍ񂾃f[^̃TCYAobt@TCY菬ꍇA
    if( dwWavDataRead < dwDSLockedBufferSize )
    {
        if( !m_bPlayLooped ) 
        {
            // [vȂ̏ꍇ͎c̃obt@𖳉Ŗ߂
            FillMemory( (BYTE*) pDSLockedBuffer + dwWavDataRead, 
                        dwDSLockedBufferSize - dwWavDataRead, 
                        (BYTE)(m_pWaveFile->m_pWaveformat->wBitsPerSample == 8 ? 128 : 0 ) );

            m_bFillNextNotificationWithSilence = TRUE;
        }else{
			//	[vł΁At@C̐擪ւƖ߂AKvȕ
            DWORD dwAlreadyRead = dwWavDataRead;
            while( dwAlreadyRead < dwDSLockedBufferSize )
            {  
                if( FAILED( hr = m_pWaveFile->ResetFile() ) )
                    return STREAMSOUND_ERR( _T("ResetFile"), hr );

                if( FAILED( hr = m_pWaveFile->Read( (BYTE*)pDSLockedBuffer + dwAlreadyRead,
                                                          dwDSLockedBufferSize - dwAlreadyRead,
														  &dwWavDataRead ) ) ){
				    m_lpDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
                    return STREAMSOUND_ERR( _T("Read"), hr );
				}

                dwAlreadyRead += dwWavDataRead;
            } 
        } 
    }

    m_lpDSBuffer->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );

    if( FAILED( hr = m_lpDSBuffer->GetCurrentPosition( &dwCurrentPlayPos, NULL ) ) )
        return STREAMSOUND_ERR( _T("GetCurrentPosition"), hr );

	//	O̍Đn_̐isʂ`FbNB
    if( dwCurrentPlayPos < m_dwLastPlayPos )
        dwPlayDelta = ( m_dwDSBufferSize - m_dwLastPlayPos ) + dwCurrentPlayPos;
    else
        dwPlayDelta = dwCurrentPlayPos - m_dwLastPlayPos;

    m_dwPlayProgress += dwPlayDelta;
	_RPT2(_CRT_WARN,_T("Progress:%x total %x\n"),dwPlayDelta,m_dwPlayProgress);
    m_dwLastPlayPos = dwCurrentPlayPos;

	//	ǂݍ݂IĂꍇA
	//	Đn_`FbNA_Ńobt@XgbvB
	if( m_bFillNextNotificationWithSilence )
    {
        if( m_dwPlayProgress >= m_pWaveFile->GetSize() )
        {
			m_dwPhase = STREAMSOUND_STOP;
            m_lpDSBuffer->Stop();
        }
    }

    //	񃍃bNAhX̍XV
    m_dwNextWriteOffset += dwDSLockedBufferSize; 
    m_dwNextWriteOffset %= m_dwDSBufferSize; // Circular buffer

    return S_OK;
}


//-----------------------------------------------------------------------------
// Name: CPCMSound::FillBufferWithSound()
// Desc: TEht@Cobt@ɓ]B 
//-----------------------------------------------------------------------------
HRESULT CStreamSound::FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB )
{
    HRESULT hr; 
    VOID*   pDSLockedBuffer      = NULL; // bNꂽobt@ւ̃|C^
    DWORD   dwDSLockedBufferSize = 0;    // bNꂽobt@̃TCY
    DWORD   dwWavDataRead        = 0;    // ǂݍ܂ꂽWAV t@C̃TCY 

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;

    if( FAILED( hr = RestoreBuffer( pDSB, NULL ) ) ) {
        _RPT0(_CRT_WARN,  _T("RestoreBuffer"));
		return	hr;
	}

    m_pWaveFile->ResetFile();
	if (m_dwPlayProgress != 0){
		m_pWaveFile->SetPosition(m_dwPlayProgress);
	}
    if( FAILED( hr = pDSB->Lock( 0, m_dwDSBufferSize, 
                                 &pDSLockedBuffer, &dwDSLockedBufferSize, 
                                 NULL, NULL, 0L ) ) )
        return STREAMSOUND_ERR( _T("Lock"), hr );

    if( FAILED( hr = m_pWaveFile->Read( (BYTE*) pDSLockedBuffer,
                                        dwDSLockedBufferSize, 
										&dwWavDataRead ) ) ){
	    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
        return STREAMSOUND_ERR( _T("Read"), hr );
	}

    if( dwWavDataRead < dwDSLockedBufferSize )
    {
		if (!m_bPlayLooped){
	        FillMemory( (BYTE*) pDSLockedBuffer + dwWavDataRead, 
                    dwDSLockedBufferSize - dwWavDataRead, 
                    (BYTE)(m_pWaveFile->m_pWaveformat->wBitsPerSample == 8 ? 128 : 0 ) );

		}else{

			//	[vł΁At@C̐擪ւƖ߂AKvȕ
            DWORD dwAlreadyRead = dwWavDataRead;
            while( dwAlreadyRead < dwDSLockedBufferSize )
            {
				if( FAILED( hr = m_pWaveFile->ResetFile() ) ){
				    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
                    return STREAMSOUND_ERR( _T("ResetFile"), hr );
				}
                if( FAILED( hr = m_pWaveFile->Read( (BYTE*)pDSLockedBuffer + dwAlreadyRead,
                                                          dwDSLockedBufferSize - dwAlreadyRead,
														  &dwWavDataRead ) ) ){
				    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
                    return STREAMSOUND_ERR( _T("Read"), hr );
				}

                dwAlreadyRead += dwWavDataRead;
            } 
 
		}
	}

    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: CPCMSound::RestoreBuffer()
// Desc: ꂽobt@XgA
//-----------------------------------------------------------------------------
HRESULT CStreamSound::RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored )
{
    HRESULT hr;

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;
    if( pbWasRestored )
        *pbWasRestored = FALSE;

    DWORD dwStatus;
    if( FAILED( hr = pDSB->GetStatus( &dwStatus ) ) )
        return STREAMSOUND_ERR( _T("GetStatus"), hr );

    if( dwStatus & DSBSTATUS_BUFFERLOST ){
        while(true){
            hr = pDSB->Restore();
            if( hr != DSERR_BUFFERLOST )
				break;
            Sleep( 10 );
        }

        if( pbWasRestored != NULL )
            *pbWasRestored = TRUE;

		m_dwPlayProgress = 0L;

        return S_OK;
    }else{
        return S_FALSE;
    }
}


//-----------------------------------------------------------------------------
// Name: CSound::Play()
//	Desc : ĐJnB
//-----------------------------------------------------------------------------
HRESULT CStreamSound::Play( DWORD dwPriority, DWORD dwFlags, LONG lVol, LONG lFreq, LONG lPan, LONG lFade )
{
    HRESULT hr;
    BOOL    bRestored;
	DWORD	dwCurrent;
    LPDIRECTSOUNDBUFFER pDSB = this->m_lpDSBuffer;
	FLOAT	fFadeTime;
	FLOAT	fVol1, fVol2;

    if( pDSB == NULL )
        return STREAMSOUND_ERR( _T("No Sound Buffer"), E_FAIL );

	pDSB->Stop();
	EnterCriticalSection(&m_CriticalSection);
	switch(m_dwPhase){
		case	STREAMSOUND_STANDBY:
		case	STREAMSOUND_STOP:
		case	STREAMSOUND_RUN:
		case	STREAMSOUND_FADEIN:
		case	STREAMSOUND_FADEOUT:

			m_fVolMoveTime = 0;
			m_fVolMoveLen = 0;
			m_lVol = lVol;
			m_lOriginalVol = lVol;
			m_lTargetVol = lVol;

			m_lPan = lPan;
			m_lFreq = lFreq;
			m_dwPhaseAfterReplay = STREAMSOUND_RUN;
			m_fFadeTime = 0.0f;
			m_fFadeLen = (FLOAT)lFade;
			if (lFade != 0){
				m_dwPhaseAfterReplay = STREAMSOUND_FADEIN;
			}
			Reset();
			FillBufferWithSound(pDSB);
			break;
		case	STREAMSOUND_PAUSE:
			dwCurrent = m_dwPlayProgress;
			if (dwCurrent >= m_pWaveFile->GetSize()){
				if (!m_bPlayLooped)
					goto	exitPlay;
				dwCurrent %= m_pWaveFile->GetSize();
			}
			Reset();
			m_dwPlayProgress = dwCurrent;
			FillBufferWithSound(pDSB);
			break;
		default:
			hr = STREAMSOUND_ERR( _T("TEhobt@Đ\ɂȂĂ܂B"), E_FAIL );
			goto	exitPlay;
			break;
	}
	pDSB->SetCurrentPosition(0);	

    // Restore the buffer if it was lost
	if( FAILED( hr = RestoreBuffer( pDSB, &bRestored ) ) ){
        STREAMSOUND_ERR( _T("RestoreBuffer"), hr );
		goto	exitPlay;
	}

    if( bRestored )
    {
        // The buffer was restored, so we need to fill it with new data
		if( FAILED( hr = FillBufferWithSound( pDSB ) ) ){
            STREAMSOUND_ERR( _T("FillBufferWithSound"), hr );
			goto	exitPlay;
		}
    }

	fFadeTime = m_fFadeTime;
	if (fFadeTime > m_fFadeLen)
		fFadeTime = m_fFadeLen;
	switch(m_dwPhaseAfterReplay){
		case	STREAMSOUND_FADEIN:
			fVol1 = DSBVOLUME_MIN * (m_fFadeLen - fFadeTime) / m_fFadeLen;
			fVol2 = (fFadeTime / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			pDSB->SetVolume( lVol );
			break;
		case	STREAMSOUND_FADEOUT:
			fVol1 = DSBVOLUME_MIN * fFadeTime / m_fFadeLen;
			fVol2 = ((m_fFadeLen - fFadeTime) / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			pDSB->SetVolume( lVol );
			break;
		default:
			pDSB->SetVolume( m_lVol );
			break;
	}
    pDSB->SetPan( m_lPan );
    if( m_lFreq != -1 ){
        pDSB->SetFrequency( m_lFreq );
    }
    
	if (SUCCEEDED(hr = pDSB->Play( 0, dwPriority, dwFlags | DSBPLAY_LOOPING ))){
		m_dwPhase = m_dwPhaseAfterReplay;
	}
exitPlay:
	LeaveCriticalSection(&m_CriticalSection);
	return	hr;
}
//-----------------------------------------------------------------------------
// Name: CStreamSound::PollStatus()
// Desc: FADE-OUT, FADE-IN ̏
//-----------------------------------------------------------------------------
void	CStreamSound::PollStatus(FLOAT timeElapsed){
	FLOAT	fFadeTime;
	FLOAT	fVol1, fVol2;
	LONG	lVol;
	BOOL	bFlag = false;
	if (m_fVolMoveLen > 0){
		m_fVolMoveTime += timeElapsed;
		if (m_fVolMoveTime >= m_fVolMoveLen){
			m_fVolMoveLen = 0;
			m_fVolMoveTime = 0;
			m_lVol = m_lTargetVol;
		}else{
			fVol1 = (FLOAT)m_lTargetVol * m_fVolMoveTime;
			fVol2 = (FLOAT)m_lOriginalVol * (m_fVolMoveLen - m_fVolMoveTime);
			m_lVol = (LONG)((fVol1+fVol2) / m_fVolMoveLen);
		}
		bFlag = true;
	}
	switch(m_dwPhase){
		case	STREAMSOUND_FADEIN:
			EnterCriticalSection(&m_CriticalSection);
			if (m_dwPhase == STREAMSOUND_FADEIN){
				fFadeTime = m_fFadeTime + timeElapsed;
				if (fFadeTime > m_fFadeLen){
					m_dwPhase = STREAMSOUND_RUN;
					fFadeTime = m_fFadeLen;
				}
				m_fFadeTime = fFadeTime;
				fVol1 = DSBVOLUME_MIN * (m_fFadeLen - fFadeTime) / m_fFadeLen;
				fVol2 = (fFadeTime / m_fFadeLen) * m_lVol;
				lVol = (LONG)(fVol1 + fVol2);
				m_lpDSBuffer->SetVolume( lVol );
			}
			LeaveCriticalSection(&m_CriticalSection);
			break;
		case	STREAMSOUND_FADEOUT:
			lVol = m_lVol;
			fFadeTime = m_fFadeTime + timeElapsed;
			if (fFadeTime >= m_fFadeLen){
				Stop();
				fFadeTime = m_fFadeLen;
				break;
			}
			m_fFadeTime = fFadeTime;
			EnterCriticalSection(&m_CriticalSection);
			fVol1 = DSBVOLUME_MIN * fFadeTime / m_fFadeLen;
			fVol2 = ((m_fFadeLen - fFadeTime) / m_fFadeLen) * m_lVol;
			lVol = (LONG)(fVol1 + fVol2);
			m_lpDSBuffer->SetVolume( lVol );
			LeaveCriticalSection(&m_CriticalSection);
			if (lVol == DSBVOLUME_MIN){
				this->Stop();
			}
			break;
		default:
			if (bFlag){
				EnterCriticalSection(&m_CriticalSection);
				m_lpDSBuffer->SetVolume( m_lVol );
				LeaveCriticalSection(&m_CriticalSection);
			}
			break;
	}
}

//-----------------------------------------------------------------------------
// Name: CStreamSound::SetVol()
// Desc: ĐrŉʂςvO
//-----------------------------------------------------------------------------
void	CStreamSound::SetVol(LONG	lVol, FLOAT fDuration){

	if (fDuration == 0){
		EnterCriticalSection(&m_CriticalSection);
		this->m_lVol = lVol;
		switch(m_dwPhase){
			case	STREAMSOUND_FADEIN:
			case	STREAMSOUND_FADEOUT:
			case	STREAMSOUND_STOP:
				break;
			default:
				m_lpDSBuffer->SetVolume( lVol );
		}
		LeaveCriticalSection(&m_CriticalSection);
	}else{
		m_fVolMoveLen  = fDuration;
		m_fVolMoveTime = 0.0f;
		m_lOriginalVol = m_lVol;
		m_lTargetVol   = lVol;
	}
}


//-----------------------------------------------------------------------------
// Name: CStreamSound::FadeOut()
// Desc: FadeOut Jn
//-----------------------------------------------------------------------------
void	CStreamSound::FadeOut(LONG lFadeLen){
	EnterCriticalSection(&m_CriticalSection);
	FLOAT	t;
	switch(m_dwPhase){
		case	STREAMSOUND_RUN:
			m_fFadeTime = 0;
			m_fFadeLen = (FLOAT)lFadeLen;
			m_dwPhase = STREAMSOUND_FADEOUT;
			break;
		case	STREAMSOUND_FADEIN:
			t = m_fFadeTime / m_fFadeLen;
			if (t > 1.0f)
				t = 1.0f;
			m_fFadeLen = (FLOAT)lFadeLen;
			m_fFadeTime = m_fFadeLen - (t * m_fFadeLen);
			m_dwPhase = STREAMSOUND_FADEOUT;
			break;
		case	STREAMSOUND_PAUSE:
			switch(m_dwPhaseAfterReplay){
				case	STREAMSOUND_RUN:
					m_fFadeTime = 0;
					m_fFadeLen = (FLOAT)lFadeLen;
					m_dwPhaseAfterReplay = STREAMSOUND_FADEOUT;
					break;
				case	STREAMSOUND_FADEIN:
					t = m_fFadeTime / m_fFadeLen;
					if (t > 1.0f)
						t = 1.0f;
					m_fFadeLen = (FLOAT)lFadeLen;
					m_fFadeTime = m_fFadeLen - (t * m_fFadeLen);
					m_dwPhaseAfterReplay = STREAMSOUND_FADEOUT;
					break;
				case	STREAMSOUND_FADEOUT:
					break;
			}
			break;
	}
	LeaveCriticalSection(&m_CriticalSection);
}

//-----------------------------------------------------------------------------
// Name: CStreamSound::Reset()
// Desc: Đ|WV擪ɖ߂
//-----------------------------------------------------------------------------
HRESULT CStreamSound::Reset()
{
    HRESULT hr;

    if( m_lpDSBuffer == NULL || m_pWaveFile == NULL )
        return CO_E_NOTINITIALIZED;

	m_dwLastPlayPos     = 0;
    m_dwPlayProgress    = 0;
    m_dwNextWriteOffset = 0;
    m_bFillNextNotificationWithSilence = FALSE;

    BOOL bRestored;
	if( FAILED( hr = RestoreBuffer( m_lpDSBuffer, &bRestored ) ) ){
        STREAMSOUND_ERR( _T("RestoreBuffer"), hr );
		goto	exitReset;
	}

    if( bRestored )
    {
		if( FAILED( hr = FillBufferWithSound( m_lpDSBuffer ) ) ){
            STREAMSOUND_ERR( _T("FillBufferWithSound"), hr );
			goto	exitReset;
		}
    }

    m_pWaveFile->ResetFile();

    hr = m_lpDSBuffer->SetCurrentPosition( 0L );  

exitReset:
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CStreamSound::Stop()
// Desc: TEh~߂
//-----------------------------------------------------------------------------
HRESULT CStreamSound::Stop()
{
	HRESULT	hr = S_OK;
	switch(m_dwPhase){
		case	STREAMSOUND_RUN:
		case	STREAMSOUND_FADEIN:
		case	STREAMSOUND_FADEOUT:
			EnterCriticalSection(&m_CriticalSection);
            hr = m_lpDSBuffer->Stop();
			if (FAILED(hr)){
				_RPT0(_CRT_WARN,_T("Stop"));
			}
			m_dwPhase = STREAMSOUND_STOP;
			hr = Reset();
			LeaveCriticalSection(&m_CriticalSection);
			break;
		case	STREAMSOUND_PAUSE:
			EnterCriticalSection(&m_CriticalSection);
			m_dwPhase = STREAMSOUND_STOP;
			hr = Reset();
			LeaveCriticalSection(&m_CriticalSection);
			break;
	}
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CStreamSound::SetLoop()
// Desc: TEh~߂
//-----------------------------------------------------------------------------
void CStreamSound::SetLoop(BOOL bLoop)
{
	EnterCriticalSection(&m_CriticalSection);
	this->m_bPlayLooped = bLoop;
	LeaveCriticalSection(&m_CriticalSection);
}

HRESULT	CStreamSound::Pause(){
    if( m_lpDSBuffer == NULL || m_pWaveFile == NULL )
        return CO_E_NOTINITIALIZED;

	EnterCriticalSection(&m_CriticalSection);
	if (m_dwPhase == STREAMSOUND_RUN || m_dwPhase == STREAMSOUND_FADEIN || m_dwPhase == STREAMSOUND_FADEOUT){
		m_lpDSBuffer->Stop();
		m_dwPhaseAfterReplay = m_dwPhase;
		m_dwPhase = STREAMSOUND_PAUSE;
	}
	LeaveCriticalSection(&m_CriticalSection);

	return	S_OK;
}

DWORD WINAPI StreamSound_DoThread(LPVOID pVoid){
	((CStreamSound*)pVoid)->DoThread();
	return	0L;
}
