#pragma once
#ifndef	__WAVEFILE_H__
#include	"WaveFile.h"
#endif
#ifndef	__SOUNDOBJECT_H__
#include	"SoundObject.h"
#endif

//	Polymode Flags
#define	PCMSOUND_POLYMODE_MONO	0
#define	PCMSOUND_POLYMODE_POLY	1
#define	PCMSOUND_POLYMODE_MASK	1

//	Phase
#define PCMSOUND_PHASE_FREE		0
#define	PCMSOUND_PHASE_PLAYING	1
#define	PCMSOUND_PHASE_RELEASE	2

typedef	struct	_soundportdummy{
	struct	_soundportdummy	*prev;
	struct	_soundportdummy	*next;
}	SoundPortDummy;

typedef	struct	_soundport{
	struct	_soundport	*prev;
	struct	_soundport	*next;
	LPDIRECTSOUNDBUFFER	m_lpDSBuffer;
	LONG	m_lVol;
	LONG	m_lPan;
	LONG	m_lFreq;
	LONG	m_lPhase;
	FLOAT	m_fTime;

	DWORD	m_lOriginalVol;
	DWORD	m_lTargetVol;
	FLOAT	m_fVolMoveTime;
	FLOAT	m_fVolMoveLen;

	INT		m_iID;
}	SoundPort;

class CPCMSound : public CSoundObject
{
protected:
	CDSoundEnv			*m_pDSoundEnv;
	SoundPort			*m_pSoundPort;	//	Đ̃|[g
	SoundPort			*m_pFreePort;	//	ҋ@̃|[g
	SoundPortDummy		m_spDummyPlaying;	//	_~[m[h
	SoundPortDummy		m_spDummyFree;		//	_~[m[h
	DWORD				m_dwNumPorts;		//	|[g

    DWORD                m_dwDSBufferSize;
    CWaveFile*           m_pWaveFile;
	TCHAR				*m_strFilename;

	SoundPort			*m_pPorts;
	DWORD				m_dwModeFlags;

	FLOAT				m_fReleaseTime;
	FLOAT				m_fInvReleaseTime;
    HRESULT			RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored );
	void			ReleaseBuffers();
	SoundPort		*GetFreePort();
	virtual void	PollStatus(FLOAT timeElapsed);
	void			SnipPort(SoundPort *pPort);

public:
	CPCMSound(CDSoundEnv *pEnv, LPTSTR strWaveFileName, DWORD dwNumPorts = 2);
	~CPCMSound(void);
	HRESULT	Reload();

	void	SetPolyMode(DWORD dwMode);
	void	SetReleaseTime(FLOAT rt);
    virtual HRESULT Play( DWORD dwPriority = 0, DWORD dwFlags = 0, LONG lVol = 0, LONG lFreq = -1, LONG lPan = 0 ,INT *piPortID = NULL);
	virtual HRESULT ChangeVol ( INT iID, LONG lVol, FLOAT fDuration=0);
	virtual HRESULT ChangeFreq( INT iID, LONG lFreq );
	virtual HRESULT ChangePan ( INT iID, LONG lPan );

	virtual HRESULT GetVol ( INT iID, LONG *pVol );
	virtual HRESULT GetFreq( INT iID, LONG *pFreq );
	virtual HRESULT GetPan ( INT iID, LONG *pPan );

	virtual HRESULT Stop();
    virtual HRESULT Reset();

	virtual HRESULT FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB);

    virtual BOOL IsSoundPlaying();
};
