#include "StdAfx.h"
#include <mmsystem.h>
#include <dsound.h>
#include <crtdbg.h>
#include "DSoundEnv.h"
#include ".\pcmsound.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

static	HRESULT	PCMSOUND_ERR(TCHAR *text,HRESULT hr){
	_RPT1(_CRT_WARN,text,hr);
	return	hr;
}

CPCMSound::CPCMSound(CDSoundEnv *pEnv, LPTSTR strFileName, DWORD dwNumPorts)
{
	size_t	dwLen;
	m_pWaveFile = NULL;

	m_pDSoundEnv = pEnv;
	dwLen = _tcslen(strFileName);
	dwLen += _tcslen(pEnv->GetAppPathName());
	m_strFilename = new TCHAR[dwLen + 3];
	_tcscpy(m_strFilename,pEnv->GetAppPathName());
	_tcscat(m_strFilename,"\\");
	_tcscat(m_strFilename,strFileName);

	m_spDummyPlaying.next = &m_spDummyPlaying;
	m_spDummyPlaying.prev = &m_spDummyPlaying;
	m_pSoundPort = (SoundPort*)&m_spDummyPlaying;

	m_spDummyFree.next = &m_spDummyFree;
	m_spDummyFree.prev = &m_spDummyFree;
	m_pFreePort = (SoundPort*)&m_spDummyFree;

	m_dwNumPorts = dwNumPorts;
	m_pPorts = new SoundPort[dwNumPorts];

	SoundPort	*p;
	for (UINT i = 0; i < dwNumPorts ; ++i){
		p = &m_pPorts[i];
		p->m_lpDSBuffer = NULL;
		p->m_iID = i;
		p->m_lPhase = PCMSOUND_PHASE_FREE;
		p->next = m_pFreePort;
		p->prev = m_pFreePort->prev;
		p->prev->next = p;
		p->next->prev = p;
	}
	m_dwModeFlags = 0L;		//	Default: MONOPHONIC

	SetReleaseTime(2.0f);
	m_pDSoundEnv->AddSoundObject(this);
}

CPCMSound::~CPCMSound(void)
{
	ReleaseBuffers();
	
	SAFE_DELETE(m_pPorts);
	SAFE_DELETE(m_pWaveFile);
	SAFE_DELETE_ARRAY(m_strFilename);
	m_pDSoundEnv->RemoveSoundObject(this);
}

void	CPCMSound::SetReleaseTime(FLOAT rt)
{
	m_fReleaseTime = rt;
	m_fInvReleaseTime = 1.0f/rt;
}
//--------------------------------------------------------------------
//	Name: PCMSound::SetPolyMode
//	Desc: obt@̓̉ۂw肷B
//		PCMSOUND_POLYMODE_MONO : m[h
//		PCMSOUND_POLYMODE_POLY : |[h
//--------------------------------------------------------------------
void CPCMSound::SetPolyMode(DWORD dwMode){
	DWORD	dwFlag = m_dwModeFlags & (~PCMSOUND_POLYMODE_MASK);
	dwFlag |= dwMode;
	m_dwModeFlags = dwFlag;
}

//--------------------------------------------------------------------
//	Name: PCMSound::ReleaseBuffers
//	Desc: pӂꂽ IDirectSoundBuffer IuWFNg[XB
//--------------------------------------------------------------------
void	CPCMSound::ReleaseBuffers(){
	for (UINT i = 0; i < m_dwNumPorts ; ++i){
		SAFE_RELEASE(m_pPorts[i].m_lpDSBuffer);
	}
}

HRESULT	CPCMSound::Reload()
{
	LPDIRECTSOUND8			pDS = NULL;
    HRESULT hr;
    LPDIRECTSOUNDBUFFER  apDSBuffer     = NULL;
    DWORD                dwDSBufferSize = NULL;
    CWaveFile*           pWaveFile      = NULL;
	UINT	i;

	ReleaseBuffers();
	SAFE_DELETE(m_pWaveFile);

	pWaveFile = new CWaveFile();
    if( pWaveFile == NULL )
    {
        hr = E_OUTOFMEMORY;
        goto e_Fail;
    }

	pWaveFile->Open(m_strFilename);

    dwDSBufferSize = pWaveFile->GetSize();
    DSBUFFERDESC dsbd;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
    dsbd.dwSize          = sizeof(DSBUFFERDESC);
    dsbd.dwFlags         = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLFREQUENCY | DSBCAPS_CTRLPAN | DSBCAPS_LOCDEFER ;
    dsbd.dwBufferBytes   = dwDSBufferSize;
    dsbd.guid3DAlgorithm = GUID_NULL;
    dsbd.lpwfxFormat     = pWaveFile->m_pWaveformat;
	
	pDS = m_pDSoundEnv->GetDirectSound();
	hr = pDS->CreateSoundBuffer( &dsbd, &apDSBuffer, NULL );
	if (FAILED(hr)){
		goto	e_Fail;
	}
	m_pPorts->m_lpDSBuffer = apDSBuffer;
	for (i = 1; i < this->m_dwNumPorts ; ++i){
        if( FAILED( hr = pDS->DuplicateSoundBuffer( apDSBuffer, &m_pPorts[i].m_lpDSBuffer ) ) )
        {
            _RPT0(_CRT_WARN, TEXT("DuplicateSoundBuffer"));
            goto e_Fail;
        }
	}
	SAFE_RELEASE(pDS);
	m_dwDSBufferSize = dwDSBufferSize;
	m_pWaveFile = pWaveFile;
	FillBufferWithSound(apDSBuffer);
	return	S_OK;
e_Fail:
	SAFE_RELEASE(pDS);
	SAFE_DELETE(pWaveFile);
	return	hr;
}

//-----------------------------------------------------------------------------
// Name: CPCMSound::FillBufferWithSound()
// Desc: TEht@Cobt@ɓ]B 
//-----------------------------------------------------------------------------
HRESULT CPCMSound::FillBufferWithSound( LPDIRECTSOUNDBUFFER pDSB )
{
    HRESULT hr; 
    VOID*   pDSLockedBuffer      = NULL; // bNꂽobt@ւ̃|C^
    DWORD   dwDSLockedBufferSize = 0;    // bNꂽobt@̃TCY
    DWORD   dwWavDataRead        = 0;    // ǂݍ܂ꂽWAV t@C̃TCY 

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;

    if( FAILED( hr = RestoreBuffer( pDSB, NULL ) ) ) {
        _RPT0(_CRT_WARN,  TEXT("RestoreBuffer"));
		return	hr;
	}

    if( FAILED( hr = pDSB->Lock( 0, m_dwDSBufferSize, 
                                 &pDSLockedBuffer, &dwDSLockedBufferSize, 
                                 NULL, NULL, 0L ) ) )
        return PCMSOUND_ERR( TEXT("Lock"), hr );

    m_pWaveFile->ResetFile();

    if( FAILED( hr = m_pWaveFile->Read( (BYTE*) pDSLockedBuffer,
                                        dwDSLockedBufferSize, 
										&dwWavDataRead ) ) ){
        return PCMSOUND_ERR( TEXT("Read"), hr );
	}

    if( dwWavDataRead < dwDSLockedBufferSize )
    {
        FillMemory( (BYTE*) pDSLockedBuffer + dwWavDataRead, 
                    dwDSLockedBufferSize - dwWavDataRead, 
                    (BYTE)(m_pWaveFile->m_pWaveformat->wBitsPerSample == 8 ? 128 : 0 ) );
    }

    pDSB->Unlock( pDSLockedBuffer, dwDSLockedBufferSize, NULL, 0 );
    return S_OK;
}
//-----------------------------------------------------------------------------
// Name: CPCMSound::RestoreBuffer()
// Desc: ꂽobt@XgA
//-----------------------------------------------------------------------------
HRESULT CPCMSound::RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored )
{
    HRESULT hr;

    if( pDSB == NULL )
        return CO_E_NOTINITIALIZED;
    if( pbWasRestored )
        *pbWasRestored = FALSE;

    DWORD dwStatus;
    if( FAILED( hr = pDSB->GetStatus( &dwStatus ) ) )
        return PCMSOUND_ERR( _T("GetStatus"), hr );

    if( dwStatus & DSBSTATUS_BUFFERLOST ){
        while(true){
            hr = pDSB->Restore();
            if( hr != DSERR_BUFFERLOST )
				break;
            Sleep( 10 );
        }

        if( pbWasRestored != NULL )
            *pbWasRestored = TRUE;

        return S_OK;
    }else{
        return S_FALSE;
    }
}

//-----------------------------------------------------------------------------
// Name: CSound::Play()
// Desc: TEhĐBDSBPLAY_LOOPING tO𗧂Ă
//		TEh̓[vB
//-----------------------------------------------------------------------------
HRESULT CPCMSound::Play( DWORD dwPriority, DWORD dwFlags, LONG lVol, LONG lFreq, LONG lPan, INT *piPortID)
{
    HRESULT hr;
    BOOL    bRestored;
	SoundPort	*pPort = NULL;

	if ((m_dwModeFlags & PCMSOUND_POLYMODE_MASK) == PCMSOUND_POLYMODE_MONO){
		Stop();
	}
	
	pPort = GetFreePort();
	if (pPort == NULL)
		return	E_FAIL;

	LPDIRECTSOUNDBUFFER pDSB = pPort->m_lpDSBuffer;

	if( FAILED( hr = RestoreBuffer( pDSB, &bRestored ) ) ){
        PCMSOUND_ERR( TEXT("RestoreBuffer"), hr );
		goto	e_Fail;
	}

    if( bRestored )
    {
		if( FAILED( hr = FillBufferWithSound( pDSB) ) ){
            PCMSOUND_ERR( TEXT("FillBufferWithSound"), hr );
			goto	e_Fail;
		}
    }

    pDSB->SetVolume( lVol );

    if( lFreq != -1)
    {
        pDSB->SetFrequency( lFreq );
    }
    
    pDSB->SetPan( lPan );

    hr = pDSB->Play( 0, dwPriority, dwFlags );
	if (FAILED(hr))
		goto	e_Fail;
	pPort->m_lFreq = lFreq;
	pPort->m_lPan = lPan;
	pPort->m_lVol = lVol;
	pPort->m_lPhase = PCMSOUND_PHASE_PLAYING;
	pPort->m_fTime = 0;

	pPort->next = m_pSoundPort;
	pPort->prev = m_pSoundPort->prev;
	m_pSoundPort->prev->next = pPort;
	m_pSoundPort->prev = pPort;

	return	S_OK;;

e_Fail:
	if (pPort != NULL){
		pPort->next = m_pFreePort;
		pPort->prev = m_pFreePort->prev;
		m_pFreePort->prev->next = pPort;
		m_pFreePort->prev = pPort;
	}
	return	hr;
}

//-----------------------------------------------------------
//	Name: ChangeVol
//	Desc: PCMTEh̉ʂύXB
//-----------------------------------------------------------
HRESULT CPCMSound::ChangeVol( INT iID, LONG lVol, FLOAT fDuration){

	SoundPort *pPort;
	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		pPort = &(m_pPorts[iID]);
		if (pPort->m_lPhase != PCMSOUND_PHASE_FREE){
			if (fDuration == 0){
				pPort->m_lpDSBuffer->SetVolume(lVol);
			}else{
				pPort->m_fVolMoveLen = fDuration;
				pPort->m_fVolMoveTime = 0;
				pPort->m_lOriginalVol = pPort->m_lVol;
				pPort->m_lTargetVol = lVol;
			}
			return	S_OK;
		}else{
			pPort->m_lVol = lVol;
		}
		return	E_FAIL;
	}else{
		pPort = m_pPorts;
		for (int i = 0; i < (int)m_dwNumPorts ; ++i){
			if (pPort->m_lPhase != PCMSOUND_PHASE_FREE){
				if (fDuration == 0){
					pPort->m_lpDSBuffer->SetVolume(lVol);
				}else{
					pPort->m_fVolMoveLen = fDuration;
					pPort->m_fVolMoveTime = 0;
					pPort->m_lOriginalVol = pPort->m_lVol;
					pPort->m_lTargetVol = lVol;
				}
			}else{
				pPort->m_lVol = lVol;
			}
			++pPort;
		}
	}
	return	S_OK;
}
//-----------------------------------------------------------
//	Name: ChangeFreq
//	Desc: PCMTEh̍ĐxύXB
//-----------------------------------------------------------
HRESULT CPCMSound::ChangeFreq( INT iID, LONG lFreq){

	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		m_pPorts[iID].m_lFreq = lFreq;
		if (m_pPorts[iID].m_lPhase != PCMSOUND_PHASE_FREE){
	        m_pPorts[iID].m_lpDSBuffer->SetFrequency( lFreq );
			return	S_OK;
		}
		return	E_FAIL;
	}else{
		for (int i = 0; i < (int)m_dwNumPorts ; ++i){
			m_pPorts[iID].m_lFreq = lFreq;
			if (m_pPorts[i].m_lPhase != PCMSOUND_PHASE_FREE){
		        m_pPorts[i].m_lpDSBuffer->SetFrequency( lFreq );
			}
		}
	}
	return	S_OK;
}

//-----------------------------------------------------------
//	Name: ChangePan
//	Desc: PCMTEh̒ʂύXB
//-----------------------------------------------------------
HRESULT CPCMSound::ChangePan( INT iID, LONG lPan){

	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		m_pPorts[iID].m_lPan = lPan;
		if (m_pPorts[iID].m_lPhase != PCMSOUND_PHASE_FREE){
			m_pPorts[iID].m_lpDSBuffer->SetPan( lPan );
			return	S_OK;
		}
		return	E_FAIL;
	}else{
		for (int i = 0; i < (int)m_dwNumPorts ; ++i){
			m_pPorts[iID].m_lPan = lPan;
			if (m_pPorts[i].m_lPhase != PCMSOUND_PHASE_FREE){
				m_pPorts[i].m_lpDSBuffer->SetPan( lPan );
			}
		}
	}
	return	S_OK;
}

//-----------------------------------------------------------
//	Name: GetVol
//	Desc: PCMTEh̉ʂ擾B
//-----------------------------------------------------------
HRESULT CPCMSound::GetVol( INT iID, LONG *pVol){

	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		if (m_pPorts[iID].m_lPhase != PCMSOUND_PHASE_FREE){
			*pVol = m_pPorts[iID].m_lVol;
			return	S_OK;
		}
	}
	return	E_FAIL;
}

//-----------------------------------------------------------
//	Name: GetFreq
//	Desc: PCMTEh̍Đx擾B
//-----------------------------------------------------------
HRESULT CPCMSound::GetFreq( INT iID, LONG *pFreq){

	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		if (m_pPorts[iID].m_lPhase != PCMSOUND_PHASE_FREE){
			*pFreq = m_pPorts[iID].m_lFreq;
			return	S_OK;
		}
	}
	return	E_FAIL;
}

//-----------------------------------------------------------
//	Name: GetPan
//	Desc: PCMTEh̒ʂ擾B
//-----------------------------------------------------------
HRESULT CPCMSound::GetPan( INT iID, LONG *pPan){

	if (iID >= 0 && iID < (INT)m_dwNumPorts){
		if (m_pPorts[iID].m_lPhase != PCMSOUND_PHASE_FREE){
			*pPan = m_pPorts[iID].m_lPan;
			return	S_OK;
		}
	}
	return	E_FAIL;
}


//-----------------------------------------------------------
//	Name: GetFreePort
//	Desc: gp\ȁiłȂj|[g擾B
//-----------------------------------------------------------
SoundPort	*CPCMSound::GetFreePort(){
	SoundPort	*p=NULL;
	DWORD	dwStatus;
	p = m_pFreePort->next;
	if (p != m_pFreePort){
		if (p->m_lpDSBuffer == NULL)
			return	NULL;
		p->m_lpDSBuffer->GetStatus(&dwStatus);
		if ((dwStatus & DSBSTATUS_PLAYING)!= 0){
			p->m_lpDSBuffer->Stop();
			p->m_lpDSBuffer->SetCurrentPosition(0);
		}
		SnipPort(p);
		return	p;
	}
	p = m_pSoundPort->next;
	if (p == m_pSoundPort)
		return	NULL;
	p->m_lpDSBuffer->Stop();
	p->m_lpDSBuffer->SetCurrentPosition(0);
	SnipPort(p);
	return	p;
}

void	CPCMSound::PollStatus(FLOAT timeElapsed){

	SoundPort	*p;
	SoundPort	*next;
	DWORD	dwStatus;
	LONG	lVol;
	p = m_pSoundPort->next;
	BOOL	bFlag;
	while(p != m_pSoundPort){
		next = p->next;
		bFlag = false;
		if (SUCCEEDED(p->m_lpDSBuffer->GetStatus(&dwStatus))){
			if (p->m_fVolMoveLen){
				p->m_fVolMoveTime += timeElapsed;
				if (p->m_fVolMoveTime >= p->m_fVolMoveLen){
					p->m_lVol = p->m_lTargetVol;
					p->m_fVolMoveLen = 0;
					p->m_fVolMoveTime = 0;
				}else{
					FLOAT	fVol1, fVol2;
					fVol1 = (FLOAT)p->m_lTargetVol * p->m_fVolMoveTime;
					fVol2 = (FLOAT)p->m_lOriginalVol * (p->m_fVolMoveLen - p->m_fVolMoveTime);
					p->m_lVol = (LONG)((fVol1+fVol2)/p->m_fVolMoveLen);
				}
			}
			switch(p->m_lPhase){
				case	PCMSOUND_PHASE_PLAYING:
					break;
				case	PCMSOUND_PHASE_RELEASE:
					p->m_fTime += timeElapsed;
					if (p->m_fTime < m_fReleaseTime){
						lVol = -9600 - p->m_lVol;
						lVol = (long)((FLOAT)lVol * (p->m_fTime) * m_fInvReleaseTime);
						lVol += p->m_lVol;
						p->m_lpDSBuffer->SetVolume(lVol);
					}else{
						p->m_lpDSBuffer->Stop();
						p->m_lpDSBuffer->SetCurrentPosition(0);
						p->m_lPhase = 0;
					}
					break;
			}
			if (((dwStatus & DSBSTATUS_PLAYING) == 0)||(p->m_lPhase == 0)){
				SnipPort(p);

				p->prev = m_pFreePort->prev;
				p->next = m_pFreePort;
				m_pFreePort->prev->next = p;
				m_pFreePort->prev = p;
			}
		}
		p = next;
	}
}

//-------------------------------------------------
//	Name: SnipPort
//	Desc: |[gNXgSnipB
//-------------------------------------------------
void	CPCMSound::SnipPort(SoundPort *pPort){
	pPort->m_lPhase = PCMSOUND_PHASE_FREE;
	pPort->prev->next = pPort->next;
	pPort->next->prev = pPort->prev;
}

//-----------------------------------------------------------------------------
// Name: CPCMSound::Stop()
// Desc: TEh~߂
//-----------------------------------------------------------------------------
HRESULT CPCMSound::Stop()
{
	HRESULT	hr = 0;
	SoundPort	*p;
	p = m_pSoundPort->next;
	while( p != m_pSoundPort ){
		if (m_fReleaseTime == 0.0f)
			hr |= p->m_lpDSBuffer->Stop();
		else{
			if (p->m_lPhase == PCMSOUND_PHASE_PLAYING)
				p->m_lPhase = PCMSOUND_PHASE_RELEASE;
		}
		p = p->next;
	}
    return hr;
}

//-----------------------------------------------------------------------------
// Name: CPCMSound::Reset()
// Desc: TEhobt@Zbg
//-----------------------------------------------------------------------------
HRESULT CPCMSound::Reset()
{
	HRESULT	hr = 0;
	SoundPort	*p;
	p = m_pSoundPort->next;
	while( p != m_pSoundPort ){
		hr |= p->m_lpDSBuffer->SetCurrentPosition(0);
		p = p->next;
	}
    return hr;
}

//-----------------------------------------------------------------------------
// Name: CPCMSound::IsSoundPlaying()
// Desc: obt@ĐȂAtrue ԂB
//-----------------------------------------------------------------------------
BOOL CPCMSound::IsSoundPlaying()
{
    BOOL bIsPlaying = FALSE;
	SoundPort	*p;
    DWORD dwStatus = 0;

	p = m_pSoundPort->next;
	while( p != m_pSoundPort ){
		p->m_lpDSBuffer->GetStatus( &dwStatus );
	    bIsPlaying |= ( ( dwStatus & DSBSTATUS_PLAYING ) != 0 );
		p = p->next;
	}

	return bIsPlaying;
}
