//-------------------------------------------------------------------------------
//	class : CDSoundEnv
//	Desc : DirectSound gp邽߂̃TEhNXB
//	First edition: July.02.2005
//	Copyright: Mr.K
//-------------------------------------------------------------------------------


#define STRICT
#include "stdafx.h"
#include <mmsystem.h>
#include <dsound.h>
#include <crtdbg.h>
#include "DSoundEnv.h"
#include "SoundObject.h"
#include "DSHighResTimer.h"

#define	SAFE_RELEASE(o)	{if (o){	(o)->Release(); (o) = NULL;	}}
#define	SAFE_DELETE(o)	{if (o){	delete (o); (o) = NULL;	}}
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }

static	HRESULT	DSENV_ERR(TCHAR *text,HRESULT hr){
	_RPT1(_CRT_WARN,text,hr);
	return	hr;
}

//-------------------------------------------------------------
//	Name: GetAppPathName
//  Desc: R}hC擾ANpX𓾂
//-------------------------------------------------------------
void CDSoundEnv::PrepareAppPathName()
{
	int l,i;
	TCHAR *str = m_strAppPathName,*c;
	lstrcpy( str, ::GetCommandLine());  // NAvP[V̐΃pX擾B 
	l = (int)strlen(str);
	if (str[0]=='\"'){
		for(i = 0; i < l; ++i){
			str[i] = str[i+1];
		}
		--l;
	}  // " Ŏn܂ĂAꕶ߂B 
	c = strrchr(str,'\\');
	if (c){
		*c=0;
	}else{ 
		m_strAppPathName[0]=0;
	}
} 

CDSoundEnv::CDSoundEnv(DWORD dwChannels, DWORD dwFS, DWORD dwBitRate )
{
	m_pDS = NULL;
	m_dwPrimaryChannels = dwChannels;
	m_dwPrimaryFS = dwFS;
	m_dwPrimaryBitRate = dwBitRate;
	m_soDummy.m_pNext = &m_soDummy;
	m_soDummy.m_pPrev = &m_soDummy;
	m_pObjectRoot = &m_soDummy;
	m_pTimer = new CDSHighResTimer();
	m_pTimer->Reset();
	PrepareAppPathName();
}

CDSoundEnv::~CDSoundEnv(){

	CSoundObject	*pObj;
	CSoundObject	*pNext;

	pObj = m_pObjectRoot->m_pNext;
	while(pObj != m_pObjectRoot){
		pNext = pObj->m_pNext;
		delete	pObj;
		pObj = pNext;
	}
	SAFE_DELETE(m_pTimer);
	SAFE_RELEASE(m_pDS);
}

//-----------------------------------------------------------------------------
// Name: CDSoundEnv::GetAppPathName()
// Desc: AvP[V̋NpXԂB
//-----------------------------------------------------------------------------
TCHAR	*CDSoundEnv::GetAppPathName(){
	return	m_strAppPathName;
}

//-----------------------------------------------------------------------------
// Name: CDSoundEnv::Initialize()
// Desc: IDirectSound object AvC}obt@ݒ肷B
//-----------------------------------------------------------------------------

HRESULT CDSoundEnv::Initialize(HWND hWnd, DWORD dwCoopL){
    HRESULT             hr;
    SAFE_RELEASE( m_pDS );

    // IDirectSound IuWFNg𐶐
    if( FAILED( hr = DirectSoundCreate8( NULL, &m_pDS, NULL ) ) ){
		_RPT1(_CRT_WARN,"DirectSoundCreate8Ɏs 0x%x",hr);
		//DSENV_ERR("DirectSoundCreate8Ɏs 0x%x",hr);
		return	hr;
	}

    // xݒ肷B
    if( FAILED( hr = m_pDS->SetCooperativeLevel( hWnd, dwCoopL ) ) ){
		DSENV_ERR("SetCooperativeLevels 0x%x",hr);
		return	hr;
	}
    return SetPrimaryBufferFormat();

}

//-----------------------------------------------------------------------------
// Name: CSoundManager::SetPrimaryBufferFormat()
// Desc: PrimaryBuffer tH[}bgݒ肷B
//-----------------------------------------------------------------------------
HRESULT CDSoundEnv::SetPrimaryBufferFormat()
{
    HRESULT             hr;
    LPDIRECTSOUNDBUFFER pDSBPrimary = NULL;

    if( m_pDS == NULL )
        return CO_E_NOTINITIALIZED;

    // vC}obt@擾
    DSBUFFERDESC dsbd;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
    dsbd.dwSize        = sizeof(DSBUFFERDESC);
    dsbd.dwFlags       = DSBCAPS_PRIMARYBUFFER;
    dsbd.dwBufferBytes = 0;
    dsbd.lpwfxFormat   = NULL;
       
    if( FAILED( hr = m_pDS->CreateSoundBuffer( &dsbd, &pDSBPrimary, NULL ) ) ){
		DSENV_ERR(_T("CreateSoundBufferɎs 0x%x"),hr);
		return	hr;
	}

    WAVEFORMATEX wfx;
    ZeroMemory( &wfx, sizeof(WAVEFORMATEX) ); 
    wfx.wFormatTag      = (WORD) WAVE_FORMAT_PCM; 
    wfx.nChannels       = (WORD) m_dwPrimaryChannels; 
    wfx.nSamplesPerSec  = (DWORD) m_dwPrimaryFS; 
    wfx.wBitsPerSample  = (WORD) m_dwPrimaryBitRate; 
    wfx.nBlockAlign     = (WORD) (wfx.wBitsPerSample / 8 * wfx.nChannels);
    wfx.nAvgBytesPerSec = (DWORD) (wfx.nSamplesPerSec * wfx.nBlockAlign);

    if( FAILED( hr = pDSBPrimary->SetFormat(&wfx) ) ){
        _RPT0(_CRT_WARN, _T("SetFormatɎs"));
		return	hr;
	}
    SAFE_RELEASE( pDSBPrimary );

    return S_OK;
}

//-----------------------------------------------------------------------------
// Name: CDSoundEnv::GetDirectSound()
// Desc: IDirectSound object ԂBQƃJEgCNĝŁA
//		ĂяoŃ[XKvB
//-----------------------------------------------------------------------------
LPDIRECTSOUND8 CDSoundEnv::GetDirectSound(){
	m_pDS->AddRef();
	return	m_pDS;
}

//-----------------------------------------------------------------------------
// Name: CDSoundEnv::AddSoundObject()
// Desc: CSoundObject NX̃IuWFNg{̊ǗɒuB
//-----------------------------------------------------------------------------
void	CDSoundEnv::AddSoundObject(CSoundObject *pObj){

	pObj->m_pNext = m_pObjectRoot;
	pObj->m_pPrev = m_pObjectRoot->m_pPrev;

	m_pObjectRoot->m_pPrev->m_pNext = pObj;
	m_pObjectRoot->m_pPrev = pObj;

}

//-----------------------------------------------------------------------------
// Name: CDSoundEnv::RemoveSoundObject()
// Desc: w肳ꂽ CSoundObject NX̃IuWFNg{̊Ǘ菜B
//-----------------------------------------------------------------------------
void	CDSoundEnv::RemoveSoundObject(CSoundObject *pObj){
	pObj->m_pPrev->m_pNext = pObj->m_pNext;
	pObj->m_pNext->m_pPrev = pObj->m_pPrev;
}

void	CDSoundEnv::PollStatus(){
	CSoundObject	*pObj;
	FLOAT	timeElapsed = m_pTimer->GetElapsedTimeAndReset();
	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;

	pObj = m_pObjectRoot->m_pNext;
	while(pObj != m_pObjectRoot){
		pObj->PollStatus(timeElapsed);
		pObj = pObj->m_pNext;
	}
}
