#include "stdafx.h"
#include <stdio.h>
#include <d3dx9.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"
#include "JITBillboard.h"

CD3DEnv	*g_pD3DEnv = NULL; // D3DQuickLib 񋟂`B

CJITBillboard   *g_pBillboard = NULL;

#define	TEXTURE_SIZE	512	//	eNX`vf̃TCYiEƂj
#define	WINDOW_WIDTH	320	//	\EBhE
#define	WINDOW_HEIGHT	240	//	\EBhE
#define	ACTIVATION_MARGIN	160	//	eNX`fR[hp̃TCYg
#define	TEXTURE_COLS	4	//	̃eNX`
#define	TEXTURE_ROWS	4	//	c̃eNX`

#define	SMALL_TEXTURE_SIZE	16


float   g_fTime = 0;
float	g_fX = 1024-160;
float	g_fY = 1024-160;
//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//        UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
	static float time = 0;
	int	dwleft, dwtop, dwright, dwbottom;
	if (timeElapsed > 2.0f){
		timeElapsed = 2.0f;
	}

	if (GetAsyncKeyState(VK_LEFT)){
		g_fX -= timeElapsed;
	}
	if (GetAsyncKeyState(VK_RIGHT)){
		g_fX += timeElapsed;
	}
	if (GetAsyncKeyState(VK_UP)){
		g_fY -= timeElapsed;
	}
	if (GetAsyncKeyState(VK_DOWN)){
		g_fY += timeElapsed;
	}
	dwleft  = (int)g_fX - ACTIVATION_MARGIN;
	dwtop = (int)g_fY - ACTIVATION_MARGIN;
	dwright = dwleft + (ACTIVATION_MARGIN + WINDOW_WIDTH + ACTIVATION_MARGIN);
	dwbottom = dwtop + (ACTIVATION_MARGIN + WINDOW_HEIGHT + ACTIVATION_MARGIN);

	dwleft /= TEXTURE_SIZE;
	dwtop /= TEXTURE_SIZE;
	dwright /= TEXTURE_SIZE;
	dwbottom /= TEXTURE_SIZE;
	for (int row = 0 ; row < TEXTURE_ROWS ; row ++){
		for (int col = 0 ; col < TEXTURE_COLS ; col++){
			if (col >= dwleft && row >= dwtop 
				&& col <= dwright && row <= dwbottom)
				g_pBillboard->Activate(row * TEXTURE_COLS + col);
			else
				g_pBillboard->Inactivate(row * TEXTURE_COLS + col);

		}
	}
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//        UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
	int	dwleft, dwtop, dwright, dwbottom;
	int	dwx, dwy;
	int	x, y;

	dwleft  = (int)g_fX;
	dwtop = (int)g_fY;
	dwx = dwleft;
	dwy = dwtop;
	dwright = dwleft + WINDOW_WIDTH - 1;
	dwbottom = dwtop + WINDOW_HEIGHT - 1;
	dwleft /= TEXTURE_SIZE;
	dwtop /= TEXTURE_SIZE;
	dwright /= TEXTURE_SIZE;
	dwbottom /= TEXTURE_SIZE;

	g_pBillboard->SetDiffuse(D3DCOLOR_XRGB(255,255,255));
	for (int row = dwtop ; row <= dwbottom ; row ++){
		for (int col = dwleft ; col <= dwright ; col++){
			if (col >= 0 && row >= 0 && col < TEXTURE_COLS && row < TEXTURE_ROWS){
				x = col * TEXTURE_SIZE - dwx;
				y = row * TEXTURE_SIZE - dwy;
				g_pBillboard->Render(lpd3ddev,(FLOAT)x, (FLOAT)y,(FLOAT)TEXTURE_SIZE,(FLOAT)TEXTURE_SIZE,row*TEXTURE_COLS+col);
			}
		}
	}
	y = 10;
	for (int row = 0 ; row < TEXTURE_ROWS ; ++row){
		x = WINDOW_WIDTH - 74;
		for (int col = 0; col < TEXTURE_COLS ; ++col){
			if (g_pBillboard->IsActive(row*4+col)){
				g_pBillboard->SetDiffuse(D3DCOLOR_XRGB(255,255,255));
			}else
				g_pBillboard->SetDiffuse(D3DCOLOR_XRGB(128,128,255));
			g_pBillboard->Render(lpd3ddev,(FLOAT)x, (FLOAT)y,
				(FLOAT)SMALL_TEXTURE_SIZE-1,(FLOAT)SMALL_TEXTURE_SIZE-1,-1/*row*4+col*/);
			x += SMALL_TEXTURE_SIZE;
		}
		y += SMALL_TEXTURE_SIZE;
	}

	x = (int)g_fX - 160;
	y = (int)g_fY - 160;
	x /= (TEXTURE_SIZE / SMALL_TEXTURE_SIZE);
	y /= (TEXTURE_SIZE / SMALL_TEXTURE_SIZE);
	x += WINDOW_WIDTH - 74;
	y += 10;
	g_pBillboard->SetDiffuse(D3DCOLOR_ARGB(128,32,32,255));
	g_pBillboard->SetBlendingMethod(BILLBOARD_SEMI_TRANS);
	g_pBillboard->Render(lpd3ddev,(FLOAT)x,(FLOAT)y,20,18,-1);
	g_pBillboard->SetDiffuse(D3DCOLOR_XRGB(255,255,255));

	g_pBillboard->SetBlendingMethod(BILLBOARD_ADD_IN);
	x = (int)g_fX;
	y = (int)g_fY;
	x /= (TEXTURE_SIZE / SMALL_TEXTURE_SIZE);
	y /= (TEXTURE_SIZE / SMALL_TEXTURE_SIZE);
	x += WINDOW_WIDTH - 74;
	y += 10;
	g_pBillboard->SetDiffuse(D3DCOLOR_ARGB(128,255,32,32));
	g_pBillboard->Render(lpd3ddev,(FLOAT)x,(FLOAT)y,10,8,-1);
	g_pBillboard->SetDiffuse(D3DCOLOR_XRGB(255,255,255));
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "Game";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Game",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,
                CW_USEDEFAULT,0,320,240,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        320 * 2 - client.right,
        240 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    //    D3DQuickLib ̏
    g_pD3DEnv = new CD3DEnv();
    if (FAILED(g_pD3DEnv->InitD3D(hWnd))){
        DestroyWindow(hWnd);
	}else{
		TCHAR	tmp[512];
		g_pBillboard = new CJITBillboard(g_pD3DEnv,16);
		for(int i = 0 ; i <16 ; ++i){
			_stprintf_s(tmp,512,_T("terrain_%02d.jpg"),i+1);
			g_pBillboard->SetTexture(i,tmp);
		}
		g_pD3DEnv->ReloadGraphics();
	}

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			if (g_pD3DEnv->GetElapsedTime() >= 1.0f)
	            g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
    //    D3DQuickLib ̏I
	SAFE_DELETE(g_pBillboard);
    SAFE_DELETE(g_pD3DEnv);
    
    return (int)msg.wParam;
}


LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            //    EChEő剻ꂽAtXN[[hɂB
            if (SIZE_MAXIMIZED == wParam){
                //if (g_pD3DEnv->IsWindowed())
                    //g_pD3DEnv->ToggleFullscreen();
            }
            break;
        case    WM_SETCURSOR:
            //    tXN[̓J[\\ȂB
            if (g_pD3DEnv->IsWindowed())
                ::SetCursor(::LoadCursor(NULL,IDC_ARROW));
            else
                ::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            //    Alt-Enter ŃtXN[[h֐؂ւ
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    //g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
            if (!g_pD3DEnv->IsWindowed()){    //    tXN[
                if (wParam != SC_CLOSE)
                    break;

                //    WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
                Sleep(100);
            }
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
