#pragma once
#include ".\d3dquicklib\billboard.h"

#define	JIT_PHASE_INACTIVE	0
#define	JIT_PHASE_LOADED	1
#define	JIT_PHASE_DECODING	2
#define	JIT_PHASE_ACTIVE	3

class	CJITBillboard;
typedef struct{
	volatile CHAR	m_cMainThreadState;
	volatile CHAR	m_cDecoderState;
	BYTE	*m_pData;
	DWORD	m_dwSize;
	CRITICAL_SECTION	m_csRender;
}	JIT_TEXTURE;

class CJITBillboard :
	public CBillboard
{
public:
	CJITBillboard(CD3DEnv *pEnv,INT num);
	virtual ~CJITBillboard(void);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual void	Activate(DWORD dwTexNo);
	virtual void	Inactivate(DWORD dwTexNo);
	virtual BOOL	IsActive(DWORD dwTexNo);
	virtual HRESULT	SetTexture(DWORD dwTexNo, LPSTR fName);
	static void		ThreadProc(LPVOID data);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, int texNo);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, int texNo);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo);
protected:
	virtual void	Decode(DWORD dwTexNo);
	CRITICAL_SECTION	m_csDecode;
	JIT_TEXTURE	*m_pJITTextures;
	D3DFORMAT	m_fmtTexture;
	DWORD		m_decodeCount;
	volatile BOOL		m_bThread;
	volatile BOOL		m_bThreadActive;
};
