//
//	class CJITBillboard
//	Note	k摜̃eNX`ɒuA
//			w΁AfR[hăeNX`ƂĎg悤ɂNX
//			

#include "StdAfx.h"
#include <d3dx9.h>
#include <stdio.h>
#include "D3DQuickLib.h"
#include "JITBillboard.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>

CJITBillboard::CJITBillboard(CD3DEnv *pEnv, INT num) : CBillboard(pEnv,num)
{
	m_pJITTextures = new JIT_TEXTURE[num];
	JIT_TEXTURE	*pTex;
	InitializeCriticalSection(&m_csDecode);
	if (m_pJITTextures != NULL){
		for (int i = 0 ; i < num ; ++i){
			pTex = &m_pJITTextures[i];
			pTex->m_cMainThreadState = JIT_PHASE_INACTIVE;
			pTex->m_cDecoderState = JIT_PHASE_INACTIVE;
			pTex->m_pData = NULL;
			InitializeCriticalSection(&pTex->m_csRender);
		}
	}
	m_decodeCount = 0;
	m_fmtTexture = D3DFMT_A1R5G5B5;
	m_bThread = true;
	m_bThreadActive = false;
	//	Decoder Thread ͏펞L
	_beginthread(CJITBillboard::ThreadProc,0,(LPVOID)this);

}

CJITBillboard::~CJITBillboard(void)
{
	JIT_TEXTURE	*pTex;
	m_bThread = false;

	//	Decoder Thread ̏I҂
	while(m_bThreadActive){
		Yield();
	}

	if (m_pJITTextures != NULL){
		EnterCriticalSection(&m_csDecode);
		for (int i = 0 ; i < (INT)m_dwNumTextures ; ++i){
			pTex = &m_pJITTextures[i];
			DeleteCriticalSection(&pTex->m_csRender);
			SAFE_DELETE(pTex->m_pData);
		}
		SAFE_DELETE(m_pJITTextures);
		LeaveCriticalSection(&m_csDecode);
	}
}

//------------------------------------------------------
//	eNX`t@C̓o^
//
//		dwTexNo: eNX`ԍ
//		strName: t@C
//------------------------------------------------------
HRESULT	CJITBillboard::SetTexture(DWORD dwTexNo,LPSTR strName){
	if (dwTexNo >= this->m_dwNumTextures)
		return	E_FAIL;
	JIT_TEXTURE	*pTex = &m_pJITTextures[dwTexNo];
	SAFE_DELETE(pTex->m_pData);
	if (FAILED(CBillboard::SetTexture(dwTexNo,strName))){
		return	E_FAIL;
	}

	EnterCriticalSection(&m_csDecode);
	if (pTex->m_cDecoderState == JIT_PHASE_ACTIVE){
		SAFE_RELEASE(m_pTexture[dwTexNo].m_lpTex);
		m_pTexture[dwTexNo].m_sOrdHeight = 0;
		m_pTexture[dwTexNo].m_sOrdWidth  = 0;
		m_pTexture[dwTexNo].m_sTexHeight = 0;
		m_pTexture[dwTexNo].m_sTexWidth  = 0;
	}
	pTex->m_cMainThreadState = JIT_PHASE_INACTIVE;
	pTex->m_cDecoderState = JIT_PHASE_INACTIVE;

	TCHAR	strTexturePath[512];
	if (m_ppFilenames[dwTexNo] != NULL){
		struct _stat	a;
		_tcscpy_s(strTexturePath,sizeof(strTexturePath),m_lpD3DEnv->GetAppPathName());
		_tcscat_s(strTexturePath,sizeof(strTexturePath),"\\");
		_tcscat_s(strTexturePath,sizeof(strTexturePath),m_ppFilenames[dwTexNo]);
		if (0 == _stat(strTexturePath,&a)){
			FILE	*fp = NULL;
			pTex->m_pData = new BYTE[a.st_size];
			pTex->m_dwSize = a.st_size;
			_tfopen_s(&fp,strTexturePath,_T("rb"));
			if (fp != NULL){
				fread((LPVOID)pTex->m_pData,1,a.st_size,fp);
				fclose(fp);
				pTex->m_cMainThreadState = JIT_PHASE_LOADED;
				pTex->m_cDecoderState = JIT_PHASE_LOADED;
			}
		}
	}
	LeaveCriticalSection(&m_csDecode);

	return	S_OK;

}

HRESULT	CJITBillboard::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	D3DCAPS9    d3dCaps;
	JIT_TEXTURE	*pTex;

	lpd3ddev->GetDeviceCaps(&d3dCaps);
	m_bUseHWNPatches = (d3dCaps.DevCaps & D3DDEVCAPS_NPATCHES);

	//
	//	p\ȃtH[}bgmF
	//
	HRESULT    hr;
    D3DFORMAT           TextureFormat[] = {D3DFMT_A8R8G8B8,D3DFMT_A4R4G4B4,D3DFMT_A1R5G5B5};
    int                 iFormat;
    for (iFormat = 0; iFormat < (sizeof(TextureFormat)/sizeof(D3DFORMAT)); ++iFormat){
		hr = m_lpD3DEnv->CheckDeviceFormat(0,D3DRTYPE_TEXTURE,TextureFormat[iFormat]);
        if (SUCCEEDED(hr))
			break;
    }
	if (iFormat >= sizeof(TextureFormat)/sizeof(D3DFORMAT)){
		iFormat--;
	}
	m_fmtTexture = TextureFormat[iFormat];

	EnterCriticalSection(&m_csDecode);
	for (int i = 0; i < (INT)m_dwNumTextures ; ++i){
		pTex = &m_pJITTextures[i];
		if (m_pTexture[i].m_lpTex == NULL){
			if (pTex->m_cDecoderState == JIT_PHASE_ACTIVE){
				Decode((DWORD)i);
			}
		}
	}
	LeaveCriticalSection(&m_csDecode);
	m_uiBillboardStatus = BILLBOARD_IS_RESTORED;
    return S_OK;
}

HRESULT	CJITBillboard::InvalidateDeviceObjects(){
	JIT_TEXTURE	*pTex;
	EnterCriticalSection(&m_csDecode);
	for (int i = 0; i < (INT)m_dwNumTextures ; ++i){
		pTex = &m_pJITTextures[i];
		if (pTex->m_cDecoderState == JIT_PHASE_ACTIVE){
			SAFE_RELEASE(m_pTexture[i].m_lpTex);
			m_pTexture[i].m_sOrdHeight = 0;
			m_pTexture[i].m_sOrdWidth  = 0;
			m_pTexture[i].m_sTexHeight = 0;
			m_pTexture[i].m_sTexWidth  = 0;
		}
	}
	LeaveCriticalSection(&m_csDecode);
	m_uiBillboardStatus = BILLBOARD_IS_INITIALIZED;
    return S_OK;
}

//------------------------------------------------------
//	eNX`̃ANeBu
//		dwTexNo: eNX`ԍ
//------------------------------------------------------
void CJITBillboard::Activate(DWORD dwTexNo){
	JIT_TEXTURE	*pTex = &m_pJITTextures[dwTexNo];
	if (dwTexNo >= m_dwNumTextures)
		return;
	if (pTex->m_cMainThreadState == JIT_PHASE_ACTIVE)
		return;
	pTex->m_cMainThreadState = JIT_PHASE_ACTIVE;
}

//------------------------------------------------------
//	eNX`̖
//		dwTexNo: eNX`ԍ
//------------------------------------------------------
void CJITBillboard::Inactivate(DWORD dwTexNo){
	JIT_TEXTURE	*pTex = &m_pJITTextures[dwTexNo];
	if (dwTexNo >= m_dwNumTextures)
		return;
	if (pTex->m_cMainThreadState != JIT_PHASE_ACTIVE)
		return;
	pTex->m_cMainThreadState = JIT_PHASE_LOADED;
}

//
//	eNX`Ԃ`FbN
//
BOOL CJITBillboard::IsActive(DWORD dwTexNo){
	JIT_TEXTURE	*pTex = &m_pJITTextures[dwTexNo];
	if (dwTexNo >= m_dwNumTextures)
		return	false;
	if (pTex->m_cDecoderState == JIT_PHASE_DECODING)
		return	true;
	if (pTex->m_cDecoderState == JIT_PHASE_ACTIVE)
		return	true;
	return	false;
}



//
//	Decoder Thread vV[W
//
//	XbhsɁASeNX`̏Ԃ`FbN̂ŁA
//	܂Ił͖B
//
void CJITBillboard::ThreadProc(LPVOID data){
	JIT_TEXTURE	*pTex;
	CJITBillboard	*pBillboard = (CJITBillboard*)data;
	pBillboard->m_bThreadActive = true;
	while(pBillboard->m_bThread){
		Sleep(10);
		EnterCriticalSection(&pBillboard->m_csDecode);

		for (int i = 0; i < (INT)pBillboard->m_dwNumTextures ; ++i){
			pTex = &pBillboard->m_pJITTextures[i];
			if (pTex->m_cDecoderState == JIT_PHASE_ACTIVE && pTex->m_cMainThreadState == JIT_PHASE_LOADED){
				EnterCriticalSection(&pTex->m_csRender);
				SAFE_RELEASE(pBillboard->m_pTexture[i].m_lpTex);
				pBillboard->m_pTexture[i].m_sOrdHeight = 0;
				pBillboard->m_pTexture[i].m_sOrdWidth  = 0;
				pBillboard->m_pTexture[i].m_sTexHeight = 0;
				pBillboard->m_pTexture[i].m_sTexWidth  = 0;
				pTex->m_cDecoderState = JIT_PHASE_LOADED;
				LeaveCriticalSection(&pTex->m_csRender);
				pTex->m_cDecoderState = JIT_PHASE_LOADED;
			}else{
				if (pTex->m_cDecoderState == JIT_PHASE_LOADED && pTex->m_cMainThreadState == JIT_PHASE_ACTIVE){
					pTex->m_cDecoderState = JIT_PHASE_DECODING;
					EnterCriticalSection(&pTex->m_csRender);
					pBillboard->Decode(i);
					LeaveCriticalSection(&pTex->m_csRender);
					pTex->m_cDecoderState = JIT_PHASE_ACTIVE;
				}
			}
		}
		LeaveCriticalSection(&pBillboard->m_csDecode);
	}
	pBillboard->m_bThreadActive = false;
}

//
//	keNX`̃fR[h
//
void CJITBillboard::Decode(DWORD texno){
	JIT_TEXTURE	*pTex = &m_pJITTextures[texno];
	LPDIRECT3DTEXTURE9	lpTex;
	LPDIRECT3DDEVICE9	lpd3ddev;
    D3DXIMAGE_INFO	srcImgInfo;
	D3DSURFACE_DESC	d3dsDesc;
	HRESULT	hr;
	if (SUCCEEDED(m_lpD3DEnv->GetD3DDevice(&lpd3ddev))){
		if (m_pTexture[texno].m_lpTex == NULL){
			lpTex = NULL;
			hr = D3DXCreateTextureFromFileInMemoryEx(lpd3ddev,
				pTex->m_pData,pTex->m_dwSize,
				D3DX_DEFAULT,D3DX_DEFAULT,D3DX_DEFAULT,0,
				m_fmtTexture,D3DPOOL_MANAGED,
				D3DX_FILTER_NONE,D3DX_DEFAULT,
				0,        //    Color key.
				&srcImgInfo,NULL,&lpTex);
			++m_decodeCount;
			m_pTexture[texno].m_lpTex = lpTex;
			if (lpTex != NULL){
				if (S_OK == lpTex->GetLevelDesc(0,&d3dsDesc)){
					m_pTexture[texno].m_sOrdWidth  = (USHORT)srcImgInfo.Width;
					m_pTexture[texno].m_sOrdHeight = (USHORT)srcImgInfo.Height;
					m_pTexture[texno].m_sTexWidth  = (USHORT)d3dsDesc.Width;
					m_pTexture[texno].m_sTexHeight = (USHORT)d3dsDesc.Height;
				}
			}
		}

		lpd3ddev->Release();
	}
}

//
//	_OEEErǉ
//
void	CJITBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, int texNo){
	if (texNo >= 0 && texNo < (INT)m_dwNumTextures){
		JIT_TEXTURE	*pTex = &m_pJITTextures[texNo];
		EnterCriticalSection(&pTex->m_csRender);
		CBillboard::Render(lpd3ddev,pMatWorld,pMatView,fW,fH,texNo);
		LeaveCriticalSection(&pTex->m_csRender);
	}else{
		CBillboard::Render(lpd3ddev,pMatWorld,pMatView,fW,fH,texNo);
	}
}

void	CJITBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fW, FLOAT fH, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo){
	if (texNo >= 0 && texNo < (INT)m_dwNumTextures){
		JIT_TEXTURE	*pTex = &m_pJITTextures[texNo];
		EnterCriticalSection(&pTex->m_csRender);
		CBillboard::Render(lpd3ddev,pMatWorld,pMatView,fW,fH,dwU,dwV,dwW,dwH,texNo);
		LeaveCriticalSection(&pTex->m_csRender);
	}else{
		CBillboard::Render(lpd3ddev,pMatWorld,pMatView,fW,fH,texNo);
	}
}
void	CJITBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, int texNo){
	if (texNo >= 0 && texNo < (INT)m_dwNumTextures){
		JIT_TEXTURE	*pTex = &m_pJITTextures[texNo];
		EnterCriticalSection(&pTex->m_csRender);
		CBillboard::Render(lpd3ddev,x,y,w,h,texNo);
		LeaveCriticalSection(&pTex->m_csRender);
	}else{
		CBillboard::Render(lpd3ddev,x,y,w,h,texNo);
	}
}
void	CJITBillboard::Render(LPDIRECT3DDEVICE9 lpd3ddev,FLOAT x, FLOAT y, FLOAT w, FLOAT h, DWORD dwU, DWORD dwV, DWORD dwW, DWORD dwH, int texNo){
	if (texNo >= 0 && texNo < (INT)m_dwNumTextures){
		JIT_TEXTURE	*pTex = &m_pJITTextures[texNo];
		EnterCriticalSection(&pTex->m_csRender);
		CBillboard::Render(lpd3ddev,x,y,w,h,dwU,dwV,dwW,dwH,texNo);
		LeaveCriticalSection(&pTex->m_csRender);
	}else{
		CBillboard::Render(lpd3ddev,x,y,w,h,dwU,dwV,dwW,dwH,texNo);
	}
}
