;------------------------------------------------------------------------------
;eNX`\tp_VF[_
;
;    VF[_萔
;    c0      = ( 0, 0, 0, 0 )
;    c1      = ( 1, 2, 4, 8 )
;    c2      = (0.5, 0.25, 0.125, 0.0625)
;    c4-c7   = matWorldViewProjection
;    c8-c11  = matWorldView
;    c16     = matWorld
;    c20     = light direction
;    c21     = material diffuse color * light diffuse color
;    c22     = material ambient color
;    c23     = fog factor(start, end, 1/(end-start),0)
;    c24     = matWorldViewProjection (ep)
;
; Vertex components 
;    v0    = Position
;    v1    = Face Normal
;    v2    = Normal
;    v3    = Texcoords
;------------------------------------------------------------------------------
vs.1.1
dcl_position    v0  //  W
dcl_normal      v1  //  @xNg
dcl_texcoord0   v2  //  eNX`W

def c0, 0, 0, 0, 0
def c1, 1, 2, 4, 8
def c2, 0.5, -0.5, 0.25, -0.25

;------------------------------------------------------------------------------
; Vertex transformation
;------------------------------------------------------------------------------

; Transform position to the clipping space
m4x4 oPos, v0, c4

; Transform position to the camera space
m4x4 r2, v0, c8

; Transform position to the shadow clipping space
m4x4 r3, v0, c24

;------------------------------------------------------------------------------
; Lighting calculation
;------------------------------------------------------------------------------

; @xNg̃gXtH[
m3x3    r0, v1, c16

; ƌvZ
dp3 r1.x, r0, c20      ; r1 = normal dot light
max r1.x, r1.x, c0.x   ; if dot < 0 then dot = 0
mul r0, r1.x, c21      ; fBt[YJ[Z
add r0, r0, c22        ; ArGgZ
mov r0.w, c1.x         ; sx̎Zo
min oD0, r0, c1.x      ; clamp if > 1

;------------------------------------------------------------------------------
; Texture coordinates
;------------------------------------------------------------------------------
mul r3.xy, c2.xy, r3.xy
add r3.xy, r3.xy, c2.xx

min	r3.z, r3.z, c1.x	; if z > 1.0 then z = 1.0
mov oT0.xyz, r3.xyz
mov oT1.xy, v2         ; Just copy texcoords

;------------------------------------------------------------------------------
; Fog calculation
;------------------------------------------------------------------------------

; compute fog factor f = (fog_end - dist)*(1/(fog_end-fog_start))
add r0.x, -r2.z, c23.y
mul r0.x, r0.x, c23.z
max r0.x, r0.x, c0.x       ; clamp fog to > 0.0
min oFog, r0.x, c1.x       ; clamp fog to < 1.0
