// Tuto27.cpp : D3DQuickLib ł̃fvXVhE̎
//
#include "stdafx.h"
#include "Tuto27.h"
#include "stdafx.h"
#include <crtdbg.h>
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "DepthShadowSystem.h"
#include "DShadowSkinMesh.h"
#include "DShadowLandForm.h"
#include "DShadowSurface.h"

CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

//	fvXVhEVXe
CDepthShadowSystem	*g_pDShadowSystem = NULL;

//	fvXVhEbV
CDShadowSkinMesh	*g_pMesh = NULL;

//	fvXVhEeΏۂ̒n`
CDShadowLandform	*g_pLand = NULL;

//	fvX_OΏۂ̃T[tFCX
CDShadowSurface		*g_pSurface = NULL;

//	eXgpr{[h
CBillboard *g_pBillboard = NULL;

//	ep View  Projection
D3DXMATRIX	g_matRayView;
D3DXMATRIX	g_matRayProj;

//	Aj[Vpϐ
float	g_fTime = 0;
float	g_fAngle = 0;
void RenderScenePass1(LPDIRECT3DDEVICE9 lpd3ddev,LPVOID pVoid);
void RenderScenePass2(LPDIRECT3DDEVICE9 lpd3ddev);

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
	//	epJEvWFNVݒ
	LPD3DXMATRIX	pView,pProj;
	pView = g_pD3DEnv->GetSystemView();
	pProj = g_pD3DEnv->GetSystemProjection();
	D3DXMatrixOrthoLH(pProj,5.0f,5.0f,2.5f,50.0f);
    g_fAngle += 0.01f*timeElapsed;
	g_fAngle -= (D3DX_PI*2)*((int)(g_fAngle / (D3DX_PI*2)));
    D3DXMATRIX    matTmp;
    D3DXVECTOR3    vecDir = D3DXVECTOR3(4.0f*cosf(g_fAngle), 2.5f, 4.0f*sinf(g_fAngle));
    D3DXVECTOR3    vecUp = D3DXVECTOR3(0.0f,1.0f,0.0f);
    D3DXVECTOR3    vecAt = D3DXVECTOR3(0.0f,0.0f,0.0f);
    D3DXMatrixLookAtLH(pView,&vecDir,&vecAt,&vecUp);

	//	ep̃Jݒۑ
	//	Pass2 _OɕKv
	g_matRayProj = *pProj;
	g_matRayView = *pView;

	D3DXMATRIX	matWorld;
	D3DXMatrixIdentity(&matWorld);
	D3DXMatrixRotationY(&matWorld,D3DX_PI);
	g_pMesh->FrameMove(&matWorld,g_pD3DEnv->GetSystemView(),timeElapsed*(1.0f/1800.0f));
	g_pMesh->SetLightEnable(0,FALSE);

	LPDIRECT3DSURFACE9 pSurface = NULL;
	if (g_pSurface != NULL){
		pSurface = g_pSurface->GetSurface();
		if (pSurface){
			g_pD3DEnv->RenderSceneIntoSurface(pSurface,D3DCOLOR_XRGB(255,255,255),RenderScenePass1,NULL);
			pSurface->Release();
		}
	}

	D3DLIGHT9 *pLight = g_pD3DEnv->GetSystemLight();
    vecDir = -vecDir;
    D3DXVec3Normalize(&vecDir,&vecDir);
    pLight->Direction = vecDir;

	g_fTime += timeElapsed;
	if (g_fTime > 600.0f)
		g_fTime -= 600.0f;

	//	Jʒu̐ݒ
    D3DXMatrixLookAtLH(pView,&D3DXVECTOR3(-5.0f,8.0f,-5.0f),            //    J̈ʒu
                             &D3DXVECTOR3( 1.0f, 0, 1.0f ),			//    Jʒu
                             &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );    //    J̏
	D3DXMatrixPerspectiveFovLH(pProj,D3DX_PI/4.0f,4.0f/3.0f,1.0f,100.0f);
	g_pMesh->AdjustAnimation(&matWorld,pView);
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
struct BORDERVERTEX{
    FLOAT		x, y, z;
	FLOAT		rhw;
	D3DCOLOR	diffuse;
};
#define    BORDERVERTEXFVF    (D3DFVF_XYZRHW | D3DFVF_DIFFUSE)
void RenderScenePass1(LPDIRECT3DDEVICE9 lpd3ddev,LPVOID pVoid)
{
	D3DMATERIAL9	material;
	ZeroMemory(&material,sizeof(material));
	material.Diffuse.r = 0.5f;
	material.Diffuse.g = 0.5f;
	material.Diffuse.b = 0.5f;
	material.Diffuse.a = 1.0f;
	g_pMesh->SetBlendMode(MESH_SEMI_TRANS);
	g_pMesh->SetOpacity(1.0f);
	g_pMesh->RenderPass1(lpd3ddev);

	//	fvXeNX`̎lӂNA
	//	wxƂ CLAMP ĎgpׁB
	static BORDERVERTEX vertex2[]={
		{  0.0f,  0.0f,  1.0f,1.0f,D3DCOLOR_XRGB(255,255,255)},
		{255.1f,  0.0f,  1.0f,1.0f,D3DCOLOR_XRGB(255,255,255)},
		{255.1f,255.1f,  1.0f,1.0f,D3DCOLOR_XRGB(255,255,255)},
		{  0.0f,255.1f,  1.0f,1.0f,D3DCOLOR_XRGB(255,255,255)}
	};
	lpd3ddev->SetPixelShader(NULL);
	lpd3ddev->SetVertexShader(NULL);
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,FALSE);
	lpd3ddev->SetFVF(BORDERVERTEXFVF);
	lpd3ddev->DrawPrimitiveUP(D3DPT_LINESTRIP,4,vertex2,sizeof(BORDERVERTEX));
	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScenePass2(LPDIRECT3DDEVICE9 lpd3ddev)
{
	D3DXMATRIX	matWorld;
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	g_pMesh->SetLightEnable(0,TRUE);
	g_pMesh->Render(lpd3ddev);
	D3DXMatrixIdentity(&matWorld);
	lpd3ddev->SetTransform( D3DTS_WORLD, &matWorld );
	
	g_pLand->SetWorldMatrix(&matWorld);
	g_pLand->Render(lpd3ddev,&g_matRayView,&g_matRayProj);
	D3DXMATRIX	matTrans;
	::D3DXMatrixRotationZ(&matWorld,D3DX_PI*0.5f);
	D3DXMatrixRotationY(&matTrans,-D3DX_PI*0.5f);
	matWorld *= matTrans;

	D3DXMatrixTranslation(&matTrans,2.0f,0.0f,2.0f);
	matWorld *= matTrans;

	g_pLand->SetWorldMatrix(&matWorld);
	g_pLand->Render(lpd3ddev,&g_matRayView,&g_matRayProj);

	LPDIRECT3DTEXTURE9	pTex = NULL;
	if (g_pSurface !=NULL){
		pTex = g_pSurface->GetTexture();
		if (pTex != NULL){
			if (g_pBillboard != NULL){
				if (GetAsyncKeyState(VK_SPACE)){
					g_pBillboard->Render(lpd3ddev,0,0,256.0f,256.0f,0,0,256,256,pTex);
				}
			}
			pTex->Release();
		}
	}
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    _CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "D3DQuickLibSample";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto27",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );
    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	g_pD3DEnv = new CD3DEnv();
	if (SUCCEEDED(g_pD3DEnv->InitD3D(hWnd))){
		//	OtBbNX̓ǂݍ
		g_pDShadowSystem = new CDepthShadowSystem(g_pD3DEnv);
		g_pMesh = new CDShadowSkinMesh(g_pD3DEnv,"hito\\walk.x");
		g_pLand = new CDShadowLandform(g_pD3DEnv,"ground\\ground.x");
		g_pBillboard = new CBillboard(g_pD3DEnv,0);
		g_pSurface = (CDShadowSurface*)g_pD3DEnv->GetContainer(__uuidof(CLSID_DShadowSurface));

		//	foCXփOtBbNXf[^]
		g_pD3DEnv->ReloadGraphics();
	}else
		DestroyWindow(hWnd);
    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene(FrameMove,RenderScenePass2);
        }
    }
	SAFE_RELEASE(g_pSurface);

	SAFE_DELETE(g_pBillboard);
	SAFE_DELETE(g_pLand);
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pDShadowSystem);
	SAFE_DELETE(g_pD3DEnv);
    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            if (SIZE_MAXIMIZED == wParam){
				g_pD3DEnv->ForceFullscreen();
			}
            break;
        case    WM_SETCURSOR:
			if (g_pD3DEnv->IsWindowed())
				::SetCursor(::LoadCursor(NULL,IDC_ARROW));
			else
				::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
			if (!g_pD3DEnv->IsWindowed()){	//	tXN[
				if (wParam != SC_CLOSE)
					break;

				//	WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
				Sleep(100);
			}
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
