#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\dshadowsurface.h"

CDShadowSurface::CDShadowSurface(CD3DEnv *pEnv, GUID guid) : CContainer(pEnv, guid)
{
	m_pEnv = pEnv;
	m_pTexture = NULL;
	//	AddGraphicsObject ͐eNXŎς
}

CDShadowSurface::~CDShadowSurface(void)
{
	SAFE_RELEASE(m_pTexture);
	//	RemoveGraphicsObject ͐eNXŎς
}

HRESULT	CDShadowSurface::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pTexture != NULL)
		return	S_OK;
    HRESULT    hr;
	D3DDEVTYPE	dt;
	D3DFORMAT	fmt;
	dt = m_pEnv->GetDeviceType();

	//	T[tFCXtH[}bg
	static D3DFORMAT fmtCandidate[]={
		D3DFMT_R32F,
		D3DFMT_R16F,
		D3DFMT_L16,
		D3DFMT_A2R10G10B10,
		D3DFMT_R8G8B8,
		D3DFMT_A8R8G8B8
	};
	//	p\ȃT[tFCXtH[}bg̃`FbN
	int	i;
	for (i = 0; i < (sizeof(fmtCandidate)/sizeof(D3DFORMAT)) ; ++i){
		fmt = fmtCandidate[i];
		hr = m_pEnv->SystemD3D()->CheckDeviceFormat(0,dt,m_pEnv->GetBackBufferFormat(),
			D3DUSAGE_RENDERTARGET,D3DRTYPE_SURFACE,fmt);
		if (SUCCEEDED(hr))
			break;
	}
	if (FAILED(hr))
		return	E_FAIL;

	//	eNX`
	hr = D3DXCreateTexture(lpd3ddev,256,256,1,D3DUSAGE_RENDERTARGET,
		fmt,D3DPOOL_DEFAULT,&m_pTexture);
	if (FAILED(hr)){
		m_pTexture = NULL;
		return	E_FAIL;
	}
	return	S_OK;
}

HRESULT	CDShadowSurface::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pTexture);
	return	S_OK;
}

LPDIRECT3DTEXTURE9	CDShadowSurface::GetTexture(){
	if (m_pTexture == NULL)
		return	NULL;
	m_pTexture->AddRef();
	return	m_pTexture;
}

LPDIRECT3DSURFACE9	CDShadowSurface::GetSurface(){
	if (m_pTexture == NULL)
		return	NULL;
	LPDIRECT3DSURFACE9	pSurface;
	if (FAILED(m_pTexture->GetSurfaceLevel(0,&pSurface)))
		return	NULL;
	return	pSurface;
}
