#include "StdAfx.h"
#include <d3dx9.h>
#include <dxfile.h>
#include <tchar.h>
#include <crtdbg.h>
#include "D3DQuickLib.h"
#include "DShadowSkinMesh.h"
#include "DepthShadowSystem.h"

CDShadowSkinMesh::CDShadowSkinMesh(CD3DEnv *pEnv, TCHAR *pFilename)
: CSkinnedMesh(pEnv,pFilename)
{
	m_pDSShaders[0] = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowSkin1Pass1VS));
	m_pDSShaders[1] = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowSkin2Pass1VS));
	m_pDSShaders[2] = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowSkin3Pass1VS));
	m_pDSShaders[3] = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowSkin4Pass1VS));
	m_pDSPass1PixelShader = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowPass1PS));
	m_bPass1 = false;
}

CDShadowSkinMesh::~CDShadowSkinMesh(void)
{
	int	i;
	for (i = 0; i < 4 ; ++i){
		SAFE_RELEASE(m_pDSShaders[i]);
	}
	SAFE_RELEASE(m_pDSPass1PixelShader);
}

//-----------------------------------------------------------------------------
// Name: RenderMeshContainer()
// Desc: qGL[̃bVRei`悷B
//-----------------------------------------------------------------------------
void CDShadowSkinMesh::RenderMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase)
{
	if (!m_bPass1){
		CSkinnedMesh::RenderMeshContainer(pMeshContainerBase,pFrameBase);
		return;
	}
    CSkinnedMeshContainer *pMeshContainer = (CSkinnedMeshContainer*)pMeshContainerBase;
    SKINNEDMESH_FRAME *pFrame = (SKINNEDMESH_FRAME*)pFrameBase;
    UINT iMaterial;
    UINT iAttrib;
    LPD3DXBONECOMBINATION pBoneComb;
	LPDIRECT3DDEVICE9	lpd3ddev;

	UINT iMatrixIndex;
    UINT iPaletteEntry;
    D3DXMATRIXA16 matTemp;
	HRESULT	hr;

	lpd3ddev = m_lpD3DDeviceTmp;

	//  sNZVF[_ݒ
	if (m_pDSPass1PixelShader)
		lpd3ddev->SetPixelShader(m_pDSPass1PixelShader->GetDXPixelShader());

	if (pMeshContainer->pSkinInfo != NULL)
    {

        if (pMeshContainer->UseSoftwareVP)
        {
            lpd3ddev->SetSoftwareVertexProcessing(TRUE);
        }
		hr = lpd3ddev->SetVertexShader(m_pDSShaders[pMeshContainer->NumMatrixReference -1]->GetDXVertexShader());
		if (FAILED(hr)){
			_RPT0(_CRT_WARN,"SetVertexShader FAILED\n");
		}
        pBoneComb = reinterpret_cast<LPD3DXBONECOMBINATION>(pMeshContainer->pBoneCombinationBuf->GetBufferPointer());
        for (iAttrib = 0; iAttrib < pMeshContainer->NumAttributes; iAttrib++)
        {
            //	[h}gbNXvZ
            for (iPaletteEntry = 0; iPaletteEntry < pMeshContainer->NumPaletteEntries; ++iPaletteEntry)
            {
                iMatrixIndex = pBoneComb[iAttrib].BoneId[iPaletteEntry];
                if (iMatrixIndex != UINT_MAX)
                {
					//	_W͈U{[ԂɈړĂA{[sɂ胏[hԂɎˉeAŌɃr[sŎˉeB
                    
					matTemp = pMeshContainer->pBoneOffsetMatrices[iMatrixIndex] * (*pMeshContainer->ppBoneMatrixPtrs[iMatrixIndex]);
					D3DXMatrixMultiplyTranspose(&matTemp, &matTemp, &m_matView);
                    lpd3ddev->SetVertexShaderConstantF(iPaletteEntry*3 + 9, (float*)&matTemp, 3);
                }
            }

            //	ArGgƎȔƂB
            pMeshContainer->MeshData.pMesh->DrawSubset( iAttrib );
            
        }

        //	\tgEFA_ɐݒ肵Ăꍇ͖߂B
        if (pMeshContainer->UseSoftwareVP)
        {
            lpd3ddev->SetSoftwareVertexProcessing(FALSE);
        }
        lpd3ddev->SetVertexShader(NULL);

    }
    else  //	XLjO񂪖ꍇ͂B
    {
        lpd3ddev->SetTransform(D3DTS_WORLD, &pFrame->CombinedTransformationMatrix);
		hr = lpd3ddev->SetVertexShader(NULL);

        for (iMaterial = 0; iMaterial < pMeshContainer->NumMaterials; iMaterial++)
        {
            pMeshContainer->MeshData.pMesh->DrawSubset(iMaterial);
        }
    }
	lpd3ddev->SetPixelShader(NULL);
}

//-----------------------------------------------------------------------------
// Name: RenderPass1()
// Desc: Pass1 `EEEfvXVhEp̕`
//-----------------------------------------------------------------------------
void	CDShadowSkinMesh::RenderPass1(LPDIRECT3DDEVICE9 lpd3ddev){

	if (m_pFrameRoot == NULL)
		return;

	//	eNX`Xe[WXe[g̐ݒ
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

    lpd3ddev->SetTextureStageState(1, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(1, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(1, D3DTSS_COLORARG2, D3DTA_CURRENT);
    lpd3ddev->SetTextureStageState(1, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(1, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(1, D3DTSS_ALPHAARG2, D3DTA_CURRENT);

	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSU,D3DTADDRESS_CLAMP);
	lpd3ddev->SetSamplerState( 0, D3DSAMP_ADDRESSV,D3DTADDRESS_CLAMP);
	lpd3ddev->SetSamplerState( 1, D3DSAMP_ADDRESSU,D3DTADDRESS_WRAP);
	lpd3ddev->SetSamplerState( 1, D3DSAMP_ADDRESSV,D3DTADDRESS_WRAP);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}
    //	Geforce3  UBYTE4 T|[gȂׁAUBYTE4 ̑ COLOR gpB
    //	vConst.w ͈ӖƂĂ͂Rł邪ACOLOR ɕϊꂽl(255 -> 1.0)
	//	ɍ킹āA255*3ŕ\ĂB
    D3DXVECTOR4 vConst( 1.0f, -1.0f, 0.0f, 765.01f );
	lpd3ddev->SetVertexShaderConstantF(0, (float*)&vConst, 1);

	//	vWFNV}gbNX̏
	D3DXMATRIXA16 matProj;
	D3DXMatrixTranspose(&matProj, m_lpD3DEnv->GetSystemProjection());
	lpd3ddev->SetVertexShaderConstantF(2, (float*)&matProj, 4);
	m_lpD3DDeviceTmp = lpd3ddev;
	m_bPass1 = TRUE;
    RenderFrame(m_pFrameRoot);
	m_bPass1 = FALSE;
}

