//---------------------------------------------------
//	fvXVhE𓊉e\Ȓn`pbV
//	_J[ɂ͑ΉĂȂׁAKvłΉ
//---------------------------------------------------
#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "DepthShadowSystem.h"
#include "DShadowSurface.h"
#include ".\dshadowlandform.h"

CDShadowLandform::CDShadowLandform(CD3DEnv *pEnv, TCHAR *fname)
: CMesh(pEnv,fname)
{
	//	VF[_̎擾
	m_pVS = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowPass2VS));
	m_pPS = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowPass2PS));
	m_pPSwTex1 = pEnv->GetShaderContainer(__uuidof(CLSID_DShadowPass2PSwTex1));
	m_pDShadowSurface = (CDShadowSurface*)pEnv->GetContainer(__uuidof(CLSID_DShadowSurface));
	m_fFogStart = 1.0f;	//	Disable the fog	
	m_fFogEnd   = 0.0f;
	D3DXMatrixIdentity(&m_matWorld);
}

CDShadowLandform::~CDShadowLandform(void)
{
	SAFE_RELEASE(m_pDShadowSurface);
	SAFE_RELEASE(m_pVS);
	SAFE_RELEASE(m_pPS);
	SAFE_RELEASE(m_pPSwTex1);
}

HRESULT	CDShadowLandform::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
    LPD3DXMESH pTempMesh;
	HRESULT	hr;
	if (m_pMeshSysMem != NULL){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return	S_OK;
	}
	hr = CMesh::InitDeviceObjects(lpd3ddev);
    // _tH[}bg̏CE_VF[_ɍ킹B_J[ɂ͑ΉĂȂB
    if( SUCCEEDED(hr) && m_pMeshSysMem!= NULL)
    {
        hr = m_pMeshSysMem->CloneMeshFVF( m_pMeshSysMem->GetOptions(), 
                                          (m_pMeshSysMem->GetFVF() &  D3DFVF_POSITION_MASK) | D3DFVF_NORMAL | D3DFVF_TEX1, 
                                          lpd3ddev, &pTempMesh );
		if (SUCCEEDED(hr)){
			m_pMeshSysMem->Release();
			m_pMeshSysMem = pTempMesh;
		}
    }
	return	hr;
}

void	CDShadowLandform::SetWorldMatrix(D3DXMATRIX *pMat){
	m_matWorld = *pMat;
}
void CDShadowLandform::SetFog(FLOAT fStart, FLOAT fEnd){
	m_fFogStart = fStart;
	m_fFogEnd = fEnd;
}
void	CDShadowLandform::Render(LPDIRECT3DDEVICE9 lpd3ddev, D3DXMATRIX *pMatRayView, D3DXMATRIX *pMatRayProj){
	D3DXMATRIX	*pMatView, *pMatProj;
	D3DXMATRIX	matCamera, mat;
	D3DXMATRIX	matTranspose, matCameraTranspose,matViewTranspose,matProjTranspose,matWorldTranspose;

	if (m_pMeshSysMem == NULL)
		return;
	pMatView = m_lpD3DEnv->GetSystemView();
	pMatProj = m_lpD3DEnv->GetSystemProjection();
	matCamera = m_matWorld * *pMatView;
	mat = matCamera * *pMatProj;
	D3DXMatrixTranspose(&matTranspose, &mat);
	D3DXMatrixTranspose(&matCameraTranspose, &matCamera);
	D3DXMatrixTranspose(&matViewTranspose, pMatView);
	D3DXMatrixTranspose(&matProjTranspose, pMatProj);
	D3DXMatrixTranspose(&matWorldTranspose, &m_matWorld);
    lpd3ddev->SetVertexShaderConstantF(  4, (FLOAT*)&matTranspose, 4 );
    lpd3ddev->SetVertexShaderConstantF(  8, (FLOAT*)&matCameraTranspose,  4 );
    lpd3ddev->SetVertexShaderConstantF( 12, (FLOAT*)&matViewTranspose,    4 );
    lpd3ddev->SetVertexShaderConstantF( 16, (FLOAT*)&matWorldTranspose,   4 );

	D3DXVECTOR4	vLightDir;
	//	sɑΉ
	vLightDir = (D3DXVECTOR4)*m_lpD3DEnv->GetSystemLightDirection();
	vLightDir.w = 0;
	vLightDir *= -1.0f;
    lpd3ddev->SetVertexShaderConstantF(20, (float*)&vLightDir, 1);
	//	Fog
	D3DXVECTOR4	vConst0(0,0,0,0);
	vConst0.x = m_fFogStart;
	vConst0.y = m_fFogEnd;
	vConst0.z = 1.0f / (m_fFogEnd - m_fFogStart);
    lpd3ddev->SetVertexShaderConstantF(23, (float*)&vConst0, 1);
 	mat = m_matWorld * *pMatRayView * *pMatRayProj;
	D3DXMatrixTranspose(&matTranspose,&mat);
	lpd3ddev->SetVertexShaderConstantF( 24, (FLOAT*)&matTranspose, 4);

	lpd3ddev->SetVertexShader(m_pVS->GetDXVertexShader());
	INT	i;
	LPDIRECT3DTEXTURE9	pTex;
	pTex = m_pDShadowSurface->GetTexture();
	lpd3ddev->SetTexture(0,pTex);
	SAFE_RELEASE(pTex);
	lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSU,D3DTADDRESS_CLAMP);
    lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSV,D3DTADDRESS_CLAMP);

    for (i = 0; i < (INT)m_dwNumMaterials ; ++i){
		D3DXCOLOR	color1(m_pMaterials[i].Ambient);
		D3DCOLOR	c = m_lpD3DEnv->GetAmbientColor();
		D3DXCOLOR	color2(	((c>>16)&0xff) * (1/255.0f), 
							((c>>8)&0xff) * (1/255.0f), 
							((c)&0xff) * (1/255.0f), 1.0);
        D3DXCOLOR ambEmm;
        D3DXColorModulate(&ambEmm, &color1, &color2);
        ambEmm += D3DXCOLOR(m_pMaterials[i].Emissive);
		D3DXCOLOR	diffuse;
		D3DXColorModulate(&diffuse,&D3DXCOLOR(m_pMaterials[i].Diffuse),&D3DXCOLOR(m_lpD3DEnv->GetSystemLight()->Diffuse));
		diffuse.a *= m_fOpacity;
        lpd3ddev->SetVertexShaderConstantF(21, (float*)&diffuse, 1);
        lpd3ddev->SetVertexShaderConstantF(22, (float*)&ambEmm, 1);
		lpd3ddev->SetPixelShader(NULL);
		if (m_ppTextures[i]){
			lpd3ddev->SetTexture( 1, m_ppTextures[i]->GetTexture() );
			lpd3ddev->SetPixelShader(m_pPSwTex1->GetDXPixelShader());
		}else{
			lpd3ddev->SetTexture( 1, NULL );
			lpd3ddev->SetPixelShader(m_pPS->GetDXPixelShader());
		}
		m_pMeshSysMem->DrawSubset(i);
    }
	lpd3ddev->SetTexture( 1, NULL );
    lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSU,D3DTADDRESS_WRAP);
    lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSV,D3DTADDRESS_WRAP);
	lpd3ddev->SetVertexShader(NULL);
	lpd3ddev->SetPixelShader(NULL);

}

