/*
 *		Windows ̊{IȃCxgȂǂsȂvO
 *
 */
#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Surface.h"

CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

CSurface		*g_pSurface = NULL;
CSkinnedMesh	*g_pMesh = NULL;
struct FLOORVERTEX{
    D3DXVECTOR3    p;
    D3DXVECTOR3    n;
    FLOAT        tu, tv;    //    eNX`W
};
#define    FLOORVERTEXFVF    (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1)


class	CMeshDerived : public CMesh
{
public:
	CMeshDerived(CD3DEnv *pEnv, TCHAR *pFname):CMesh(pEnv,pFname){
	}
	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
		CMesh::InitDeviceObjects(lpd3ddev);
		// _tH[}bg̏CE@ΒǉB
		LPD3DXMESH pTempMesh;
		HRESULT hr;
		if( m_pMeshSysMem ){
			hr = m_pMeshSysMem->CloneMeshFVF( m_pMeshSysMem->GetOptions(), 
											FLOORVERTEXFVF, lpd3ddev, &pTempMesh );
			if( FAILED(hr) ){
				return	hr;
			}
			D3DXComputeNormals( pTempMesh,NULL );

			m_pMeshSysMem->Release();
			m_pMeshSysMem = pTempMesh;
		}
	}
	void	CalculateTexCoord(D3DXMATRIX *pWorld, D3DXMATRIX *pView, D3DXMATRIX *pProj){
		D3DXMATRIX    matTmp = (*pWorld) * (*pView) * (*pProj);
		LPDIRECT3DVERTEXBUFFER9	pVB = NULL;
		FLOORVERTEX	*pVertex = NULL;
		DWORD	dwNumVertices = m_pMeshSysMem->GetNumVertices();
		if (SUCCEEDED(m_pMeshSysMem->GetVertexBuffer(&pVB))){
			if (SUCCEEDED(pVB->Lock(0,0,(VOID**)&pVertex,0))){
				D3DXVECTOR4    vecTmp;
				for (DWORD i = 0; i < dwNumVertices; ++i,++pVertex){
                    vecTmp = *(D3DXVECTOR4*)&pVertex->p;
                    vecTmp.w = 1.0f;
                    D3DXVec4Transform(&vecTmp,&vecTmp,&matTmp);
                    vecTmp.x /= vecTmp.w;
                    vecTmp.y /= vecTmp.w;
					pVertex->tu =(vecTmp.x+1.0f)*0.5f;
					pVertex->tv =1.0f-(vecTmp.y+1.0f)*0.5f; 
                        // ӁFeNX`W͏㉺tEEE
                }

				pVB->Unlock();
			}
			pVB->Release();
		}

	}
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev){
		lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB

		lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
		lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);
		//	Do not show shadows outside the texture.
		lpd3ddev->SetSamplerState(0,D3DSAMP_BORDERCOLOR, D3DCOLOR_XRGB(255,255,255));
        lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSU,D3DTADDRESS_BORDER);
        lpd3ddev->SetSamplerState(0,D3DSAMP_ADDRESSV,D3DTADDRESS_BORDER);

		if (m_pMeshSysMem){
			for( UINT i = 0; i < m_dwNumMaterials; i++ ){
				lpd3ddev->SetMaterial( &m_pMaterials[i] );
				lpd3ddev->SetTexture( 0, g_pSurface->GetTexture());
				m_pMeshSysMem->DrawSubset( i );
			}
		}
	}
};
CMeshDerived	*g_pLand = NULL;
float			g_fTime = 0;
float			g_fAngle = 0;
void RenderScenePass1(LPDIRECT3DDEVICE9 lpd3ddev,LPVOID pVoid);
void RenderScenePass2(LPDIRECT3DDEVICE9 lpd3ddev);

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
	LPD3DXMATRIX	pView,pProj;
	pView = g_pD3DEnv->GetSystemView();
	pProj = g_pD3DEnv->GetSystemProjection();
    D3DXMatrixOrthoLH(pProj,5.0f,5.0f,1.0f,100.0f);

    g_fAngle += 0.01f*timeElapsed;
	g_fAngle -= (D3DX_PI*2)*((int)(g_fAngle / (D3DX_PI*2)));
    D3DXMATRIX    matTmp;
    D3DXVECTOR3    vecDir = D3DXVECTOR3(4.0f*cosf(g_fAngle), 2.5f, 4.0f*sinf(g_fAngle));
    D3DXVECTOR3    vecUp = D3DXVECTOR3(0.0f,1.0f,0.0f);
    D3DXVECTOR3    vecAt = D3DXVECTOR3(0.0f,0.0f,0.0f);
    D3DXMatrixLookAtLH(pView,&vecDir,&vecAt,&vecUp);

	D3DXMATRIX	matWorld;
	D3DXMatrixIdentity(&matWorld);
	g_pLand->CalculateTexCoord(&matWorld,pView,pProj);
	D3DXMatrixRotationY(&matWorld,D3DX_PI);
	g_pMesh->FrameMove(&matWorld,g_pD3DEnv->GetSystemView(),timeElapsed*(1.0f/1800.0f));
	g_pMesh->SetLightEnable(0,FALSE);
	LPDIRECT3DSURFACE9 pSurface = NULL;
	pSurface = g_pSurface->GetSurface();
	if (pSurface){
		g_pD3DEnv->RenderSceneIntoSurface(pSurface,D3DCOLOR_XRGB(255,255,255),RenderScenePass1,NULL);
		pSurface->Release();
	}
	D3DLIGHT9 *pLight = g_pD3DEnv->GetSystemLight();
    vecDir = -vecDir;
    D3DXVec3Normalize(&vecDir,&vecDir);
    pLight->Direction = vecDir;


	g_fTime += timeElapsed;
	if (g_fTime > 600.0f)
		g_fTime -= 600.0f;

	//	Jʒu̐ݒ
    D3DXMatrixLookAtLH(pView,&D3DXVECTOR3(-5.0f,8.0f,-5.0f),            //    J̈ʒu
                             &D3DXVECTOR3( 1.0f, 0, 1.0f ),			//    Jʒu
                             &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );    //    J̏
	D3DXMatrixPerspectiveFovLH(pProj,D3DX_PI/4.0f,4.0f/3.0f,1.0f,100.0f);
	g_pMesh->AdjustAnimation(&matWorld,pView);
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScenePass1(LPDIRECT3DDEVICE9 lpd3ddev,LPVOID pVoid)
{
	D3DMATERIAL9	material;
	ZeroMemory(&material,sizeof(material));
	material.Diffuse.r = 0.5f;
	material.Diffuse.g = 0.5f;
	material.Diffuse.b = 0.5f;
	material.Diffuse.a = 1.0f;
	g_pMesh->SetBlendMode(MESH_SEMI_TRANS);
	g_pMesh->SetOpacity(1.0f);
	g_pMesh->RenderWithoutMaterials(lpd3ddev,&material);
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScenePass2(LPDIRECT3DDEVICE9 lpd3ddev)
{
	D3DXMATRIX	matWorld;
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	g_pMesh->SetLightEnable(0,TRUE);
	g_pMesh->Render(lpd3ddev);
	D3DXMatrixIdentity(&matWorld);
	lpd3ddev->SetTransform( D3DTS_WORLD, &matWorld );
	g_pLand->Render(lpd3ddev);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "D3DQuickLibSample";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto04",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );
    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	g_pD3DEnv = new CD3DEnv();
	if (SUCCEEDED(g_pD3DEnv->InitD3D(hWnd))){
		//	OtBbNX̓ǂݍ
		g_pMesh = new CSkinnedMesh(g_pD3DEnv,"hito\\walk.x");
		g_pLand = new CMeshDerived(g_pD3DEnv,"floor.x");
		g_pSurface = new CSurface(g_pD3DEnv);
		//	foCXփOtBbNXf[^]
		g_pD3DEnv->ReloadGraphics();
	}else
		DestroyWindow(hWnd);
    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene(FrameMove,RenderScenePass2);
        }
    }
	SAFE_DELETE(g_pSurface);
	SAFE_DELETE(g_pLand);
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pD3DEnv);
    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            if (SIZE_MAXIMIZED == wParam){
				g_pD3DEnv->ForceFullscreen();
			}
            break;
        case    WM_SETCURSOR:
			if (g_pD3DEnv->IsWindowed())
				::SetCursor(::LoadCursor(NULL,IDC_ARROW));
			else
				::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
			if (!g_pD3DEnv->IsWindowed()){	//	tXN[
				if (wParam != SC_CLOSE)
					break;

				//	WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
				Sleep(100);
			}
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
