#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\surface.h"

CSurface::CSurface(CD3DEnv *pEnv)
{
	m_pEnv = pEnv;
	m_pTexture = NULL;
	m_pEnv->AddGraphicsObject(this);
}

CSurface::~CSurface(void)
{
	SAFE_RELEASE(m_pTexture);
	m_pEnv->RemoveGraphicsObject(this);
}

HRESULT	CSurface::RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pTexture != NULL)
		return	S_OK;
    HRESULT    hr;
	D3DDEVTYPE	dt;
	D3DFORMAT	fmt;
	dt = m_pEnv->GetDeviceType();
	fmt = m_pEnv->GetBackBufferFormat();
    hr = m_pEnv->SystemD3D()->CheckDeviceFormat(0,dt,fmt,
        D3DUSAGE_RENDERTARGET,D3DRTYPE_SURFACE,fmt);

	if (FAILED(hr))
		return	E_FAIL;

	hr = D3DXCreateTexture(lpd3ddev,256,256,1,D3DUSAGE_RENDERTARGET,
		fmt,D3DPOOL_DEFAULT,&m_pTexture);
	if (FAILED(hr)){
		m_pTexture = NULL;
		return	E_FAIL;
	}
	return	S_OK;
}

HRESULT	CSurface::InvalidateDeviceObjects(){
	SAFE_RELEASE(m_pTexture);
	return	S_OK;
}

LPDIRECT3DTEXTURE9	CSurface::GetTexture(){
	if (m_pTexture == NULL)
		return	NULL;
	m_pTexture->AddRef();
	return	m_pTexture;
}

LPDIRECT3DSURFACE9	CSurface::GetSurface(){
	if (m_pTexture == NULL)
		return	NULL;
	LPDIRECT3DSURFACE9	pSurface;
	if (FAILED(m_pTexture->GetSurfaceLevel(0,&pSurface)))
		return	NULL;
	return	pSurface;
}
