#include "stdafx.h"

#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Surface.h"
CD3DEnv	*g_pD3DEnv = NULL; // D3DQuickLib 񋟂`B
CEnhancedMesh *g_pMesh = NULL; // D3DQuickLib ɂ郂fONXB
CSurface	*g_pSurface = NULL;	//	_OpT[tFX
CBillboard	*g_pBillboard = NULL;	//	r{[h
float   g_fTime = 0;       // Aj[VŎgp

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
void RenderSceneIntoSurface(LPDIRECT3DDEVICE9 lpd3ddev,VOID *lpUser);

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐ R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
    g_fTime += timeElapsed;
    if (g_fTime > 600.0f)
        g_fTime -= 600.0f;
	LPDIRECT3DSURFACE9	pSurface = g_pSurface->GetSurface();
	if (pSurface){
		g_pD3DEnv->RenderSceneIntoSurface(pSurface,D3DCOLOR_XRGB(255,255,255),RenderSceneIntoSurface,NULL);
		pSurface->Release();
	}
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐ R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
	LPDIRECT3DTEXTURE9	pTex = g_pSurface->GetTexture();
	g_pBillboard->Render(lpd3ddev,220,140,200,200,0,0,256,256,pTex);
	SAFE_RELEASE(pTex);
}

//------------------------------------------------------------
// Name: RenderSceneIntoSurface
// Desc: _OsB
//		UpdateScene ֐ R[obNB
//------------------------------------------------------------
void RenderSceneIntoSurface(LPDIRECT3DDEVICE9 lpd3ddev,VOID *lpUser)
{
	D3DXMATRIX	matProj,matView,matWorld;
	D3DXMatrixPerspectiveFovLH(&matProj,D3DX_PI/4.0f,1.0f,1.0f,100.0f);
    D3DXMatrixLookAtLH(&matView,&D3DXVECTOR3(0,0.0f,-6.0f),&D3DXVECTOR3(0,0,0),&D3DXVECTOR3(0,1.0f,0));
    lpd3ddev->SetTransform(D3DTS_PROJECTION,&matProj);
    lpd3ddev->SetTransform(D3DTS_VIEW,&matView);

	D3DXMatrixRotationY(&matWorld,(D3DX_PI /60.0f)* g_fTime);
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );
    lpd3ddev->SetTransform( D3DTS_WORLD, &matWorld );
    g_pMesh->Render(lpd3ddev);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "Game";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Game",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    //    D3DQuickLib ̏
    g_pD3DEnv = new CD3DEnv();
    if (FAILED(g_pD3DEnv->InitD3D(hWnd))){
        DestroyWindow(hWnd);
    }else{
        g_pMesh = new CEnhancedMesh(g_pD3DEnv,"smile\\smile.x");
		g_pSurface = new CSurface(g_pD3DEnv);
		g_pBillboard = new CBillboard(g_pD3DEnv,0);
        g_pD3DEnv->ReloadGraphics();
    }

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
            g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
    //    D3DQuickLib ̏I
	SAFE_DELETE(g_pBillboard);
	SAFE_DELETE(g_pSurface);
    SAFE_DELETE(g_pMesh);
    SAFE_DELETE(g_pD3DEnv);
    
    return msg.wParam;
}


LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            //    EChEő剻ꂽAtXN[[hɂB
            if (SIZE_MAXIMIZED == wParam){
                if (g_pD3DEnv->IsWindowed())
                    g_pD3DEnv->ToggleFullscreen();
            }
            break;
        case    WM_SETCURSOR:
            //    tXN[̓J[\\ȂB
            if (g_pD3DEnv->IsWindowed())
                ::SetCursor(::LoadCursor(NULL,IDC_ARROW));
            else
                ::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            //    Alt-Enter ŃtXN[[h֐؂ւ
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
            if (!g_pD3DEnv->IsWindowed()){    //    tXN[
                if (wParam != SC_CLOSE)
                    break;

                //    WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
                Sleep(100);
            }
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}

