/*
 *	class CSkinnedMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#ifndef	__SKINNEDMESH_H__
#define	__SKINNEDMESH_H__

#ifndef __MESH_H__
#include "Mesh.h"
#endif

#define	SKINNEDMESH_IS_UNINITIALIZED	0
#define	SKINNEDMESH_IS_INITIALIZED		1
#define	SKINNEDMESH_IS_RESTORED		2
class CSkinnedMesh;
class CSkinMeshFrameTracker;
class CContainer;
//-----------------------------------------------------------------------------
// Name: struct SKINNEDMESH_FRAME
// Desc: D3DXFRAME ̔h\́Aet[gXtH[[V
//		sێł悤ɂĂB
//-----------------------------------------------------------------------------
struct SKINNEDMESH_FRAME: public D3DXFRAME
{
    D3DXMATRIXA16       CombinedTransformationMatrix;
	D3DXMATRIXA16		BackupMatrix;
};


//-----------------------------------------------------------------------------
// Name: struct CSkinnedMeshContainer
// Desc: D3DXMESHCONTAINER ̔hNXB
//-----------------------------------------------------------------------------
class	CTextureNode;
struct CSkinnedMeshContainer: public D3DXMESHCONTAINER
{
    CTextureNode**		 ppTextures;         
    LPD3DXMESH           pOrigMesh;
    LPD3DXATTRIBUTERANGE pAttributeTable;
    DWORD                NumAttributes;
    DWORD                NumMatrixReference;
    LPD3DXBUFFER         pBoneCombinationBuf;
    LPD3DXMATRIX*        ppBoneMatrixPtrs;
    LPD3DXMATRIX         pBoneOffsetMatrices;
    DWORD                NumPaletteEntries;
    bool                 UseSoftwareVP;
};

//-----------------------------------------------------------------------------
// Name: class CAllocateHierarchy
// Desc: ID3DXAllocateHierarchy ̊gNX
//-----------------------------------------------------------------------------
#if	D3DX_VERSION < 0x0902
class CAllocateHierarchy: public ID3DXAllocateHierarchy
{
public:
    STDMETHOD(CreateFrame)(THIS_ LPCTSTR Name, LPD3DXFRAME *ppNewFrame);
    STDMETHOD(CreateMeshContainer)(THIS_ LPCTSTR Name, LPD3DXMESHDATA pMeshData,
                            LPD3DXMATERIAL pMaterials, LPD3DXEFFECTINSTANCE pEffectInstances, DWORD NumMaterials, 
                            DWORD *pAdjacency, LPD3DXSKININFO pSkinInfo, 
                            LPD3DXMESHCONTAINER *ppNewMeshContainer);
    STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerBase);
    CAllocateHierarchy(CSkinnedMesh *p){	m_pParent = p;	}
private:
	CSkinnedMesh	*m_pParent;
};
#else
class CAllocateHierarchy: public ID3DXAllocateHierarchy
{
public:
    STDMETHOD(CreateFrame)(THIS_ LPCTSTR Name, LPD3DXFRAME *ppNewFrame);
    STDMETHOD(CreateMeshContainer)(THIS_ LPCSTR Name,
		CONST D3DXMESHDATA *pMeshData,
		CONST D3DXMATERIAL *pMaterials,
		CONST D3DXEFFECTINSTANCE *pEffectInstances,
		DWORD NumMaterials,
		CONST DWORD *pAdjacency,
		LPD3DXSKININFO pSkinInfo,
		LPD3DXMESHCONTAINER *ppNewMeshContainer);

    STDMETHOD(DestroyFrame)(THIS_ LPD3DXFRAME pFrameToFree);
    STDMETHOD(DestroyMeshContainer)(THIS_ LPD3DXMESHCONTAINER pMeshContainerBase);
    CAllocateHierarchy(CSkinnedMesh *p){	m_pParent = p;	}
private:
	CSkinnedMesh	*m_pParent;
};
#endif

class CSkinnedMesh : public CMesh
{
	friend	class	CAllocateHierarchy;
	friend	class	CSkinMeshFrameTracker;
public:
	CSkinnedMesh(CD3DEnv *pEnv, TCHAR *fname);
	virtual ~CSkinnedMesh();
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);

	virtual HRESULT	FrameMove(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView, FLOAT fElapsedTime);
	virtual HRESULT AdjustAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView);
	virtual HRESULT	ResetAnimation(D3DXMATRIX *pMatWorld, D3DXMATRIX *pMatView);
	virtual HRESULT	GetAnimationController(LPD3DXANIMATIONCONTROLLER *p);
	virtual void	SetFog(FLOAT fStart, FLOAT fEnd);
	virtual void	ResetAnimationMatrices();
	virtual	void	RenderBones(LPDIRECT3DDEVICE9 lpd3ddev);

protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();

	virtual	void	ResetFrameMatrices(LPD3DXFRAME pFrameBase);
	virtual	void	UpdateFrameMatrices(LPD3DXFRAME pFrameBase, LPD3DXMATRIX pParentMatrix);
	virtual	void	RenderFrame(LPD3DXFRAME pFrame);
	virtual	void	RenderMeshContainer(LPD3DXMESHCONTAINER pMeshContainerBase, LPD3DXFRAME pFrameBase);
	virtual	HRESULT	GenerateSkinnedMesh(CSkinnedMeshContainer *pMeshContainer);
	virtual	HRESULT SetupBoneMatrixPointersOnMesh( LPD3DXMESHCONTAINER pMeshContainer );
    virtual	HRESULT SetupBoneMatrixPointers( LPD3DXFRAME pFrame );
	virtual	HRESULT	AddAnimation(TCHAR *fname);	//	
	virtual	void	RenderBone(LPD3DXFRAME pFrame,LPD3DXMATRIX pParentMatrix);

	DWORD						m_dwPrimalTextureStage;
	CShaderContainer			*m_pShaders[4];
	LPDIRECT3DDEVICE9			m_lpD3DDeviceTmp;
    LPD3DXFRAME                 m_pFrameRoot;
    LPD3DXANIMATIONCONTROLLER   m_pAnimController;

    D3DXMATRIXA16               m_matView;
    D3DXMATRIXA16               m_matWorld;

	FLOAT	m_fFogStart;
	FLOAT	m_fFogEnd;
};

extern void	InitSkinnedMeshSystem();
extern void	InitSkinnedMeshGraphics(LPDIRECT3DDEVICE9 lpd3ddev);
extern void	RestoreSkinnedMeshGraphics(LPDIRECT3DDEVICE9 lpd3ddev);
extern void	InvalidateSkinnedMeshGraphics();
extern void	DeleteSkinnedMeshGraphics();

#endif