//-----------------------------------------------------------------------------
// File: D3DKanjiFont.h
//
// Desc: eNX`gptHgNX
//-----------------------------------------------------------------------------
#ifndef __D3DKANJIFONT_H__
#define __D3DKANJIFONT_H__
#include <tchar.h>

#ifndef	__D3D9ENV_H__
#include "d3d9env.h"
#endif
#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif
#ifndef __D3DFONT_H__
#include "d3dfont.h"
#endif

#define	kKanjiHashSize	16

typedef struct	_hashdummy
{
	struct	_hashdummy	*m_pPrevChar;
	struct	_hashdummy	*m_pNextChar;
}	HashDummy;
typedef struct	_cashdummy
{
	struct	_cashdummy	*m_pPrevChar;
	struct	_cashdummy	*m_pNextChar;
	struct	_cashdummy	*m_pPrevCache;
	struct	_cashdummy	*m_pNextCache;
}	CashDummy;

typedef struct _fontcache
{
	struct	_fontcache	*m_pPrevChar;
	struct	_fontcache	*m_pNextChar;
	struct	_fontcache	*m_pPrevCache;
	struct	_fontcache	*m_pNextCache;
	DWORD	m_dwCharCode;	//	R[h
	short	row;
	short	col;
	short	tx;				//	eNX`WisNZPʁj
	short	ty;				//		V
	short	w;				//	eNX`isNZPʁj
	short	h;				//	eNX`isNZPʁj
	FLOAT	u;
	FLOAT	v;
	FLOAT	vw;					//摜
	FLOAT	vh;					//摜

}	FontCache;

typedef struct	_drawcache{
	FontCache		*pCache;
	FLOAT			fMove;	//	pCache  NULL ̎̈ړ
}	DrawCache;

typedef struct	_texturecache{
	FontCache	*pCache;
}	TextureCache;

class CD3DKanjiFont : public CD3DFont
{
public:
	CD3DKanjiFont( CD3DEnv *pEnv, TCHAR* strFontName, DWORD dwHeight, DWORD dwFlags=0L );
	virtual	~CD3DKanjiFont(void);

	// foCXˑIuWFNg̐Ɣj
	virtual	HRESULT DrawText( FLOAT x, FLOAT y, DWORD dwColor, 
                      TCHAR* strText, DWORD dwFlags=0L );
	virtual	HRESULT DrawTextClipped( LPRECT clipRect, FLOAT x, FLOAT y, DWORD dwColor, 
                      TCHAR* strText, DWORD dwFlags=0L );
	virtual	HRESULT DrawTextScaled( FLOAT x, FLOAT y, 
                            FLOAT fXScale, FLOAT fYScale, DWORD dwColor, 
                            TCHAR* strText, DWORD dwFlags=0L );
	virtual	HRESULT DrawTextClippedScaled( LPRECT clipRect, FLOAT x, FLOAT y, 
                            FLOAT fXScale, FLOAT fYScale, DWORD dwColor, 
                            TCHAR* strText, DWORD dwFlags=0L );
    virtual	HRESULT GetTextExtent( TCHAR* strText, SIZE* pSize );

protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();

private:
	void	AppendToFontCache(FontCache *p);
	void	SnipFromFontCache(FontCache *p);
	void	IncrementCachePriority(FontCache *p);
	void	AppendToHashTable(int hashno, FontCache *p);
	void	SnipFromHashTable(FontCache *p);
	void	RecalcTextureCoords();
	void	PrepareCharacterTexture(FontCache *p,D3DLOCKED_RECT *pd3dlr);
	void	DrawChar(DWORD charcode);
	int		Hash(DWORD charcode);
	FLOAT	FlushCache(LPDIRECT3DDEVICE9 lpd3ddev,LPRECT clipRect, FLOAT sx, FLOAT &sy, FLOAT cx, D3DCOLOR dwColor, FLOAT scale_x, FLOAT scale_y);

	HashDummy	m_fcHashDummy[kKanjiHashSize+1];
	CashDummy	m_fcCacheDummy;

	FontCache	*m_pHashTable[kKanjiHashSize+1];	
	FontCache	*m_pCaches;

	DrawCache		*m_pDrawCache;
	int				m_iDrawCacheIx;
	TextureCache	*m_pTexCache;
	int				m_iTexCacheIx;
	
	HFONT		m_hFont;
	HDC			m_hDC;
	HBITMAP		m_hbmBitmap;
	WORD		*m_pBitmapBits;
	FLOAT		m_fInvTexWidth;
	FLOAT		m_fInvTexHeight;
	INT			m_iFontHeightInPixel;
	FLOAT		m_fAnkSpcWidth;
	FLOAT		m_fKnjSpcWidth;
	DWORD		m_dwTextureValidWidth;
	DWORD		m_dwTextureValidHeight;
};

#endif