#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\player.h"

CPlayer::CPlayer(CD3DEnv *pEnv, CMesh *pMesh)
{
	m_pEnv = pEnv;
	m_pMesh = pMesh;
	m_vecPos = D3DXVECTOR3(0,0,0);
	m_fVelocityY = 0.0f;
}

CPlayer::~CPlayer(void)
{
}

//	Aj[V
void	CPlayer::Update(float timeElapsed){
	FLOAT	fOld = m_fVelocityY;
	m_fVelocityY -= 0.01f * timeElapsed;
	if (m_fVelocityY < -0.125f)
		m_fVelocityY = -0.125f;
	m_vecPos.y += (fOld + m_fVelocityY) * 0.5f * timeElapsed;
	if (m_pEnv->GetDI8KeyState(DIK_LEFT))
		m_vecPos.x -= 0.03f * timeElapsed;
	if (m_pEnv->GetDI8KeyState(DIK_RIGHT))
		m_vecPos.x += 0.03f * timeElapsed;
	D3DXMatrixTranslation(&m_matWorld,m_vecPos.x, m_vecPos.y, m_vecPos.z);
}

//	`
void	CPlayer::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	lpd3ddev->SetTransform(D3DTS_WORLD,&m_matWorld);
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	m_pMesh->Render(lpd3ddev);
}

//	LN^̒SWԂ
D3DXVECTOR3*	CPlayer::GetCentralPoint(D3DXVECTOR3 *pPos){
	pPos->x = m_vecPos.x;
	pPos->y = m_vecPos.y + 0.5f;
	pPos->z = m_vecPos.z;
	return	pPos;
}

//	LN^̑̍WԂ
D3DXVECTOR3*	CPlayer::GetStandingPoint(D3DXVECTOR3 *pPos){
	pPos->x = m_vecPos.x;
	pPos->y = m_vecPos.y;
	pPos->z = m_vecPos.z;
	return	pPos;
}

//	LN^𕽍sɈړ
void	CPlayer::MoveTo(D3DXVECTOR3	*pVecDir, FLOAT fAmount){
	m_vecPos += *pVecDir * fAmount;
	m_matWorld._41 = m_vecPos.x;
	m_matWorld._42 = m_vecPos.y;
	m_matWorld._43 = m_vecPos.z;
}

//	LN^̔aԂ
FLOAT	CPlayer::GetRadius(){
	return	0.5f;
}

//	x̃Zbg
void	CPlayer::ResetVelocity(){
	m_fVelocityY = 0;
}