/*
 *	class CMesh
 *		bVɋ@\ǉ郆[eBeB[NX
 *
 *		First edition: February.19.2004
 *
*/
#ifndef	__MESH_H__
#define	__MESH_H__

#define	MESH_IS_UNINITIALIZED	0
#define	MESH_IS_INITIALIZED		1
#define	MESH_IS_RESTORED		2

#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

#ifndef	__D3D9ENV_H__
#include "d3d9env.h"
#endif

class	CTextureNode;

#define	MESH_OPAQUE			0
#define	MESH_SEMI_TRANS		1
#define	MESH_ADD_IN			2

class CMesh : public CGraphicsObject
{
public:
	CMesh(CD3DEnv *pEnv, TCHAR *fname);
	virtual ~CMesh();
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	GetObjectCenter( D3DXVECTOR3 *pPos);
	virtual	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	virtual	UINT	GetMeshStatus(){	return	m_uiMeshStatus;	}
	virtual	float	GetRadius(){	return	m_fObjectRadius;	}
	virtual	HRESULT	GetVertexBuffer(LPDIRECT3DVERTEXBUFFER9 *ppVB);
	virtual	HRESULT	GetIndexBuffer(LPDIRECT3DINDEXBUFFER9 *ppIB);
	virtual	DWORD	GetFVF();
	virtual	DWORD	GetNumVertices();
	virtual	DWORD	GetNumFaces();
	virtual void	SetOpacity(FLOAT fOpacity){	m_fOpacity = fOpacity;	}
	virtual void	SetBlendMode(DWORD method){	m_uiBlendMethod = method;	}
protected:
	virtual	HRESULT	InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	HRESULT	DeleteDeviceObjects();
	TCHAR					m_strMeshPath[512];
	TCHAR					*m_strMeshFilename;	//	bVt@C̃t@Cl[
	LPD3DXMESH				m_pMeshSysMem;      //	VXeo[W̃bV
	D3DMATERIAL9*			m_pMaterials;       //	}eAւ̃|C^AbVRs[B
	CTextureNode			**m_ppTextures;       //	eNX`[zւ̃|C^
	DWORD					m_dwNumMaterials;   //	}eA
	D3DXVECTOR3				m_vObjectCenter;    //	oE_̒S_
	FLOAT					m_fObjectRadius;    //	oE_̔a
	D3DXVECTOR3				m_vecObjectMin;		//	oE_{bNX̍ŏ_
	D3DXVECTOR3				m_vecObjectMax;		//	oE_{bNX̍ő_
	FLOAT					m_fOpacity;			//	sx
	DWORD					m_uiBlendMethod;	//	At@uh@

	LPSTR					*m_ppFilenames;		//
	LPSTR					m_pFilenameBuffer;	//
	UINT					m_uiMeshStatus;		//	bV̏ԕϐ
	CD3DEnv					*m_lpD3DEnv;			//	Direct3DNX
};


#endif