#include "stdafx.h"
#include <d3dx9.h>
#include <stdio.h>
#include "D3DQuickLib.h"
#include "Player.h"
CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

CWall	*g_pWalls = NULL;	//	ǃf
CMesh	*g_pMesh = NULL;	//	LN^f

CD3DKanjiFont	*g_pFont = NULL;	//	tHg

CPlayer *g_pPlayer = NULL;	//	LN^NXCX^X
float		g_fTime = 0;

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;
	g_fTime += timeElapsed;

	D3DXMATRIX	matWorld;
	D3DXMatrixRotationZ(&matWorld,g_fTime * D3DX_PI/ 1200.0f );
	g_pWalls->SetWorldMatrix(&matWorld);
	if (g_pPlayer)
		g_pPlayer->Update(timeElapsed);

	//	Ǔ蔻
	D3DXVECTOR3	vecUp = D3DXVECTOR3(0,1.0f,0);
	D3DXVECTOR3	vecTmp, vecNormal, vecPos;
	FLOAT	fDist, fDot;
	if (g_pWalls->ProbeTheWallSinkDepth(g_pPlayer->GetCentralPoint(&vecPos),g_pPlayer->GetRadius(),&vecNormal,&fDist)){
		fDot = D3DXVec3Dot(&vecUp,&vecNormal);
		if (fDot >= cosf(D3DX_PI * 0.25f)){
			//	ȂVƂĔ
			g_pPlayer->MoveTo(&vecUp,fDist / fDot);
			g_pPlayer->ResetVelocity();
		}else{
			//	ǂƂĔ
			g_pPlayer->MoveTo(&vecNormal,fDist);
		}
	}

	if (g_fTime > 2400.0f)
		g_fTime -= 2400.0f;
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
	static	TCHAR mes1[]=_T("蔻̃Tvł邽߁Afm̑ݍp͍lĂȂB");
	static	TCHAR mes2[]=_T("܂wiẲeł̓{[͈ړȂB");
	if (g_pWalls)
		g_pWalls->Render(lpd3ddev);
	if (g_pPlayer){
		g_pPlayer->Render(lpd3ddev);

		D3DXVECTOR3	vecPos;
		g_pPlayer->GetStandingPoint(&vecPos);
		TCHAR	tmp[512];
		_stprintf(tmp,"%f:%f:%f",vecPos.x,vecPos.y,vecPos.z);
		g_pD3DEnv->SystemD3DFont()->DrawText(10.0f,10.0f,D3DCOLOR_XRGB(255,255,255),tmp);
	}
	if (g_pFont){
		g_pFont->DrawText(10.0f,400.0f,D3DCOLOR_XRGB(255,255,255),mes1);
		g_pFont->DrawText(10.0f,420.0f,D3DCOLOR_XRGB(255,255,255),mes2);

	}
}


int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "Tuto24";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto24",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	g_pD3DEnv = new CD3DEnv();
	if (SUCCEEDED(g_pD3DEnv->InitD3D(hWnd))){
		g_pWalls = new CWall(g_pD3DEnv, _T("room.x"));
		g_pMesh = new CMesh(g_pD3DEnv,_T("sphere_0_5.x"));
		g_pFont = new CD3DKanjiFont(g_pD3DEnv,_T("lr "),16,D3DFONT_SIZE_IN_PIXELS);
		//	OtBbNX̓ǂݍ
		g_pD3DEnv->ReloadGraphics();
		g_pPlayer = new CPlayer(g_pD3DEnv, g_pMesh);
	}else
		DestroyWindow(hWnd);

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
	SAFE_DELETE(g_pPlayer);
	SAFE_DELETE(g_pFont);
	SAFE_DELETE(g_pWalls);
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pD3DEnv);
	_CrtDumpMemoryLeaks();

    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
