#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Player.h"

CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

CEnhancedMesh	*g_pMesh = NULL;
CPlayer			*g_pPlayer = NULL;
CFloor			*g_pFloor = NULL;
float		g_fTime = 0;

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;
	g_fTime += timeElapsed;
	if (g_pPlayer){
		g_pPlayer->Update(timeElapsed);
		D3DXVECTOR3	vecMin, vecMax, vecPos, vecNormal;
		g_pPlayer->GetBoundingBox(&vecMin, &vecMax);
		vecMin.y -= 0.1f;
		g_pPlayer->GetStandingPoint(&vecPos);

		FLOAT	fAltTmp, fDist, fAlt;
		fAlt = g_pPlayer->GetAltitude();
		if (g_pFloor){
			D3DXMATRIX	matWorld;
			D3DXMatrixIdentity(&matWorld);
			if (g_pD3DEnv->GetDI8KeyState(DIK_SPACE)){
				D3DXMatrixRotationZ(&matWorld,D3DX_PI);
				matWorld._42 = 2.0f;
			}
			g_pFloor->SetWorldMatrix(&matWorld);
			if (g_pFloor->ProbeTheGroundAltitudeOneSide(&vecPos,&vecMin,&vecMax,&vecNormal,&fAltTmp,&fDist)){
				fAlt = fAltTmp;
				g_pPlayer->SetAltitude(fAlt);
			}
		}
		D3DXMATRIX	*pView;
		pView = g_pD3DEnv->GetSystemView();
		g_pPlayer->GetViewMatrix(pView);
	}
	if (g_fTime > 600.0f)
		g_fTime -= 600.0f;
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
	if (g_pPlayer)
		g_pPlayer->Render(lpd3ddev);
	if (g_pFloor)
		g_pFloor->Render(lpd3ddev);
	g_pD3DEnv->SystemD3DFont()->DrawText(10.0f,10.0f,D3DCOLOR_XRGB(255,255,255),_T("Push space key to turn over the ground."));
	
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "Tuto23";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto23",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	g_pD3DEnv = new CD3DEnv();
	if (SUCCEEDED(g_pD3DEnv->InitD3D(hWnd))){
		//	OtBbNX̓ǂݍ
		g_pMesh = new CEnhancedMesh(g_pD3DEnv,"\\mesh\\dog.x");
		g_pFloor = new CFloor(g_pD3DEnv, "\\mesh\\land.x");
		//	foCXփOtBbNXf[^]
		g_pD3DEnv->ReloadGraphics();
		g_pPlayer = new CPlayer(g_pD3DEnv,g_pMesh);
	}else
		DestroyWindow(hWnd);

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
	SAFE_DELETE(g_pPlayer);
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pD3DEnv);
    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
