/*
 *	class CPlayer
 *		v[̎NX
 *
 *		First edition: February.19.2004
 *
*/

#ifndef __PLAYER_H__
#define	__PLAYER_H__

class CPlayer  
{
public:
	CPlayer(CD3DEnv *pEnv, CMesh *pMesh);
	virtual ~CPlayer();
	void	Update(float timeElapsed);
	void	SetAltitude(float fAlt);
	FLOAT	GetAltitude();
	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	void	GetViewMatrix(D3DXMATRIX *pMat);
	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	void	GetStandingPoint(D3DXVECTOR3 *pPos);
private:
	void	CalcCameraPosition();
	CD3DEnv		*m_pEnv;
	CMesh		*m_pMesh;
	D3DXMATRIX	m_matWorld;
	D3DXMATRIX	m_matYawPitchRoll;
	D3DXMATRIX	m_matView;
	D3DXVECTOR3	m_vecFront;
	float		m_fAngleY1;
	float		m_fX;
	float		m_fY;
	float		m_fZ;
};
extern void	InitializePlayer();

#endif