/*
 *	class CPlayer
 *		v[̎NX
 *
 *		First edition: February.19.2004
 *
*/
#include "stdafx.h"

#include <tchar.h>
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Player.h"

/*
*	LbV
*	̃v[CX^XQƂł邵
*	񋟂B
*/

CPlayer::CPlayer(CD3DEnv *pEnv, CMesh *pMesh)
{
	D3DXMatrixTranslation(&m_matWorld,0.0f,0.0f,0.0f);
	m_vecFront = D3DXVECTOR3(0.0f,0.0f,1.0f);
	m_fX = 0.0f;
	m_fY = 0.0f;
	m_fZ = 0.0f;
	m_fAngleY1 = 0.0f;
	CalcCameraPosition();
	m_pMesh = pMesh;
	m_pEnv = pEnv;
}

CPlayer::~CPlayer()
{
}

//-------------------------------------------------------------
//	Name: CalcCameraPosition
//  Desc: JʒuvZ
//-------------------------------------------------------------
void	CPlayer::CalcCameraPosition(){
	D3DXVECTOR4	vecViewFrom;
	D3DXVECTOR4	vecLookAt;
	D3DXVECTOR4	vecViewUp;
	D3DXVECTOR3	vecRight;
	D3DXVECTOR3	vec3Tmp;
	D3DXMATRIX	matRot;
	vecViewFrom = D3DXVECTOR4(0.0f,2.0f,-5.0f,1.0f);
	vecLookAt = D3DXVECTOR4(0.0f,0.0f,3.0f,1.0f);
	vecRight = D3DXVECTOR3(1.0f,0.0f,0.0f);
	vec3Tmp.x = vecLookAt.x - vecViewFrom.x;
	vec3Tmp.y = vecLookAt.y - vecViewFrom.y;
	vec3Tmp.z = vecLookAt.z - vecViewFrom.z;

	//	Jɑ΂ď̕xNgZo
	D3DXVec3Cross((D3DXVECTOR3*)&vecViewUp,&vec3Tmp,&vecRight);
	D3DXVec3Normalize((D3DXVECTOR3*)&vecViewUp,(D3DXVECTOR3*)&vecViewUp);

	//	JʒuE[hWɕϊ
	D3DXVec3Transform(&vecViewFrom,(D3DXVECTOR3*)&vecViewFrom,&m_matWorld);
	D3DXVec3Transform(&vecLookAt,(D3DXVECTOR3*)&vecLookAt,&m_matWorld);
	vecViewUp.w = 0.0f;	//	݂̂̌vZsȂ߁A
						//	wp[^0.0ɂB
	D3DXVec4Transform(&vecViewUp,&vecViewUp,&m_matWorld);

	//	r[s̎Zo
	D3DXMatrixLookAtLH(&m_matView,(D3DXVECTOR3*)&vecViewFrom,
				(D3DXVECTOR3*)&vecLookAt,(D3DXVECTOR3*)&vecViewUp );
}


//-------------------------------------------------------------
//	Name: Update
//  Desc: t[
//-------------------------------------------------------------
void	CPlayer::Update(float	timeElapsed)
{
	float		fTrans;
	if (m_pEnv->GetDI8KeyState(DIK_LEFT)){
		m_fAngleY1 -= (D3DX_PI*timeElapsed)/60.0f;
		while (m_fAngleY1 < 0.0f){
			m_fAngleY1 += D3DX_PI*2.0f;
		}
	}else if (m_pEnv->GetDI8KeyState(DIK_RIGHT)){
		m_fAngleY1 += (D3DX_PI*timeElapsed)/60.0f;
		while (m_fAngleY1 > D3DX_PI*2.0f){
			m_fAngleY1 -= D3DX_PI*2.0f;
		}
	}
	fTrans = (10.0f * timeElapsed)/ 60.0f;
	if (m_pEnv->GetDI8KeyState(DIK_UP)){
		m_fX += m_vecFront.x * fTrans;	
		m_fZ += m_vecFront.z * fTrans;	
	}else if (m_pEnv->GetDI8KeyState(DIK_DOWN)){
		m_fX -= m_vecFront.x * fTrans;	
		m_fZ -= m_vecFront.z * fTrans;	

	}
	if (m_fY > 0.0f)
		m_fY -= 0.1f * timeElapsed;
	m_vecFront = D3DXVECTOR3(0.0f,0.0f,1.0f);
	D3DXMatrixRotationY(&m_matYawPitchRoll,m_fAngleY1);
	D3DXVec3TransformCoord(&m_vecFront,&m_vecFront,&m_matYawPitchRoll);
	D3DXMatrixTranslation(&m_matWorld,m_fX,m_fY,m_fZ);
	m_matWorld = m_matYawPitchRoll * m_matWorld;
	CalcCameraPosition();
}

//-------------------------------------------------------------
//	Name: SetAltitude
//  Desc: x̐ݒ
//-------------------------------------------------------------
void	CPlayer::SetAltitude(float fAlt){
	m_fY = fAlt;
	D3DXMatrixTranslation(&m_matWorld,m_fX,m_fY,m_fZ);
	m_matWorld = m_matYawPitchRoll * m_matWorld;
}

//-------------------------------------------------------------
//	Name: GetAltitude
//  Desc: x̎擾
//-------------------------------------------------------------
FLOAT	CPlayer::GetAltitude(){
	return	m_fY;
}

//-------------------------------------------------------------
//	Name: Render
//  Desc: `揈
//-------------------------------------------------------------
void	CPlayer::Render(LPDIRECT3DDEVICE9 lpd3ddev)
{
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );
	lpd3ddev->SetTransform( D3DTS_VIEW, &m_matView);
	D3DXMATRIX	mat;

	//	<- -> L[ĂԁA
	//	X
	lpd3ddev->SetTransform( D3DTS_WORLD, &m_matWorld );
	m_pMesh->Render(lpd3ddev);

#if	0
	//	fobOpɃoE_{bNX\B
	D3DXVECTOR3	vecMin, vecMax;
	GetBoundingBox(&vecMin,&vecMax);
	RenderBoundingBoxForDebug(&vecMin,&vecMax);
#endif
}

//-------------------------------------------------------------
//	Name: GetViewMatrix
//  Desc: v[Œ̃Jʒu
//-------------------------------------------------------------
void	CPlayer::GetViewMatrix(D3DXMATRIX *pMat){
	*pMat = m_matView;
}


//-------------------------------------------------------------
//	Name: GetBoundingBox
//  Desc: 蔻ׂ̈̃{bNX񋟂
//		oE_{bNX́A[hWŕ\B
//-------------------------------------------------------------
void	CPlayer::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax)
{
	D3DXVECTOR3	pVec[8];
	D3DXVECTOR3	vecMin, vecMax;
	
	m_pMesh->GetBoundingBox(&vecMin, &vecMax);

	pVec[3].z = pVec[2].z = pVec[1].z = pVec[0].z = vecMin.z;
	pVec[1].x = pVec[0].x = vecMin.x;
	pVec[3].x = pVec[2].x = vecMax.x;
	pVec[2].y = pVec[1].y = vecMax.y;
	pVec[3].y = pVec[0].y = vecMin.y;

	pVec[7].z = pVec[6].z = pVec[5].z = pVec[4].z = vecMax.z;
	pVec[5].x = pVec[4].x = vecMin.x;
	pVec[7].x = pVec[6].x = vecMax.x;
	pVec[6].y = pVec[5].y = vecMax.y;
	pVec[7].y = pVec[4].y = vecMin.y;

	//	[hW֕ϊ
	UINT	i;
	for (i = 0; i < 8 ; ++i){
		D3DXVec3TransformCoord(&pVec[i], &pVec[i], &m_matWorld);
	}
	vecMin.x = vecMin.y = vecMin.z = FLT_MAX;
	vecMax.x = vecMax.y = vecMax.z = -FLT_MAX;
	for (i = 0; i < 8 ; ++i){
		if (vecMin.x > pVec[i].x){
			vecMin.x = pVec[i].x;
		}
		if (vecMin.y > pVec[i].y){
			vecMin.y = pVec[i].y;
		}
		if (vecMin.z > pVec[i].z){
			vecMin.z = pVec[i].z;
		}
		if (vecMax.x < pVec[i].x){
			vecMax.x = pVec[i].x;
		}
		if (vecMax.y < pVec[i].y){
			vecMax.y = pVec[i].y;
		}
		if (vecMax.z < pVec[i].z){
			vecMax.z = pVec[i].z;
		}
	}

	*pMin = vecMin;
	*pMax = vecMax;
}

//-------------------------------------------------------------
//	Name: GetStandingPoint
//  Desc: n`Ƃ̂蔻ׁ̈Aڒnn__ŕԂB
//-------------------------------------------------------------
void	CPlayer::GetStandingPoint(D3DXVECTOR3 *pPos)
{
	D3DXVECTOR3	vecPos,vecMin,vecMax;
	m_pMesh->GetObjectCenter(&vecPos);
	m_pMesh->GetBoundingBox(&vecMin, &vecMax);
	vecPos.y = vecMin.y;
	D3DXVec3TransformCoord(pPos,&vecPos,&m_matWorld);
}
