// Tuto22.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "Tuto22.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"

#include "PixelSpecularMesh.h"
#define MAX_LOADSTRING 100


// O[oϐ :
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX

// ̃R[h W[Ɋ܂܂֐̐錾]܂ :
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

CD3DEnv	*g_pD3DEnv = NULL;
CPixelSpecularMesh	*g_pMesh = NULL;
HWND	g_hWnd = NULL;
float   g_fTime = 0;       // Aj[VŎgp

//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐ R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
    g_fTime += timeElapsed;
    if (g_fTime > 1200.0f)
        g_fTime -= 1200.0f;
	//	20070117  ݒ
	FLOAT	fAngle = g_fTime * D3DX_PI / 600.0f;
	D3DXVECTOR3	vecLight = D3DXVECTOR3(cosf(fAngle),0,sinf(fAngle));

	D3DXMATRIX	matRotation;
	D3DLIGHT9	*pLight;
	pLight = g_pD3DEnv->GetSystemLight();
	D3DXMatrixRotationZ(&matRotation,D3DX_PI*0.25f);
	D3DXVec3TransformNormal(&vecLight,&vecLight,&matRotation);
	pLight->Direction = vecLight;
	pLight->Diffuse.r = 0.5f;
	pLight->Diffuse.g = 0.5f;
	pLight->Diffuse.b = 0.5f;
	pLight->Specular.r = 0.5f;
	pLight->Specular.g = 0.5f;
	pLight->Specular.b = 0.5f;
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐ R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
	D3DXMATRIX	matWorld;
	D3DXMatrixIdentity(&matWorld);
	g_pMesh->Render(lpd3ddev,&matWorld);
}


int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: ɃR[h}ĂB
	MSG msg;
	HACCEL hAccelTable;

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_TUTO22, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂B:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_TUTO22);

    //    D3DQuickLib ̏
    g_pD3DEnv = new CD3DEnv();
    if (FAILED(g_pD3DEnv->InitD3D(g_hWnd))){
        DestroyWindow(g_hWnd);
	}else{
		g_pMesh = new CPixelSpecularMesh(g_pD3DEnv,_T("sphere_specular.x"));
		g_pD3DEnv->ReloadGraphics();
	}

    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
            g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
    //    D3DQuickLib ̏I
	SAFE_DELETE(g_pMesh);
	SAFE_DELETE(g_pD3DEnv);


	return (int) msg.wParam;
}



//
//  ֐ : MyRegisterClass()
//
//  ړI : EBhE NXo^܂B
//
//  Rg :
//
//    ̊֐юǵA'RegisterClassEx' ֐ǉꂽ
//     Windows 95 O Win32 VXeƌ݊ꍇɂ̂ݕKvłB
//    AvP[VA֘Atꂽ 
//    `̏ACR擾ł悤ɂɂ́A
//    ̊֐ĂяoĂB
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_TUTO22);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCTSTR)IDC_TUTO22;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

//
//   ֐ : InitInstance(HANDLE, int)
//
//   ړI : CX^X nhۑāAC EBhE쐬܂B
//
//   Rg :
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
	g_hWnd = hWnd;
   return TRUE;
}

//
//  ֐ : WndProc(HWND, unsigned, WORD, LONG)
//
//  ړI :  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Iꂽj[̉ :
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		// TODO: `R[hɒǉĂ...
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// o[W{bNX̃bZ[W nhłB
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}
