#include "StdAfx.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\pixelspecularmesh.h"

//	AZuς݃VF[_̃CN[h
//	̃CN[ht@ĆAvWFNg
//	makepsh.bat ob`t@CŐꂽ́B
#include "shdata.c"

//
//	RXgN^
//
CPixelSpecularMesh::CPixelSpecularMesh(CD3DEnv *pEnv, TCHAR *pFilename)
:CMesh(pEnv,pFilename)
{
	CShaderContainer *pContainer = pEnv->GetShaderContainer(__uuidof(CLSID_PixelSpecularVsh));
	if (pContainer == NULL){
		pContainer = new CVertexShaderFromMemory(pEnv,PixelSpecular_vsh,sizeof(PixelSpecular_vsh),__uuidof(CLSID_PixelSpecularVsh));
	}
	m_pVertexShader = pContainer;
	pContainer = pEnv->GetShaderContainer(__uuidof(CLSID_PixelSpecularPsh));
	if (pContainer == NULL){
		pContainer = new CPixelShaderFromMemory(pEnv,PixelSpecular_psh,sizeof(PixelSpecular_psh),__uuidof(CLSID_PixelSpecularPsh));
	}
	m_pPixelShader = pContainer;
}

CPixelSpecularMesh::~CPixelSpecularMesh(void)
{
	SAFE_RELEASE(m_pVertexShader);
	SAFE_RELEASE(m_pPixelShader);
}

HRESULT	CPixelSpecularMesh::InitDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev){
    LPD3DXMESH pTempMesh;
	HRESULT	hr;
	if (m_pMeshSysMem != NULL ){
		m_uiMeshStatus = MESH_IS_INITIALIZED;
		return	S_OK;
	}
	hr = CMesh::InitDeviceObjects(lpd3ddev);
    // _tH[}bg̏CE_VF[_ɍ킹B_J[ɂ͑ΉĂȂB
    if( SUCCEEDED(hr) && m_pMeshSysMem!= NULL)
    {
        hr = m_pMeshSysMem->CloneMeshFVF( m_pMeshSysMem->GetOptions(), 
                                          (m_pMeshSysMem->GetFVF() &  D3DFVF_POSITION_MASK) | D3DFVF_NORMAL | D3DFVF_TEX1, 
                                          lpd3ddev, &pTempMesh );
		if (SUCCEEDED(hr)){
			m_pMeshSysMem->Release();
			m_pMeshSysMem = pTempMesh;
		}
    }
	return	hr;
}

void	CPixelSpecularMesh::Render(LPDIRECT3DDEVICE9 lpd3ddev, D3DXMATRIX *pWorld){
	D3DXMATRIX	matWorldView = *pWorld * *m_lpD3DEnv->GetSystemView();
	if (m_pMeshSysMem == NULL)
		return;

	lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);

	lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_CCW);

	lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
	switch(this->m_uiBlendMethod){
		case	MESH_SEMI_TRANS:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		case	MESH_ADD_IN:
			lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
			lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			break;
		default:
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			break;
	}
    D3DXVECTOR4 vConst0( 0.0f, 0.0f, 0.0f, 0.0f );
    D3DXVECTOR4 vConst1( 1.0f, 0.5f, 2.0f, 4.0f );
	D3DXVECTOR3	vLightDir;
	//	Set Common Vertex Shader Constant
    lpd3ddev->SetVertexShaderConstantF(0, (float*)&vConst0, 1);
    lpd3ddev->SetVertexShaderConstantF(1, (float*)&vConst1, 1);

	//	Fog
	vConst0.x = m_fFogStart;
	vConst0.y = m_fFogEnd;
	vConst0.z = 1.0f / (m_fFogEnd - m_fFogStart);
    lpd3ddev->SetVertexShaderConstantF(3, (float*)&vConst0, 1);

	//	WorldView s
	D3DXMATRIX	matTmp;
	D3DXMatrixTranspose(&matTmp, &matWorldView);
    lpd3ddev->SetVertexShaderConstantF(8, (float*)&matTmp, 4);

	//	WorldViewProjection
	D3DXMatrixMultiplyTranspose(&matTmp,&matWorldView,m_lpD3DEnv->GetSystemProjection());
    lpd3ddev->SetVertexShaderConstantF(4, (float*)&matTmp, 4);

	//	sɑΉ
	vLightDir = *m_lpD3DEnv->GetSystemLightDirection();
	vLightDir *= -1.0f;
	D3DXVec3TransformNormal(&vLightDir,&vLightDir,m_lpD3DEnv->GetSystemView());
	D3DXVec3Normalize( &vLightDir, &vLightDir);

	lpd3ddev->SetVertexShaderConstantF(16, (float*)&vLightDir, 1);
	lpd3ddev->SetPixelShaderConstantF(0, (float*)&vLightDir, 1);

	//	_VF[_̓Kp
	lpd3ddev->SetVertexShader(m_pVertexShader->GetDXVertexShader());

	//	sNZVF[_̓Kp
	lpd3ddev->SetPixelShader(m_pPixelShader->GetDXPixelShader());

	UINT	i;
	for (i = 0; i < m_dwNumMaterials ; ++i){
        D3DXCOLOR	color1(m_pMaterials[i].Ambient);
		D3DCOLOR	c = m_lpD3DEnv->GetAmbientColor();
		D3DXCOLOR	color2(	((c>>16)&0xff) * (1/255.0f), 
							((c>>8)&0xff) * (1/255.0f), 
							((c)&0xff) * (1/255.0f), 1.0);
        D3DXCOLOR ambEmm;
        D3DXColorModulate(&ambEmm, &color1, &color2);
        ambEmm += D3DXCOLOR(m_pMaterials[i].Emissive);
		D3DXCOLOR	diffuse;
		D3DXCOLOR	specular;
		D3DXColorModulate(&diffuse,&D3DXCOLOR(m_pMaterials[i].Diffuse),&D3DXCOLOR(m_lpD3DEnv->GetSystemLight()->Diffuse));
		diffuse.a *= m_fOpacity;
		lpd3ddev->SetPixelShaderConstantF(1, (float*)&diffuse, 1);
		lpd3ddev->SetPixelShaderConstantF(2, (float*)&ambEmm, 1);
		specular = m_lpD3DEnv->GetSystemLight()->Specular;
		lpd3ddev->SetPixelShaderConstantF(3, (float*)&specular, 1);

		//
		if (m_ppTextures[i]){
			lpd3ddev->SetTexture( 0, m_ppTextures[i]->GetTexture() );
		}else{
			lpd3ddev->SetTexture( 0, NULL );
		}
		m_pMeshSysMem->DrawSubset(i);
	}
}
