/*
 *		Windows ̊{IȃCxgȂǂsȂvO
 *
 */
#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"

CD3DEnv	*g_pD3DEnv = NULL;
LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

float			g_fTime = 0;
float			g_fTime2 = 0;
CWall			*g_pWall = NULL;
D3DXVECTOR3		g_vecLine[2];
//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
    g_fTime += timeElapsed;
    if (g_fTime > 600.0f)
        g_fTime -= 600.0f;
    g_fTime2 += timeElapsed*0.67;
    if (g_fTime2 > 600.0f)
        g_fTime2 -= 600.0f;

	if (g_pD3DEnv->GetDI8KeyState(DIK_SPACE)){
		g_vecLine[0] = D3DXVECTOR3(0,-2.0f,20.0f);
		g_vecLine[1] = D3DXVECTOR3(0,-2.0f,5.0f);
	}else{
		g_vecLine[0] = D3DXVECTOR3(0,-2.0f,10.0f);
		g_vecLine[1] = D3DXVECTOR3(0,-2.0f,-5.0f);
	}
	D3DXMATRIX	matRot1,matRot2,matWorld;
	D3DXMatrixRotationY(&matRot1,(D3DX_PI /60.0f)* g_fTime2);
	D3DXMatrixRotationZ(&matRot2,(D3DX_PI /60.0f)* g_fTime);
	D3DXMatrixTranslation(&matWorld,0,-2.0f,0);
	matWorld = matRot1 * matWorld * matRot2;
	g_pWall->SetWorldMatrix(&matWorld);
	if (g_pWall->CheckCollisionWithSegment(&g_vecLine[0],&g_vecLine[1],0.1f)){
		g_pD3DEnv->SetBackgroundColor(D3DCOLOR_XRGB(255,96,96));
	}else
		g_pD3DEnv->SetBackgroundColor(D3DCOLOR_XRGB(96,96,96));
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//		UpdateScene ֐(d3dmain.cpp) R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{

	lpd3ddev->SetRenderState(D3DRS_LIGHTING, FALSE);
	g_pD3DEnv->RenderLine3D(g_vecLine,D3DCOLOR_XRGB(255,255,255));

	lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );

	lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	g_pWall->Render(lpd3ddev);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "D3DQuickLibSample";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Tuto17 - ړ̓蔻.",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        640 * 2 - client.right,
        480 * 2 - client.bottom,
        false );
    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

	g_pD3DEnv = new CD3DEnv();
	if (SUCCEEDED(g_pD3DEnv->InitD3D(hWnd))){
		//	OtBbNX̓ǂݍ
		g_pD3DEnv->SetBackgroundColor(D3DCOLOR_XRGB(96,96,96));
		g_pWall = new CWall(g_pD3DEnv,_T("mesh\\cube.x"));
		//	foCXփOtBbNXf[^]
		g_pD3DEnv->ReloadGraphics();
	}else
		DestroyWindow(hWnd);

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
			g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
	SAFE_DELETE(g_pWall);
	SAFE_DELETE(g_pD3DEnv);
    return (int)msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            if (SIZE_MAXIMIZED == wParam){
				g_pD3DEnv->ForceFullscreen();
			}
            break;
        case    WM_SETCURSOR:
			if (g_pD3DEnv->IsWindowed())
				::SetCursor(::LoadCursor(NULL,IDC_ARROW));
			else
				::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_SYSCOMMAND:
			if (!g_pD3DEnv->IsWindowed()){	//	tXN[
				if (wParam != SC_CLOSE)
					break;

				//	WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
				Sleep(100);
			}
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
