/*
 *	class CWall
 *		ǂ̎NX
 *
 *		First edition: March.09.2004
 *
*/
#ifndef __WALL_H__
#define	__WALL_H__

#ifndef	__MESH_H__
#include "Mesh.h"
#endif

struct	WALLCOLLISIONVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DXVECTOR3	n;	//	normal
};

class CWall : public CMesh
{
public:
	CWall(CD3DEnv *pEnv, TCHAR *pFname);
	virtual ~CWall();
	virtual void	SetWorldMatrix(D3DXMATRIX *pMat);
	virtual void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual float	GetBoundingSphere(D3DXVECTOR3 *pVec);
	virtual void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	virtual BOOL	ProbeTheWall(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDist);
	virtual BOOL	ProbeTheWallSinkDepth(D3DXVECTOR3 *pVec, FLOAT fRadius, D3DXVECTOR3 *pVecNormal, FLOAT *pDepth);
	virtual BOOL	CheckCollisionWithSegment(D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fRadius);
protected:
	virtual BOOL	ProbeTheTriangleDistanceWithSegment(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pVec1, D3DXVECTOR3 *pVec2, FLOAT fRadius);
	virtual BOOL	ProbeTheTriangleDistance(WALLCOLLISIONVERTEX *pTri, FLOAT *pDist, D3DXVECTOR3 *pPos, D3DXVECTOR3 *pBoxMin, D3DXVECTOR3 *pBoxMax, FLOAT fRadius, D3DXVECTOR3 *pNormal);
	virtual BOOL	Collide2Box(D3DXVECTOR3 *pMin1, D3DXVECTOR3 *pMax1, D3DXVECTOR3 *pMin2, D3DXVECTOR3 *pMax2);
	virtual void	MatrixInverseRotation(D3DXMATRIX *pOut, D3DXVECTOR3 *vecX,D3DXVECTOR3 *vecY,D3DXVECTOR3 *vecZ);
	virtual void	CalcShortestDistance(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist, D3DXVECTOR3 *pNormal);
	virtual void	CalcShortestDistance2(D3DXVECTOR3 *vecPos, WALLCOLLISIONVERTEX *vecP1, WALLCOLLISIONVERTEX *vecP2, float *pDist);
	D3DXMATRIX	m_matWorld;
};

#endif