//--------------------------------------------------------
//	class CShaderDB
//	desc: o[eNXVF[_Ǘf[^x[XB
//		f[^x[XGUID ŊǗAIɎg悤
//		ړIŗpӁB
//--------------------------------------------------------
#pragma once
#ifndef	__SHADERDB_H__
#define	__SHADERDB_H__

#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

#define	DEFAULT_VS_BUFFER_SIZE	20

typedef	struct	_vsid128{
	unsigned __int64	lower;
	unsigned __int64	upper;

	//
	//	rZq̐錾@@
	//
	bool	operator<(struct _vsid128 &right){
		if (upper > right.upper)
			return	false;
		if (upper < right.upper)
			return	true;
		if (lower >= right.lower)
			return	false;
		return	true;
	}
	//
	//	rZq̐錾@
	//
	bool	operator==(struct _vsid128 &right){
		if (upper != right.upper || lower != right.lower)
			return	false;
		return	true;
	}
}	vsid128;

class	CShaderContainer;
class CShaderDB : public CGraphicsObject
{
public:
	CShaderDB(CD3DEnv	*pEnv);
	virtual ~CShaderDB(void);
	virtual HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual void RemoveShaderContainer(GUID guid);
	virtual HRESULT	AddShaderContainer(CShaderContainer *pContainer);
	virtual CShaderContainer *GetShaderContainer(GUID guid);
	virtual	CD3DEnv *GetEnv(){	return	m_pEnv;	}
protected:
	virtual int	SearchShaderIndex(GUID guid);
	CShaderContainer	**m_pShaders;
	INT						m_numShaders;
	INT						m_numBuffers;
	CD3DEnv					*m_pEnv;
};

#endif