#pragma once
#ifndef	__SHADERCONTAINER_H__
#define	__SHADERCONTAINER_H__
#include "ShaderDB.h"

#ifndef	__GRAPHICSOBJECT_H__
#include "GraphicsObject.h"
#endif

class CShaderContainer : public CGraphicsObject
{
	friend class CShaderDB;
public:
	CShaderContainer(CD3DEnv *pEnv, GUID guid);
	virtual ~CShaderContainer(void);
	virtual	HRESULT	RestoreDeviceObjects(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	HRESULT	InvalidateDeviceObjects();
	virtual	void	Release();
	virtual void	AddRef();
	virtual LPDIRECT3DVERTEXSHADER9 GetDXVertexShader();
	virtual LPDIRECT3DPIXELSHADER9	GetDXPixelShader();

protected:
	virtual	void	ClearDBReference();
	vsid128		m_guid;
	CD3DEnv		*m_lpD3DEnv;
	CShaderDB	*m_pDB;
	int			m_iRefCount;
};

#endif
