#ifndef	__SWISHEFFECT_H__
#define	__SWISHEFFECT_H__

typedef struct _swishparticle{
	struct _swishparticle *prev;
	struct _swishparticle *next;
	D3DXVECTOR3			vec1;
	D3DXVECTOR3			vec2;
	FLOAT	elapsed;
}	SWISHEFFECT_PARTICLE;

class CSwishEffect
{
public:
	CSwishEffect(CD3DEnv *pEnv);
	virtual ~CSwishEffect(void);
	virtual void	Update(FLOAT timeElapsed);
	virtual void	Render(LPDIRECT3DDEVICE9 lpd3ddev,LPD3DXVECTOR3 pVec1, LPD3DXVECTOR3 pVec2, LPDIRECT3DTEXTURE9 pTex = NULL);
	virtual void	SetTipColor(D3DCOLOR diffuse);
	virtual void	SetTailColor(D3DCOLOR diffuse);
	virtual void	SetLifeSpan(FLOAT span);
	virtual	void	SetInterval(FLOAT interval);
	virtual	void	SetOpacity(FLOAT opacity);
	virtual	void	Activate(BOOL bActive){	m_bActive = bActive;	}
protected:
	CD3DEnv					*m_pEnv;
	SWISHEFFECT_PARTICLE	*m_pRoot;
	SWISHEFFECT_PARTICLE	m_particleDummy;
	FLOAT					m_fTime;
	FLOAT					m_fLifeSpan;
	FLOAT					m_fInterval;
	D3DCOLORVALUE			m_colorTip;
	D3DCOLORVALUE			m_colorTail;
	FLOAT					m_fOpacity;
	INT						m_iNumParticles;
	BOOL					m_bActive;
};
#define	MAX_NUM_VERTEX	256
struct	SWISHEFFECTVERTEX
{
	D3DXVECTOR3	p;	//	position
	D3DCOLOR	color;
	FLOAT		tu,tv;
};
#define	SWISHEFFECTVERTEXFVF	(D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)


#endif