#include "StdAfx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"

#include "d3d9env.h"
#include "swisheffect.h"

//---------------------------------------------
//	Name : CSwishEffect
//	Desc : RXgN^
//---------------------------------------------
CSwishEffect::CSwishEffect(CD3DEnv *pEnv)
{
	m_pEnv = pEnv;
	m_particleDummy.next = &m_particleDummy;
	m_particleDummy.prev = &m_particleDummy;
	m_pRoot = &m_particleDummy;
	m_fTime = 0;
	m_fInterval = 1.2f;
	m_fLifeSpan = 18.0f;

	m_colorTip.r = 1.0f;
	m_colorTip.g = 1.0f;
	m_colorTip.b = 1.0f;
	m_colorTip.a = 1.0f;
	m_colorTail.r = 1.0f;
	m_colorTail.g = 0.3f;
	m_colorTail.b = 0.3f;
	m_colorTail.a = 1.0f;
	m_fOpacity = 1.0f;
	m_iNumParticles = 0;
	m_bActive = TRUE;
}

//---------------------------------------------
//	Name : ~CSwishEffect
//	Desc : fXgN^
//---------------------------------------------
CSwishEffect::~CSwishEffect(void)
{
	SWISHEFFECT_PARTICLE	*pTmp, *pNext;
	pTmp = m_pRoot->next;
	while(pTmp != m_pRoot){
		pNext = pTmp->next;
		delete	pTmp;
		pTmp = pNext;
	}
}

//---------------------------------------------
//	Name: SetTipColor
//	Desc: c̐FݒEE[
//---------------------------------------------
void CSwishEffect::SetTipColor(D3DCOLOR diffuse){
	static const FLOAT fInv = 1.0f / 255.0f;
	m_colorTip.r = ((diffuse >> 16) & 255) * fInv;
	m_colorTip.g = ((diffuse >> 8) & 255) * fInv;
	m_colorTip.b = ((diffuse ) & 255) * fInv;
	m_colorTip.a = 0;
}

//---------------------------------------------
//	Name: SetTailColor
//	Desc: c̐FݒEE
//---------------------------------------------
void CSwishEffect::SetTailColor(D3DCOLOR diffuse){
	static const FLOAT fInv = 1.0f / 255.0f;
	m_colorTail.r = ((diffuse >> 16) & 255) * fInv;
	m_colorTail.g = ((diffuse >> 8) & 255) * fInv;
	m_colorTail.b = ((diffuse ) & 255) * fInv;
	m_colorTail.a = 0;
}


//---------------------------------------------
//	Name: SetInterval
//	Desc: c̔pxݒ
//---------------------------------------------
void CSwishEffect::SetInterval(FLOAT interval){
	m_fInterval = interval;
}

//---------------------------------------------
//	Name: SetLifeSpan
//	Desc: c̐
//---------------------------------------------
void CSwishEffect::SetLifeSpan(FLOAT span){
	m_fLifeSpan = span;
}

//---------------------------------------------
//	Name: SetOpacity
//	Desc: c̕sxݒ
//---------------------------------------------
void CSwishEffect::SetOpacity(FLOAT opacity){
	m_fOpacity = opacity;
}
//---------------------------------------------
//	Name: Update
//	Desc: Aj[VB
//---------------------------------------------
void	CSwishEffect::Update(FLOAT timeElapsed){

	SWISHEFFECT_PARTICLE	*pNew;

	if (timeElapsed > 2.0f)
		timeElapsed = 2.0f;

	if (m_pRoot->next == m_pRoot && m_bActive){
		pNew = new SWISHEFFECT_PARTICLE;
		pNew->prev = m_pRoot->prev;
		pNew->next = m_pRoot;
		m_pRoot->prev->next = pNew;
		m_pRoot->prev = pNew;
		pNew->elapsed = 0;
		m_iNumParticles = 1;
		return;
	}
	
	SWISHEFFECT_PARTICLE	*pTmp, *pNext;
	pTmp = m_pRoot->next;
	FLOAT	fSpanOfLife = m_fLifeSpan + m_fInterval*4;
	DWORD	num = 0;
	while(pTmp->next != m_pRoot){
		pNext = pTmp->next;
		pTmp->elapsed += timeElapsed;
		if (pTmp->elapsed >= fSpanOfLife){
			pTmp->prev->next = pTmp->next;
			pTmp->next->prev = pTmp->prev;
			delete	pTmp;
		}else{
			num++;
		}
		pTmp = pNext;
	}
	m_iNumParticles = num;

	m_fTime += timeElapsed;
	if (m_fTime >= m_fInterval){
		m_fTime -= m_fInterval * (FLOAT)((INT)(m_fTime / m_fInterval));
		if (m_bActive){
			pNew = new SWISHEFFECT_PARTICLE;
			pNew->vec1 = m_pRoot->next->vec1;	//	Öׂ̏l
			pNew->vec2 = m_pRoot->next->vec2;	//	Öׂ̏l
			pNew->prev = m_pRoot;
			pNew->next = m_pRoot->next;
			m_pRoot->next->prev = pNew;
			m_pRoot->next = pNew;
			pNew->elapsed = 0;
			m_iNumParticles++;
		}
	}else if (m_bActive){
	}
}

//-------------------------------------------------------------
//	Name: Render
//	Desc: c̕`
//	Args:	lpd3ddev: `\ȃfoCX
//			pVec1   : ̐[ʒuxNgւ̃|C^
//			pVec1   : ̍ʒuxNgւ̃|C^
//			pTex    : cɓ\teNX` NULL 
//-------------------------------------------------------------
void	CSwishEffect::Render(LPDIRECT3DDEVICE9 lpd3ddev,LPD3DXVECTOR3 pVec1, LPD3DXVECTOR3 pVec2, LPDIRECT3DTEXTURE9 pTex){
	SWISHEFFECT_PARTICLE	*pTmp;
	INT	ix = 0;
	SWISHEFFECTVERTEX	vec[MAX_NUM_VERTEX];
	FLOAT	fOpacity;
	FLOAT	fSpanInv = 1.0f / m_fLifeSpan;
	FLOAT	fNumInv = 1.0f / (FLOAT)(m_iNumParticles);
	pTmp = m_pRoot->next;
	if (m_bActive){
		pTmp->vec1 = *pVec1;
		pTmp->vec2 = *pVec2;
	}
	D3DCOLORVALUE	colorTmp;
	D3DCOLOR	diffuse;
	INT	ir,ig,ib;
	while(pTmp->next != m_pRoot){
		fOpacity = m_fLifeSpan - pTmp->elapsed;
		fOpacity *= fSpanInv;
		if (fOpacity < 0)
			fOpacity = 0.0f;

		colorTmp.r = m_colorTip.r * fOpacity + m_colorTail.r * (1.0f-fOpacity);
		colorTmp.g = m_colorTip.g * fOpacity + m_colorTail.g * (1.0f-fOpacity);
		colorTmp.b = m_colorTip.b * fOpacity + m_colorTail.b * (1.0f-fOpacity);
		fOpacity *= m_fOpacity;
		
		ir = (INT)(colorTmp.r * 255.0f);
		ig = (INT)(colorTmp.g * 255.0f);
		ib = (INT)(colorTmp.b * 255.0f);
		diffuse = D3DCOLOR_ARGB((INT)(255.5f*fOpacity),ir,ig,ib);
		vec[ix].p = pTmp->vec1;
		vec[ix].color = diffuse;
		vec[ix].tu = ix * fNumInv * 0.5f;
		vec[ix].tv = 0;
		vec[ix+1].tu = vec[ix].tu;
		vec[ix+1].p = pTmp->vec2;
		vec[ix+1].color = diffuse;
		vec[ix+1].tv = 1.0f;
		ix+=2;
		if (ix >= MAX_NUM_VERTEX)
			break;
		pTmp = pTmp->next;
	}
	if (ix > 2){
		lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		lpd3ddev->SetRenderState(D3DRS_LIGHTING, FALSE );
		lpd3ddev->SetVertexShader(NULL);	//	ftHg̒_VF[_ݒB
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
		lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);
		lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
		lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
		lpd3ddev->SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE);

		if (pTex != NULL){
			lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
			lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP,  D3DTOP_MODULATE);
			lpd3ddev->SetTexture(0,pTex);		
		}else{
			lpd3ddev->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG2);
			lpd3ddev->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
			lpd3ddev->SetTexture(0,NULL);
		}

		lpd3ddev->SetFVF(SWISHEFFECTVERTEXFVF);
		lpd3ddev->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP,ix - 2,vec,D3DXGetFVFVertexSize(SWISHEFFECTVERTEXFVF));
	}
}

