#pragma once

#ifndef	__MTANIMATOR_H__
#include "MTAnimator.h"
#endif

#ifndef	__SWISHEFFECT_H__
#include "SwishEffect.h"
#endif

void	InitPlayerGraphics(CD3DEnv *pEnv);
void	DeletePlayerGraphics();

#define	PLAYER_PHASE_IDLE	100
#define	PLAYER_PHASE_WALK	200
#define	PLAYER_PHASE_ATTACK	300
#define	PLAYER_PHASE_DAMAGE	400

class CPlayer
{
public:
	CPlayer(CD3DEnv *pEnv);
	virtual ~CPlayer(void);
	virtual void	Update(FLOAT timeElapsed);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	SetIdle();
	virtual	void	SetWalk();
	virtual	void	SetAttack();
	virtual	void	SetDamage();

protected:
	CD3DEnv			*m_pEnv;
	CSwishEffect	*m_pSwish;
	CMTAnimator		*m_pAnimator;
	INT				m_iPhase;
	BOOL			m_bDrawBones;
	BOOL			m_bDrawModel;
	BOOL			m_bKey;
	FLOAT			m_fAngle;
	FLOAT			m_fTime;
};
