#include "StdAfx.h"
#include <d3dx9.h>
#include <stdio.h>
#include "D3DQuickLib.h"
#include "MTAnimator.h"
#include "SwishEffect.h"
#include ".\player.h"

CSkinnedMesh	*g_pMesh = NULL;	//	XLbV
CSkinMeshFrameTracker *g_pTracker = NULL;	//	{[ǐՃNX
CTextureNode	*g_pTexture = NULL;
void	InitPlayerGraphics(CD3DEnv *pEnv){
	g_pMesh = new CSkinnedMesh(pEnv,"Hito\\Hito.x");
	g_pTracker = new CSkinMeshFrameTracker(pEnv,g_pMesh,"Frame18_LeftHand");
//	TCHAR	tmpStr[MAX_PATH];
//	_tcscpy(tmpStr,pEnv->GetAppPathName());
//	_tcscat(tmpStr,"\\");
//	_tcscat(tmpStr,"Swish\\Swish.dds");
//	pEnv->TextureDBRegisterNewKey(tmpStr,&g_pTexture);
}
void	DeletePlayerGraphics(){
	SAFE_RELEASE(g_pTexture);
	SAFE_DELETE(g_pTracker);
	SAFE_DELETE(g_pMesh);
}

CPlayer::CPlayer(CD3DEnv *pEnv)
{
	m_pEnv = pEnv;
	m_pAnimator = NULL;
	m_pSwish = NULL;
	m_bDrawBones = TRUE;
	m_bDrawModel = FALSE;
	m_bKey = FALSE;
	m_fTime = 0.0f;
	m_fAngle = 0.0f;
	m_iPhase = PLAYER_PHASE_IDLE;
	m_pSwish = new CSwishEffect(m_pEnv);
	m_pSwish->SetOpacity(0.5f);
	m_pSwish->Activate(FALSE);
	m_pAnimator = new CMTAnimator(m_pEnv, g_pMesh);
	m_pAnimator->SetSpeed(1.0f/3600.0f);
	m_pAnimator->SetActiveTrack(0,1);

}

CPlayer::~CPlayer(void)
{
	SAFE_DELETE(m_pSwish);
	SAFE_DELETE(m_pAnimator);
}

//-------------------------------------------
//	Name : Update
//	Desc : v[̃Aj[V
//-------------------------------------------
void	CPlayer::Update(FLOAT timeElapsed){

	//	L[Ή
	if (m_pEnv->GetDI8KeyState(DIK_1)){
		if (!m_bKey)
			SetIdle();
		m_bKey = true;
	}else if (m_pEnv->GetDI8KeyState(DIK_2)){
		if (!m_bKey)
			SetWalk();
		m_bKey = true;
	}else if (m_pEnv->GetDI8KeyState(DIK_3)){
		if (!m_bKey)
			SetAttack();
		m_bKey = true;
	}else if (m_pEnv->GetDI8KeyState(DIK_4)){
		if (!m_bKey)
			SetDamage();
		m_bKey = true;
	}else if (m_pEnv->GetDI8KeyState(DIK_F1)){
		if (!m_bKey)
			m_bDrawBones = !m_bDrawBones;
		m_bKey = true;
	}else if (m_pEnv->GetDI8KeyState(DIK_F2)){
		if (!m_bKey)
			m_bDrawModel = !m_bDrawModel;
		m_bKey = true;
	}else{
		m_bKey = false;
	}

	m_fTime += timeElapsed;

	switch(m_iPhase){
		case	PLAYER_PHASE_IDLE:
		case	PLAYER_PHASE_WALK:
			m_pSwish->Activate(FALSE);
			m_fTime = 0;
			break;
		case	PLAYER_PHASE_ATTACK:
			DOUBLE	dbl;
			dbl = m_pAnimator->GetCurrentPosition();
			if (dbl < 0.0042f || dbl > 0.0075f){
				m_pSwish->Activate(FALSE);
			}else{
				m_pSwish->Activate(TRUE);
			}
			if (m_fTime > 60.0f){
				SetIdle();
			}
			break;
		case	PLAYER_PHASE_DAMAGE:
			m_pSwish->Activate(FALSE);
			if (m_fTime > 60.0f){
				SetIdle();
			}
			break;
	}
	m_fAngle += (D3DX_PI * 0.01f) * timeElapsed;
	if (m_fAngle > (D3DX_PI * 2.0f))
		m_fAngle -= (D3DX_PI * 2.0f);
	D3DXMATRIX	matWorld;
	D3DXMatrixRotationY(&matWorld,m_fAngle);



	m_pAnimator->Update(timeElapsed,&matWorld);
	m_pSwish->Update(timeElapsed);
}

//-------------------------------------------
//	Name : Render
//	Desc : v[̕`
//-------------------------------------------
void CPlayer::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	if (m_pAnimator == NULL || m_pSwish == NULL)
		return;
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, FALSE );
	
	if (m_bDrawModel){
		m_pAnimator->Render(lpd3ddev);
	}else if (m_bDrawBones)
		m_pAnimator->RenderBones(lpd3ddev);
	else
		m_pAnimator->UpdateBones();

	D3DXVECTOR3	vec[2];
	D3DXMATRIX	mat;
	vec[0] = D3DXVECTOR3(0,0,0);
	vec[1] = D3DXVECTOR3(0,0,0);
	g_pTracker->GetFrameMatrix(&mat);
	D3DXVec3TransformCoord(&vec[0],&vec[0],&mat);
	g_pTracker->GetParentFrameMatrix(&mat);
	D3DXVec3TransformCoord(&vec[1],&vec[1],&mat);
	m_pEnv->RenderLine3D(vec,D3DCOLOR_XRGB(255,96,96));
	if (g_pTexture)
		m_pSwish->Render(lpd3ddev,&vec[0],&vec[1],g_pTexture->GetTexture());
	else
		m_pSwish->Render(lpd3ddev,&vec[0],&vec[1]);

	m_pEnv->SystemD3DFont()->DrawText(10.0f,10.0f,D3DCOLOR_XRGB(255,255,255),
		_T("Press \'3\' key to see how this effect works."));

	m_pEnv->SystemD3DFont()->DrawText(10.0f,30.0f,D3DCOLOR_XRGB(255,255,255),_T("Key 1 --- Idle"));
	m_pEnv->SystemD3DFont()->DrawText(10.0f,50.0f,D3DCOLOR_XRGB(255,255,255),_T("Key 2 --- Walk"));
	m_pEnv->SystemD3DFont()->DrawText(10.0f,70.0f,D3DCOLOR_XRGB(255,255,255),_T("Key 3 --- Attack"));
	m_pEnv->SystemD3DFont()->DrawText(10.0f,90.0f,D3DCOLOR_XRGB(255,255,255),_T("Key 4 --- Damage"));

	m_pEnv->SystemD3DFont()->DrawText(10.0f,110.0f,D3DCOLOR_XRGB(255,255,255),_T("F1 --- Toggle bones."));
	m_pEnv->SystemD3DFont()->DrawText(10.0f,130.0f,D3DCOLOR_XRGB(255,255,255),_T("F2 --- Toggle model."));
}

//-------------------------------------------------
//	Name: SetIdle
//	Desc: v[AChOXe[gɕύX
//-------------------------------------------------
void	CPlayer::SetIdle(){
	m_fTime = 0.0f;
	m_pAnimator->SetActiveTrack(0,18);
	m_iPhase = PLAYER_PHASE_IDLE;

}

//-------------------------------------------------
//	Name: SetWalk
//	Desc: v[sXe[gɕύX
//-------------------------------------------------
void	CPlayer::SetWalk(){
	m_fTime = 0.0f;
	m_pAnimator->SetActiveTrack(1,18);
	m_iPhase = PLAYER_PHASE_WALK;
}


//-------------------------------------------------
//	Name: SetAttack
//	Desc: v[sXe[gɕύX
//-------------------------------------------------
void	CPlayer::SetAttack(){
	m_fTime = 0.0f;
	m_pAnimator->SetActiveTrack(2,4,FALSE);
	m_iPhase = PLAYER_PHASE_ATTACK;
}

//-------------------------------------------------
//	Name: SetDamage
//	Desc: v[_[WXe[gɕύX
//-------------------------------------------------
void	CPlayer::SetDamage(){
	m_fTime = 0.0f;
	m_pAnimator->SetActiveTrack(3,4,FALSE);
	m_iPhase = PLAYER_PHASE_DAMAGE;
}

