
#ifndef	__MTANIMATOR_H__
#define	__MTANIMATOR_H__

#ifndef	__SKINNEDMESH_H__
#include "SkinnedMesh.h"
#endif

#define	MULTITRACK_ANIM_PHASE_RUN		1
#define	MULTITRACK_ANIM_PHASE_TRANSIT	2

//	tO
#define	MULTITRACK_ANIM_LOOP	1
#define	MULTITRACK_ANIM_STOPPED	2

class CMTAnimator
{
public:
	CMTAnimator(CD3DEnv *pEnv, CSkinnedMesh *pMesh);
	virtual ~CMTAnimator();
	virtual	DWORD	GetNumTracks();
	virtual	void	Update(FLOAT fTime, D3DXMATRIX *matWorld);
	virtual	void	SetActiveTrack(INT tno, FLOAT fTime, BOOL bLoop = TRUE);
	virtual	void	SetSpeed(FLOAT fSpeed);
	virtual	void	Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	RenderBones(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	UpdateBones();
	virtual	void	Reset();
	virtual DOUBLE	GetCurrentPosition();
protected:
	virtual	DOUBLE	DecDouble(DOUBLE v);
	virtual	void	AdjustTracks();

	CD3DEnv	*m_pEnv;
	CSkinnedMesh *m_pMesh;
	DWORD	m_dwAnimationPhase;
	INT		m_iActiveTrack[2];
	DOUBLE	m_fTrackTime[2];	//	
	DWORD	m_dwFlags[2];		//	tO
	FLOAT	m_fPriorityBlend;
	FLOAT	m_fBlendDiff;
	FLOAT	m_fSpeed;
	D3DXMATRIX m_matWorld;
};

#endif
