// MTAnimator.cpp: CMTAnimator NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "MTAnimator.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CMTAnimator::CMTAnimator(CD3DEnv *pEnv, CSkinnedMesh *pMesh)
{
	m_pEnv = pEnv;
	m_pMesh = pMesh;
	Reset();
}

CMTAnimator::~CMTAnimator()
{
}

//-----------------------------------------------------------
//	Name : Reset
//	Desc : Aj[VԂɖ߂
//-----------------------------------------------------------
void	CMTAnimator::Reset(){
	m_iActiveTrack[0] = 0;
	m_iActiveTrack[1] = -1;
	m_fTrackTime[0] = 0;
	m_fTrackTime[1] = 0;
	m_dwFlags[0] = MULTITRACK_ANIM_LOOP;
	m_dwFlags[1] = MULTITRACK_ANIM_LOOP;
	m_dwAnimationPhase = MULTITRACK_ANIM_PHASE_RUN;
	m_fPriorityBlend = 0.0f;
	m_fBlendDiff = 0.0f;
	m_fSpeed = 1.0f;
	D3DXMatrixIdentity(&m_matWorld);
}

//-----------------------------------------------------------
//	Name : GetNumTracks
//	Desc : }`gbNAj[ṼgbNԂ
//-----------------------------------------------------------
DWORD	CMTAnimator::GetNumTracks(){
	DWORD	dwNumTracks = 0;
	LPD3DXANIMATIONCONTROLLER	pAnim = NULL;
	if ((m_pMesh != NULL) && SUCCEEDED(m_pMesh->GetAnimationController(&pAnim))){
		dwNumTracks = pAnim->GetNumAnimationSets();
		pAnim->Release();
	}
	return	dwNumTracks;
}

//-----------------------------------------------------------
//	Name : Update
//	Desc : }`gbNAj[Vs
//-----------------------------------------------------------
void	CMTAnimator::Update(FLOAT fTime, D3DXMATRIX *pMatWorld){
	int	i;
	DOUBLE period;
	LPD3DXANIMATIONCONTROLLER	pAnim = NULL;
	LPD3DXANIMATIONSET			pAnimSet = NULL;

	m_matWorld = *pMatWorld;
	if (SUCCEEDED(m_pMesh->GetAnimationController(&pAnim))){

		for ( i = 0; i < 2 ; ++i ){
			if (0 > m_iActiveTrack[i])
				continue;
			if ((m_dwFlags[i] & MULTITRACK_ANIM_STOPPED) != 0)
				continue;
			m_fTrackTime[i] += fTime * m_fSpeed;
			if (SUCCEEDED(pAnim->GetAnimationSet(m_iActiveTrack[i],&pAnimSet))){
				period = pAnimSet->GetPeriod();	//	[v
				if (m_fTrackTime[i] >= period){
					if (m_dwFlags[i]){
						INT	a = (INT)(m_fTrackTime[i] / period);
						m_fTrackTime[i] -= period * (double)a;
					}else{
						//	
						//	m_fTrackTime[i] = DecDouble(period);
						//	C}C`smȃAj[Vf[^fo\tg悤A
						//	߂ɖ߂Ă
						m_fTrackTime[i] = period - m_fSpeed*0.1f;
						m_dwFlags[i] |= MULTITRACK_ANIM_STOPPED;
					}
				}
				pAnimSet->Release();
			}
		}
		pAnim->Release();
	}
	switch(this->m_dwAnimationPhase){
		case	MULTITRACK_ANIM_PHASE_TRANSIT:
			m_fPriorityBlend -= m_fBlendDiff * fTime;
			if (m_fPriorityBlend < FLT_MIN){
				m_iActiveTrack[1] = -1;
				m_fPriorityBlend = 0.0f;
				m_dwAnimationPhase = MULTITRACK_ANIM_PHASE_RUN;
			}
			break;
		default:
			break;
	}
}

//-----------------------------------------------------------
//	Name : SetActiveTrack
//	Desc : Double ^̃XJ[f[^ق̏Oɋ߂Â
//	Param:  v   : {x(DOUBLE)l
//-----------------------------------------------------------
DOUBLE	CMTAnimator::DecDouble(DOUBLE v){
	DOUBLE	result;
	unsigned __int64	ui64End =*(unsigned __int64*)&v;
	unsigned __int64	ui64Exp = ui64End;
	unsigned __int64	ui64Sign =ui64End;
	unsigned __int64	ui64FracMask = 0x000fffffffffffff;

	ui64Exp  &= 0x7ff0000000000000;	//	wo
	ui64Sign &= 0x8000000000000000;	//	o

	if (ui64Exp <= 0x0010000000000000){
		result = 0.0;	//	ɏl̓[ɃNbv
	}else{
		//	炷
		if ((ui64End & ui64FracMask) != 0){
			ui64End--;
		}else{
			ui64Exp -= 0x0010000000000000;
			ui64End = 0x000fffffffffffff | ui64Exp;
		}
		ui64End |= ui64Sign;
		result = *(double*)&ui64End;
	}
	return	result;
}
//-----------------------------------------------------------
//	Name : SetActiveTrack
//	Desc : Aj[VgbNw肷
//	Param:  tno   : Aj[VgbNԍ
//			fTime : gbNւ܂ł̎ԂwB
//-----------------------------------------------------------
void	CMTAnimator::SetActiveTrack(INT tno, FLOAT fTime, BOOL bLoop){
	if (fTime < FLT_MIN)
		fTime = 1.0f;
	m_iActiveTrack[1] = m_iActiveTrack[0];
	m_fTrackTime[1] = m_fTrackTime[0];
	m_dwFlags[1] = m_dwFlags[0];
	m_fPriorityBlend = 1.0f;
	m_iActiveTrack[0] = tno;
	m_fTrackTime[0] = 0.0;
	m_dwFlags[0] = (bLoop)?(MULTITRACK_ANIM_LOOP):(0);

	m_fBlendDiff = 1.0f / fTime;
	m_dwAnimationPhase = MULTITRACK_ANIM_PHASE_TRANSIT;
}

//-----------------------------------------------------------
//	Name : SetSpeed
//	Desc : Aj[ṼXs[hݒs
//-----------------------------------------------------------
void	CMTAnimator::SetSpeed(FLOAT fSpeed){
	m_fSpeed = fSpeed;
}

//-----------------------------------------------------------
//	Name : AdjustTracks
//	Desc : XLbṼAj[VgbN֔fB
//-----------------------------------------------------------
void	CMTAnimator::AdjustTracks(){
	int	tno, i;
	DWORD	dwNumTracks;
	LPD3DXANIMATIONCONTROLLER	pAnim = NULL;
	if (SUCCEEDED(m_pMesh->GetAnimationController(&pAnim))){
		dwNumTracks = pAnim->GetNumAnimationSets();
		LPD3DXANIMATIONSET	pAnimSet = NULL;
		for (i = 0 ; i < 2 ; ++i){
			tno = m_iActiveTrack[i];
			if (tno < 0){
				pAnim->SetTrackAnimationSet(i,NULL);
				pAnim->SetTrackEnable(i,false);
			}else{
				if (tno > (INT)dwNumTracks)
					tno = 0;
				if (SUCCEEDED(pAnim->GetAnimationSet(tno,&pAnimSet))){
					pAnim->SetTrackAnimationSet(i,pAnimSet);
					pAnim->SetTrackEnable(i,true);
					pAnim->SetTrackSpeed(i,1.0f);

#if D3DX_VERSION < 0x0902
					pAnim->SetTrackAnimTime(i,m_fTrackTime[i]);
#else
					pAnim->SetTrackPosition(i,m_fTrackTime[i]);
#endif
					pAnimSet->Release();
				}
			}
		}

#if D3DX_VERSION < 0x0902
		//
		//	DirectX9.0SDK ɂ͕sB
		//
		//	fobKN SetTrackWeight ŁA
		//	SetPriorityBlend L gbN̗D揇ʂ́A
		//	gbNԍ傫D̂悤B
		//	
		//	fobKłȂArht@CGNXv[
		//	NƁA삪܂قȂĂB
		//	SetPriorityBlend  SetTrackWeight Ƃgpł
		//	悤ɂȂ邪AgbN̗D揇ʂ̓gbNԍ
		//	DƂ݂Ȃ炵B
		//
		//	SetPriorityBlend ̓fobKNɍ킹ĂāA
		//	X^hA[pɂ́A SetTrackWeight ɂ
		//	Weight ݒsB
		//
		pAnim->SetPriorityBlend(m_fPriorityBlend);
		pAnim->SetTrackWeight(0,1.0f-m_fPriorityBlend);
		pAnim->SetTrackWeight(1,m_fPriorityBlend);
#else
		pAnim->SetTrackWeight(0,1.0f-m_fPriorityBlend);
		pAnim->SetTrackWeight(1,m_fPriorityBlend);
#endif

		pAnim->Release();
	}
}

//-----------------------------------------------------------
//	Name : Render
//	Desc : o^ꂽXLbV̕`
//-----------------------------------------------------------
void	CMTAnimator::Render(LPDIRECT3DDEVICE9 lpd3ddev){
	AdjustTracks();
	m_pMesh->ResetAnimationMatrices();
	m_pMesh->ResetAnimation(&m_matWorld,m_pEnv->GetSystemView());

	m_pMesh->Render(lpd3ddev);
}

//-----------------------------------------------------------
//	Name : RenderBones
//	Desc : o^ꂽXLbṼ{[`
//-----------------------------------------------------------
void	CMTAnimator::RenderBones(LPDIRECT3DDEVICE9 lpd3ddev){
	AdjustTracks();
	m_pMesh->ResetAnimationMatrices();
	m_pMesh->ResetAnimation(&m_matWorld,m_pEnv->GetSystemView());

	m_pMesh->RenderBones(lpd3ddev);
}

//-----------------------------------------------------------
//	Name : UpdateMatrices
//	Desc : o^ꂽXLbṼ{[`悹XV
//-----------------------------------------------------------
void	CMTAnimator::UpdateBones(){
	AdjustTracks();
	m_pMesh->ResetAnimationMatrices();
	m_pMesh->ResetAnimation(&m_matWorld,m_pEnv->GetSystemView());
}

//-----------------------------------------------------------
//	Name : GetCurrentPosition
//	Desc : Aj[V̌ݎԂԂB
//	Note :	Aj[Vf[^̐ΎԂԂׁA
//			Ԃ̒Pʂ́AfO\tgɈˑB
//-----------------------------------------------------------
DOUBLE	CMTAnimator::GetCurrentPosition(){
	return	m_fTrackTime[0];
}
