#include "stdafx.h"
#include <stdio.h>
#include <crtdbg.h>
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include "Grid02.h"
#include "Cursor.h"
#include "Effect.h"
#include "FireBall.h"
#include "BurnUp.h"
class    MyCD3DEnv : public CD3DEnv
{
public:
    DWORD    SelectMode(D3DModeInfo *modes, DWORD numModes);
};
//yI[o[[hɂA1024~768̃[hɐݒ肷z
DWORD    MyCD3DEnv::SelectMode(D3DModeInfo *modes, DWORD numModes)
{
    DWORD    dwCurrent = 0;
    // 𑜓x 1024x768 ̃[hlƂB
    //(sNZtH[}bg16rbg̃[hD悷)
    for(DWORD m=0L; m<numModes; m++ ){
        if( modes[m].Width==1024 && modes[m].Height==768 )
        {
            dwCurrent = m;
            if( modes[m].Format == D3DFMT_R5G6B5 ||
                modes[m].Format == D3DFMT_X1R5G5B5 ||
                modes[m].Format == D3DFMT_A1R5G5B5 )
            {
                break;
            }
        }
    }
    return    dwCurrent;
}

MyCD3DEnv    *g_pD3DEnv = NULL; // D3DQuickLib 񋟂`B
CFloor *g_pFloor = NULL;

CGameObject        *g_pRoot = NULL;
CGameObject        *g_pMoving = NULL;
CGameObject        *g_pAttacking = NULL;
CGameObject        *g_pBeingAttacked = NULL;

//    ړ̃R}ɂĂ̏
CGameObject        *g_pSelected = NULL;

CGrid    *g_pGrid = NULL;
int	g_iCX, g_iCZ;

CCursor         *g_pCursor = NULL;
BOOL            g_bMouseButton = false;
BOOL            g_bMouseButtonFlag = false;

BOOL            g_bMouseRButton = false;
BOOL            g_bMouseRButtonFlag = false;
CD3DKanjiFont    *g_pKanjiFont = NULL;

HWND g_hWnd = NULL;

LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

//	1205 step02
CEffect	*g_pEffect = NULL;	//	1205 step02

//----------------------------------------------
//	`ԂB	1205 step01
//----------------------------------------------
CD3DEnv	*GetD3DEnv(){
	return	g_pD3DEnv;
}
//----------------------------------------------
//	GtFNg̒ǉ	1205 step01
//----------------------------------------------
void	AddEffect(CEffect *pEffect){
	pEffect->m_pNext = g_pEffect;
	pEffect->m_pPrev = g_pEffect->m_pPrev;
	g_pEffect->m_pPrev->m_pNext = pEffect;
	g_pEffect->m_pPrev = pEffect;
}

//----------------------------------------------
//	GtFNg̍폜	1205 step02
//----------------------------------------------
void	SnipEffect(CEffect *pEffect){
	pEffect->m_pPrev->m_pNext = pEffect->m_pNext;
	pEffect->m_pNext->m_pPrev = pEffect->m_pPrev;
}


//------------------------------------------------------------
// Name: FrameMove
// Desc: Aj[VsB
//        UpdateScene ֐ R[obNB
//------------------------------------------------------------
void FrameMove(float timeElapsed)
{
    D3DXMATRIX    *pView;
    pView = g_pD3DEnv->GetSystemView();

    D3DXMatrixLookAtLH(pView,&D3DXVECTOR3(0,24.0f,-10.0f),            //    J̈ʒu
                             &D3DXVECTOR3( 0, 0, -0.5f ),        //    Jʒu
                             &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );    //    J̏

	//	GtFNgAjXV
	CEffect	*pEffect = g_pEffect->m_pNext;
	CEffect	*pNextEffect;
	while(pEffect != g_pEffect){
		pNextEffect = pEffect->m_pNext;
		if (pEffect->Update(timeElapsed)){
			SnipEffect(pEffect);
			delete	pEffect;
		}
		pEffect = pNextEffect;
	}

    //    }EXJ[\ʒu̎擾
    POINT    pt;
    GetCursorPos(&pt);
    ScreenToClient(g_hWnd,&pt);
	if (g_pCursor != NULL)
	    g_pCursor->Update(timeElapsed,(FLOAT)pt.x,(FLOAT)pt.y);    //    tXN[J[\̈ʒuXV

    //    QcW->ObhW֕ϊ
    g_pGrid->PtToGridColRow(g_pD3DEnv,&pt,&g_iCX,&g_iCZ);

    //    E}EX{^Ԃ̎擾
    BOOL    bRight = false;
    if (g_bMouseRButton){
        if (!g_bMouseRButtonFlag){
            bRight = true;
            g_bMouseRButtonFlag = true;
        }
    }

    //    }EX{^Ԃ̎擾
    BOOL    bLeft = false;
    if (g_bMouseButton){
        if (!g_bMouseButtonFlag){
            bLeft = true;
            g_bMouseButtonFlag = true;
        }
    }

	if (bLeft && (g_iCX != 0 || g_iCZ != 0)){
		//	NbNꂽGtFNg𔭐
		D3DXVECTOR3	vecMin, vecMax, vecSrc, vecDest;
		g_pGrid->GetGridGeometry(0,0,&vecMin, &vecMax);	//	Grid(0,0) ̍W擾
		vecSrc = (vecMin + vecMax) * 0.5f;

		g_pGrid->GetGridGeometry(g_iCX,g_iCZ,&vecMin, &vecMax);	//	J[\ʒu̍W擾
		vecDest = (vecMin + vecMax) * 0.5f;
		CEffect	*tmpEffect = new CFireBall(g_pD3DEnv,&vecSrc, &vecDest);
		::AddEffect(tmpEffect);
	}
}

//------------------------------------------------------------
// Name: RenderScene
// Desc: _OsB
//        UpdateScene ֐ R[obNB
//------------------------------------------------------------
void RenderScene(LPDIRECT3DDEVICE9 lpd3ddev)
{
    D3DXMATRIX    matWorld;
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, TRUE );
    lpd3ddev->SetRenderState(D3DRS_ZENABLE, TRUE );

    //    n``
    D3DXMatrixIdentity(&matWorld);
    g_pFloor->SetWorldMatrix(&matWorld);
    g_pFloor->Render(lpd3ddev);

    //  Ֆʂ`
    g_pGrid->Render(lpd3ddev);
	//	Ֆʏ̃J[\`
    g_pGrid->RenderCursor(g_pD3DEnv,g_iCX, g_iCZ);

	//	GtFNg̕`
	CEffect	*pEffect = g_pEffect->m_pNext;
	while(pEffect != g_pEffect){
		pEffect->Render(lpd3ddev);
		pEffect = pEffect->m_pNext;
	}
	g_pKanjiFont->DrawText(600,20,D3DCOLOR_XRGB(255,255,255),_T("ȊÕZōNbNĂ"));
	//	}EXJ[\̕`
	if (!g_pD3DEnv->IsWindowed())
        g_pCursor->Render(lpd3ddev);    //    J[\`
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
    WNDCLASSEX wcex;
    wcex.cbSize = sizeof(WNDCLASSEX); 
    wcex.style            = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = (WNDPROC)WndProc;
    wcex.cbClsExtra        = 0;
    wcex.cbWndExtra        = 0;
    wcex.hInstance        = hInstance;
    wcex.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    wcex.hCursor        = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
    wcex.hbrBackground    = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName    = NULL;
    wcex.lpszClassName    = "Game";
    wcex.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
    RegisterClassEx(&wcex);

    HWND hWnd;
    hWnd = CreateWindowEx(WS_EX_OVERLAPPEDWINDOW,wcex.lpszClassName,"Game",
                WS_VISIBLE|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX,
                CW_USEDEFAULT,0,640,480,NULL,NULL,hInstance,NULL);
    if( !hWnd )
        return FALSE;

    g_hWnd = hWnd;

    RECT    bounds,client;
    GetWindowRect(hWnd,&bounds);
    GetClientRect(hWnd,&client);
    MoveWindow(hWnd,bounds.left,bounds.top,
        1024 * 2 - client.right,
        768 * 2 - client.bottom,
        false );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    //    _~[m[h̐
    g_pRoot = new CGameObject();
    g_pRoot->m_pNext = g_pRoot->m_pPrev = g_pRoot;
    g_pMoving = new CGameObject();
    g_pMoving->m_pNext = g_pMoving->m_pPrev = g_pMoving;

    g_pAttacking = new CGameObject();
    g_pAttacking->m_pNext = g_pAttacking->m_pPrev = g_pAttacking;
    g_pBeingAttacked = new CGameObject();
    g_pBeingAttacked->m_pNext = g_pBeingAttacked->m_pPrev = g_pBeingAttacked;

	g_pEffect = new CEffect();
	g_pEffect->m_pNext = g_pEffect->m_pPrev = g_pEffect;

    //    D3DQuickLib ̏
    g_pD3DEnv = new MyCD3DEnv();
    if (FAILED(g_pD3DEnv->InitD3D(hWnd))){
        DestroyWindow(hWnd);
    }else{
        g_pFloor = new CFloor(g_pD3DEnv,"ground\\ground.x");
        g_pCursor = new CCursor(g_pD3DEnv);
        g_pKanjiFont = new CD3DKanjiFont(g_pD3DEnv,_T("lr SVbN"),20,D3DFONT_SIZE_IN_PIXELS);    // 1121 step1
		InitFireBallGraphics(g_pD3DEnv);
        g_pD3DEnv->ReloadGraphics();

		D3DXVECTOR3    vecMin, vecMax;
        g_pFloor->GetBoundingBox(&vecMin, &vecMax);
        g_pGrid = new CGrid02(g_pD3DEnv, &vecMin, &vecMax);

        int cols = (int)g_pGrid->GetNumColumns();
        int rows = (int)g_pGrid->GetNumRows();

    }

    MSG        msg;
    while(true){
        if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)){
            if(msg.message == WM_QUIT)
                break;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }else{
            g_pD3DEnv->UpdateScene(FrameMove,RenderScene);
        }
    }
    //    D3DQuickLib ̏I

    //    SL̏
    CGameObject    *tmp,*next;
    tmp = g_pRoot->m_pNext;
    while(tmp != g_pRoot){
        next = tmp->m_pNext;
        delete    tmp;
        tmp = next;
    }
    tmp = g_pMoving->m_pNext;
    while(tmp != g_pMoving){
        next = tmp->m_pNext;
        delete    tmp;
        tmp = next;
    }
    delete  g_pRoot;
    delete  g_pMoving;

	CEffect	*pEffect = g_pEffect->m_pNext;
	CEffect	*pNextEffect;
	while(pEffect != g_pEffect){
		pNextEffect = pEffect->m_pNext;
		delete	pEffect;
		pEffect = pNextEffect;
	}
	delete	g_pEffect;

	DeleteFireBallGraphics();
    SAFE_DELETE(g_pCursor);
    SAFE_DELETE(g_pFloor);
    SAFE_DELETE(g_pKanjiFont);    //    1121 step1
    SAFE_DELETE(g_pD3DEnv);
    
    return (int)msg.wParam;
}


LRESULT CALLBACK WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message){
        case    WM_SIZE:
            //    EChEő剻ꂽAtXN[[hɂB
            if (SIZE_MAXIMIZED == wParam){
                if (g_pD3DEnv->IsWindowed())
                    g_pD3DEnv->ToggleFullscreen();
            }
            break;
        case    WM_SETCURSOR:
            //    tXN[̓J[\\ȂB
            if (g_pD3DEnv->IsWindowed())
                ::SetCursor(::LoadCursor(NULL,IDC_ARROW));
            else
                ::SetCursor(NULL);
            break;
        case    WM_SYSCHAR:
            //    Alt-Enter ŃtXN[[h֐؂ւ
            if (lParam&0x20000000){
                if (wParam == '\x0d'){
                    g_pD3DEnv->ToggleFullscreen();
                    break;
                }
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_LBUTTONDOWN:
            if (g_iCX >= 0 && g_iCZ >= 0){
                g_bMouseButton = true;
            }
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_LBUTTONUP:
            g_bMouseButton = false;
            g_bMouseButtonFlag = false;
            return DefWindowProc( hWnd, message, wParam, lParam );            
        case    WM_RBUTTONDOWN:
            g_bMouseRButton = true;
            return DefWindowProc( hWnd, message, wParam, lParam );
        case    WM_RBUTTONUP:
            g_bMouseRButton = false;
            g_bMouseRButtonFlag = false;
            return DefWindowProc( hWnd, message, wParam, lParam );            

        case    WM_MOUSEMOVE:
            break;
        case    WM_SYSCOMMAND:
            if (!g_pD3DEnv->IsWindowed()){    //    tXN[
                if (wParam != SC_CLOSE)
                    break;

                //    WindowOWindow[hɖ߂ĂB
                g_pD3DEnv->ToggleFullscreen();
                Sleep(100);
            }
            return DefWindowProc( hWnd, message, wParam, lParam );

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return    0;
}
