#ifndef __GRID02_H__
#define __GRID02_H__

#ifndef __GRID_H__
#include "Grid.h"
#endif

#define    GRID02_COLUMNS    10
#define    GRID02_ROWS        10

class CGrid02 : public CGrid
{
public:
    CGrid02(CD3DEnv *pEnv, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
    virtual ~CGrid02(void);
    BOOL    GetGridGeometry(int c, int r, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
    CGameObject    *GetGridItem(int c, int r);
    void    SetGridItem(int c, int r, CGameObject *p);
    DWORD    GetNumColumns(){  return    m_dwWidth;    }
    DWORD    GetNumRows(){     return    m_dwHeight;   }
    void    Render(LPDIRECT3DDEVICE9 lpd3ddev);
	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	FLOAT	CalcDistance(int c1, int r1, int c2, int r2);
	void	PtToGridColRow(CD3DEnv *pEnv,LPPOINT pPt, int *c, int *r);

private:
    CD3DEnv    *m_pEnv;
    DWORD    m_dwWidth;
    DWORD    m_dwHeight;
    D3DXVECTOR3    m_vecMin;
    D3DXVECTOR3    m_vecMax;
    CGameObject    *m_arrayEnemies[GRID02_ROWS][GRID02_COLUMNS];
};

#endif
