#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\grid02.h"

CGrid02::CGrid02(CD3DEnv *pEnv, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax)
{
    m_pEnv = pEnv;
    m_vecMin = *pMin;
    m_vecMax = *pMax;
    m_dwWidth = GRID02_COLUMNS;
    m_dwHeight = GRID02_ROWS;
    ZeroMemory(m_arrayEnemies,sizeof(m_arrayEnemies));
}

CGrid02::~CGrid02(void)
{
}

BOOL CGrid02::GetGridGeometry(int c, int r, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
    if (c < 0 || r < 0)
        return    false;
    if ( c >= (int)m_dwWidth || r >= (int)m_dwHeight)
        return    false;

    D3DXVECTOR3    vecMin, vecMax;
    FLOAT    fWidth = (m_vecMax.x - m_vecMin.x) / (FLOAT)m_dwWidth;
    vecMin.x = fWidth * c + m_vecMin.x;
    vecMax.x = vecMin.x + fWidth;

	FLOAT	fR = (FLOAT)r;
	if ((c & 1) != 0){
		fR += 0.5f;
	}
    FLOAT    fDepth = (m_vecMin.z - m_vecMax.z) / (FLOAT)(m_dwHeight+0.5f);
    vecMax.z = fDepth * fR + m_vecMax.z;
    vecMin.z = vecMax.z + fDepth;

    vecMin.y = vecMax.y = m_vecMax.y;
    *pMin = vecMin;
    *pMax = vecMax;
    return    true;
}

CGameObject *CGrid02::GetGridItem(int c, int r){
    if (c < 0 || r < 0)
        return    NULL;
    if ( c >= (int)m_dwWidth || r >= (int)m_dwHeight)
        return    NULL;
    return    m_arrayEnemies[r][c];
}
void    CGrid02::SetGridItem(int c, int r, CGameObject *p){
    if (c < 0 || r < 0)
        return;
    if ( c >= (int)m_dwWidth || r >= (int)m_dwHeight)
        return;
    m_arrayEnemies[r][c] = p;
}

void CGrid02::Render(LPDIRECT3DDEVICE9 lpd3ddev){
    D3DXVECTOR3    vec[4];
    vec[0].y = vec[1].y = vec[2].y = vec[3].y = m_vecMax.y;

    lpd3ddev->SetRenderState(D3DRS_ZENABLE,TRUE);
    lpd3ddev->SetRenderState(D3DRS_LIGHTING, FALSE );
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
    lpd3ddev->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
    lpd3ddev->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

    int    c,r;
	FLOAT	a,b,h;
	D3DXVECTOR3	vecMin, vecMax;
	D3DXMATRIX	matProj = *m_pEnv->GetSystemProjection();
	FLOAT	fZCoeff = matProj._33;
	matProj._33 = fZCoeff - 1.0f / 32768;
	lpd3ddev->SetTransform( D3DTS_PROJECTION, &matProj);
    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	for (r = 0; r < (int)m_dwHeight ; ++r){
		for (c = 0; c < (int)m_dwWidth; ++c){
			this->GetGridGeometry(c,r,&vecMin, &vecMax);
			a = vecMax.x - vecMin.x;
			b = a * 3.0f / 8.0f;
			h = vecMax.z - vecMin.z;
			h *= 0.5f;

			vecMin.x -= (b * 0.5f);	//	ʒu𔼃}Xɂ点ĕ`
			vecMax.x -= (b * 0.5f);

			lpd3ddev->SetRenderState(D3DRS_ZENABLE, TRUE );
		    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE );
			vec[0].x = vecMin.x+b;    vec[0].z = vecMax.z;
			vec[1].x = vecMax.x;      vec[1].z = vecMax.z;
			vec[2].x = vecMin.x+b;    vec[2].z = vecMin.z;
			vec[3].x = vecMin.x;      vec[3].z = vecMin.z+h;
		    m_pEnv->RenderQuadrilateral3D(vec,D3DCOLOR_ARGB(64,255,255,255));
			vec[0].x = vecMax.x;      vec[0].z = vecMax.z;
			vec[1].x = vecMax.x+b;	  vec[1].z = vecMin.z+h;
			vec[2].x = vecMax.x;	  vec[2].z = vecMin.z;
			vec[3].x = vecMin.x+b;	  vec[3].z = vecMin.z;
		    m_pEnv->RenderQuadrilateral3D(vec,D3DCOLOR_ARGB(64,255,255,255));

		    lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE );
			matProj._33 = fZCoeff - 2.0f / 32768;
			lpd3ddev->SetTransform( D3DTS_PROJECTION, &matProj);
			vec[0].x = vecMax.x;	vec[0].z = vecMax.z;
			vec[1].x = vecMax.x+b;  vec[1].z = vecMin.z+h;
			m_pEnv->RenderLine3D(vec,D3DCOLOR_XRGB(0,0,0));
			vec[0].x = vecMax.x;	vec[0].z = vecMin.z;
			m_pEnv->RenderLine3D(vec,D3DCOLOR_XRGB(0,0,0));
			vec[1].x = vecMin.x+b;	vec[1].z = vecMin.z;
			m_pEnv->RenderLine3D(vec,D3DCOLOR_XRGB(0,0,0));
			lpd3ddev->SetTransform( D3DTS_PROJECTION, m_pEnv->GetSystemProjection());
		}
	}
}

void	CGrid02::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
	*pMin = m_vecMin;
	*pMax = m_vecMax;
}

FLOAT	CGrid02::CalcDistance(int c1, int r1, int c2, int r2){
	FLOAT	fR1 = (FLOAT)r1;
	FLOAT	fR2 = (FLOAT)r2;

	if ((c1&1)!=0)
		fR1 += 0.5f;
	if ((c2&1)!=0)
		fR2 += 0.5f;

	FLOAT	fW, fH, fDist;
	fH = (float)fabs(fR2-fR1);
	fW = (float)abs(c2-c1);
	fDist = fW;
	if (fH > fW * 0.5f){
		fDist += fH - fW*0.5f;
	}
	int	distance = (int)(fDist+0.5f);
	return	(FLOAT)distance;
}

void	CGrid02::PtToGridColRow(CD3DEnv *pEnv, LPPOINT pPt, int *c, int *r){
	FLOAT	u,v;
	PtToGridPosition(pEnv,pPt,&u,&v);
	*c = -1;
	*r = -1;
	if (u < 0 || u >= 1.0f){
		return;
	}
	int	col,row;
	FLOAT	numCol = (FLOAT)this->GetNumColumns();
	FLOAT	numRow = (FLOAT)this->GetNumRows();
	numRow += 0.5f;
	col = (int)(u*numCol);
	if ((col & 1) != 0){
		v -= 0.5f / numRow;
	}
	if (v < 0 || v >= 1.0f)
		return;
	row = (int)(v*numRow);
	if (row >= (int)this->GetNumRows())
		return;
	*c = col;
	*r = row;
}
