#ifndef __GRID_H__
#define __GRID_H__

class CGrid;  //  GameObject.h ̒ CGrid gp\ɂĂB

#ifndef    __GAMEOBJECT_H__
#include "GameObject.h"
#endif

class CGrid
{
public:
    CGrid(void);
    virtual ~CGrid(void);
    virtual BOOL    GetGridGeometry(int c, int r, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
    virtual CGameObject    *GetGridItem(int c, int r);
    virtual void    SetGridItem(int c, int r, CGameObject *p);
    virtual DWORD   GetNumColumns();
    virtual DWORD   GetNumRows();
    virtual BOOL    Update(FLOAT timeElapsed);
    virtual void    Render(LPDIRECT3DDEVICE9 lpd3ddev);
	virtual	void	GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax);
	virtual void	PtToGridPosition(CD3DEnv *pEnv,LPPOINT pPt, FLOAT *u, FLOAT *v);
	virtual	void	PtToGridColRow(CD3DEnv *pEnv,LPPOINT pPt, int *c, int *r);
	virtual	void	RenderCursor(CD3DEnv *pEnv, int c, int r);
	virtual void	RenderTransportationRange(CD3DEnv *pEnv, CGameObject *pObj);
	virtual BOOL	IntersectTriangle(D3DXVECTOR3 *pV1, D3DXVECTOR3 *pV2, D3DXVECTOR3 *pV3,
									D3DXVECTOR3 *pVp, D3DXVECTOR3 *pVr, FLOAT *u, FLOAT *v);
	virtual	FLOAT	CalcDistance(int c1, int r1, int c2, int r2);
	virtual void	RenderAttackableRange(CD3DEnv *pEnv, CGameObject *pObj);
};

#endif
