#include "stdafx.h"
#include <d3dx9.h>
#include "D3DQuickLib.h"
#include ".\grid.h"

CGrid::CGrid(void)
{
}

CGrid::~CGrid(void)
{
}
BOOL CGrid::GetGridGeometry(int c, int r, D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
    return    false;
}

CGameObject *CGrid::GetGridItem(int c, int r){
    return    NULL;
}

void    CGrid::SetGridItem(int c, int r, CGameObject *p){
}
BOOL    CGrid::Update(FLOAT timeElapsed){
    return    false;
}

void    CGrid::Render(LPDIRECT3DDEVICE9 lpd3ddev){
}

DWORD    CGrid::GetNumColumns(){
    return    0L;
}
DWORD    CGrid::GetNumRows(){
    return    0L;
}

void	CGrid::GetBoundingBox(D3DXVECTOR3 *pMin, D3DXVECTOR3 *pMax){
}

//==============================================================
//    function: MyIntersectTriangle
//    F  pV1 pV2 pV3 ̎O_ŎOp`gʂ
//            pVp pVr Ŏ钼Ƃ̌_ZoB
//            _͕Ԃ@u  v A
//            V1 + (V2 - V1)u + (V3 - V1)v ŎZołB
//            _Op`̓̏ꍇɂ́Atrue Ԃ
//            łȂꍇɂ́Afalse Ԃ
//            Direct3D ̊֐łAD3DXInterSectTriƂ
//            قȂOp`̊OłĂ_ԂB
//
//            A_ꍇɂ́Au v ƂɁA
//            -FLT_MAX ԂB
//            ܂ÃvO͎_̑OE̔
//            sĂȂ_ӂKvB
//==============================================================
BOOL    CGrid::IntersectTriangle(D3DXVECTOR3 *pV1, D3DXVECTOR3 *pV2, D3DXVECTOR3 *pV3,
                            D3DXVECTOR3 *pVp, D3DXVECTOR3 *pVr, FLOAT *u, FLOAT *v)
{
    //  ʂӖ
    //  V = V1 + (V2-V1)u + (V3-V1)v@
    //  ̕
    //  V = Vp + Vr*t  
    //  @(V2-V1)u + (V3 - V1)v + (-Vr)t = Vp - V1
    //   u, v, t ɂĉ𓾂鎖ŁA_ZoB

    double D,D1,D2;
    //  double D3;    //  t ͎ZosvB
    
    FLOAT    a11,a12,a13,c1;
    FLOAT    a21,a22,a23,c2;
    FLOAT    a31,a32,a33,c3;
    a11 = pV2->x - pV1->x;
    a12 = pV3->x - pV1->x;
    a13 = -pVr->x;
    c1 = pVp->x - pV1->x;

    a21 = pV2->y - pV1->y;
    a22 = pV3->y - pV1->y;
    a23 = -pVr->y;
    c2 = pVp->y - pV1->y;

    a31 = pV2->z - pV1->z;
    a32 = pV3->z - pV1->z;
    a33 = -pVr->z;
    c3 = pVp->z - pV1->z;

    D = a11*a22*a33 + a12*a23*a31 + a13*a32*a21 - a13*a22*a31 - a12*a21*a33 - a11*a32*a23;

    if (fabs(D) < FLT_MIN){
        //    _ꍇ
        *u = -FLT_MAX;
        *v = -FLT_MAX;
        return    false;
    }
    D1 = c1*a22*a33 + a12*a23*c3  + a13*a32*c2  - a13*a22*c3  - a12*c2*a33  - c1*a32*a23;
    D2 = a11*c2*a33 + c1*a23*a31  + a13*c3*a21  - a13*c2*a31  - c1*a21*a33  - a11*c3*a23;
//  D3 = a11*a22*c3 + a12*c2*a31  + c1*a32*a21  - c1*a22*a31  - a12*a21*c3  - a11*a32*c2;

    D = 1.0f/D;
    *u = (FLOAT)(D1 * D);
    *v = (FLOAT)(D2 * D);
    if (*u >= 0 && *v >= 0 && (*u+*v) <= 1.0f)
        return    true;
    return false;
}

void	CGrid::PtToGridPosition(CD3DEnv *pEnv, LPPOINT pPt, FLOAT *pU, FLOAT *pV)
{
	//	xNg֕ϊ
	D3DXMATRIX    *pMatProj;
	pMatProj = pEnv->GetSystemProjection();

	D3DXVECTOR3 vr;
	vr.x =  (((pPt->x *2.0f) / pEnv->GetBackBufferWidth()  ) - 1 ) / pMatProj->_11;
	vr.y = -(((pPt->y *2.0f) / pEnv->GetBackBufferHeight() ) - 1 ) / pMatProj->_22;
	vr.z =  1.0f;

	//    r[s̋tsZo
	D3DXMATRIX *pMatView;
	D3DXMATRIXA16 m;
	pMatView = pEnv->GetSystemView();
	D3DXMatrixInverse( &m, NULL, pMatView );

	D3DXVECTOR3 vecRayDir,vecRayOrg;

	vecRayDir.x  = vr.x*m._11 + vr.y*m._21 + vr.z*m._31;
	vecRayDir.y  = vr.x*m._12 + vr.y*m._22 + vr.z*m._32;
	vecRayDir.z  = vr.x*m._13 + vr.y*m._23 + vr.z*m._33;
	vecRayOrg.x = m._41;
	vecRayOrg.y = m._42;
	vecRayOrg.z = m._43;

	//	J[\W֕ϊ
	D3DXVECTOR3	vec[3];
	D3DXVECTOR3	vecMin, vecMax;
	this->GetBoundingBox(&vecMin, &vecMax);
	vec[0].x = vecMin.x;	vec[0].y = vecMax.y;	vec[0].z = vecMax.z;
	vec[1].x = vecMax.x;	vec[1].y = vecMax.y;	vec[1].z = vecMax.z;
	vec[2].x = vecMin.x;	vec[2].y = vecMax.y;	vec[2].z = vecMin.z;
	IntersectTriangle(&vec[0],&vec[1],&vec[2],
			&vecRayOrg,&vecRayDir,pU,pV);
}

void	CGrid::PtToGridColRow(CD3DEnv *pEnv, LPPOINT pPt, int *c, int *r){
	FLOAT	u,v;
	PtToGridPosition(pEnv,pPt,&u,&v);
	if (u < 0 || v < 0 || u >= 1.0f || v >= 1.0f){
		*c = -1;
		*r = -1;
	}else{
		DWORD	w,h;
		w = this->GetNumColumns();
		h = this->GetNumRows();
		*c = (int)(u*(FLOAT)w);
		*r = (int)(v*(FLOAT)h);
	}
}

void	CGrid::RenderCursor(CD3DEnv *pEnv, int c, int r){
	D3DXVECTOR3	vecMin, vecMax;
	if (this->GetGridGeometry(c,r,&vecMin, &vecMax)){
		D3DXVECTOR3    vec[4];
		vec[0].z = vec[1].z = vecMax.z;
		vec[2].z = vec[3].z = vecMin.z;
		vec[0].x = vec[3].x = vecMin.x;
		vec[1].x = vec[2].x = vecMax.x;
		vec[0].y = vec[1].y = vec[2].y = vec[3].y = vecMax.y;
		LPDIRECT3DDEVICE9	lpd3ddev;
		if (SUCCEEDED(pEnv->GetD3DDevice(&lpd3ddev))){
			lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			lpd3ddev->Release();
		}
		D3DXMATRIX	matProj = *pEnv->GetSystemProjection();
		FLOAT	fZCoeff = matProj._33;
		matProj._33 = fZCoeff - 3.0f / 32768;
		lpd3ddev->SetTransform( D3DTS_PROJECTION, &matProj);

		pEnv->RenderQuadrilateral3D(vec,D3DCOLOR_ARGB(64,255,0,0));

		matProj._33 = fZCoeff;
		lpd3ddev->SetTransform( D3DTS_PROJECTION, &matProj);

	}
}

void	CGrid::RenderTransportationRange(CD3DEnv *pEnv, CGameObject *pObj)
{
	DWORD	c,r,w,h;
	D3DXVECTOR3	vecMin, vecMax;
	LPDIRECT3DDEVICE9	lpd3ddev;
	if (pObj == NULL)
		return;
	w = this->GetNumColumns();
	h = this->GetNumRows();
	if (SUCCEEDED(pEnv->GetD3DDevice(&lpd3ddev))){
		lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		lpd3ddev->Release();
	}
	for (r = 0; r < h ; ++r){
		for (c = 0; c < w; ++c){
			if (pObj->CheckTransportationRange(this,c,r)){
				if (this->GetGridGeometry(c,r,&vecMin, &vecMax)){
					D3DXVECTOR3    vec[4];
					vec[0].z = vec[1].z = vecMax.z;
					vec[2].z = vec[3].z = vecMin.z;
					vec[0].x = vec[3].x = vecMin.x;
					vec[1].x = vec[2].x = vecMax.x;
					vec[0].y = vec[1].y = vec[2].y = vec[3].y = vecMax.y;
					pEnv->RenderQuadrilateral3D(vec,D3DCOLOR_ARGB(64,255,0,0));
				}
			}
		}
	}
}

//	U\͈͂̕\(1125 step03)
void	CGrid::RenderAttackableRange(CD3DEnv *pEnv, CGameObject *pObj)
{
	DWORD	c,r,w,h;
	D3DXVECTOR3	vecMin, vecMax;
	LPDIRECT3DDEVICE9	lpd3ddev;
	if (pObj == NULL)
		return;
	w = this->GetNumColumns();
	h = this->GetNumRows();
	if (SUCCEEDED(pEnv->GetD3DDevice(&lpd3ddev))){
		lpd3ddev->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		lpd3ddev->Release();
	}
	for (r = 0; r < h ; ++r){
		for (c = 0; c < w; ++c){
			if (pObj->CheckAttackableRange(this,c,r)){
				if (this->GetGridGeometry(c,r,&vecMin, &vecMax)){
					D3DXVECTOR3    vec[4];
					vec[0].z = vec[1].z = vecMax.z;
					vec[2].z = vec[3].z = vecMin.z;
					vec[0].x = vec[3].x = vecMin.x;
					vec[1].x = vec[2].x = vecMax.x;
					vec[0].y = vec[1].y = vec[2].y = vec[3].y = vecMax.y;
					pEnv->RenderQuadrilateral3D(vec,D3DCOLOR_ARGB(64,255,0,0));
				}
			}
		}
	}
}

FLOAT	CGrid::CalcDistance(int c1, int r1, int c2, int r2){
	FLOAT	fW, fH;
	fW = (FLOAT)(c2-c1);
	fH = (FLOAT)(r2-r1);
	fW *= fW;	fH *= fH;
	return	(FLOAT)sqrt((double)(fW+fH));
}
