#ifndef    __GAMEOBJECT_H__
#define    __GAMEOBJECT_H__

class	CGameObject;
#ifndef	__GRID_H__
#include "Grid.h"
#endif

class CGameObject
{
public:
    CGameObject *m_pNext;
    CGameObject *m_pPrev;
    CGameObject(void);
    virtual ~CGameObject(void);
    virtual BOOL    Update(float timeElapsed);
    virtual void    Render(LPDIRECT3DDEVICE9 lpd3ddev);
    virtual FLOAT   GetHP();
    virtual FLOAT   GetMP();
    virtual FLOAT   GetAP();
    virtual TCHAR   *GetName();
	virtual	void	SetGridPosition(int col, int row);
	virtual	void	GetGridPosition(int *pCol, int *pRow);
	virtual	BOOL	CheckTransportationRange(CGrid *pGrid, int dest_c, int dest_r);
	virtual	void	SetDestination(FLOAT x, FLOAT y, FLOAT z);
	virtual BOOL	MoveTo(float timeElapsed);
	virtual void	SetFriend(BOOL bFrend);
	virtual BOOL	IsFriend();
	virtual BOOL    CheckAttackableRange(CGrid *pGrid, int dest_c, int dest_r);
	virtual	void	SetAttackTarget(CGrid *pGrid, CGameObject *pObj,int num);
	virtual BOOL	WaitAttack(FLOAT timeElapsed);
	virtual	void	ResetDamage();
	virtual BOOL	IsAttacked();
	virtual void	AcceptDamage(FLOAT val);
	virtual BOOL	WaitDamage(FLOAT timeElapsed);
	virtual	BOOL	IsAlive();
	virtual	void	SetActionFlag( BOOL bAction){	m_bAction= bAction;	}
	virtual	BOOL	GetActionFlag(){	return	m_bAction;	}
protected:
	int			m_iCol;
	int			m_iRow;
	BOOL		m_bFriend;
	BOOL		m_bAttacked;
	D3DXVECTOR3	m_vecDestination;
	BOOL		m_bAction;
};
#endif

