//
//	class: CFireBall
//	Desc:  Visual Effect.
//
//	Note: p[eBNgpċOՕt̉΂̋ʂB
//	Author: Mr.K
//	First edition: Jan.26.2006
//
#pragma once
#ifndef	__FIREBALL_H__
#define	__FIREBALL_H__

#ifndef	__EFFECT_H__
#include "Effect.h"
#endif

//
//	Particle A
//
//	Ζ̋O՗pp[eBN
//
typedef	struct	_FIRE_PARTICLE_A{
	D3DXVECTOR3	p;
	FLOAT	t;
	struct	_FIRE_PARTICLE_A* prev;
	struct	_FIRE_PARTICLE_A* next;
}	FIRE_PARTICLE_A, *LPFIRE_PARTICLE_A;

#define	PARTICLE_START_FO_A	15		/*	tF[hAEgJn^C	*/
#define	PARTICLE_LIFETIME_A	24		/*		*/
#define	GRAVITY_A	0.01f			/*	d͉x	*/
#define	SPEED_A		0.3f			/*	ăXs[h	*/
#define	BLUR_EMITTING_FREQ	0.25f	/*	u[Ԋu	*/

#define	FIREBALL_PHASE_GO	0		/*	Ē	*/
#define	FIREBALL_PHASE_WAIT	1		/*	c҂	*/

class CFireBall : public CEffect
{
public:
	CFireBall(CD3DEnv *pEnv, D3DXVECTOR3 *pVecSrc, D3DXVECTOR3 *pVecDest);
	~CFireBall(void);
	virtual BOOL Update(FLOAT timeElapsed);
	virtual void Render(LPDIRECT3DDEVICE9 lpd3ddev);
protected:
	CD3DEnv		*m_lpD3DEnv;
	D3DXVECTOR3	m_vecOldPos;
	D3DXVECTOR3	m_vecCurrentPos;
	D3DXVECTOR3	m_vecDest;
	D3DXVECTOR3	m_vecVelocity;
	LPFIRE_PARTICLE_A	m_lpFireA;
	FIRE_PARTICLE_A		m_fireADummy;
	FLOAT	m_fBufferedTime;
	DWORD	m_dwPhase;
	DWORD	m_dwNumParticles;
};
void    InitFireBallGraphics(CD3DEnv *pEnv);
void    DeleteFireBallGraphics();
#endif
